/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.data.table.DataColumn;
import xyz.cofe.data.table.DataRow;
import xyz.cofe.data.table.DataTable;
import xyz.cofe.data.table.store.TableBuilder;
import xyz.cofe.fn.Fn1;

public class DataTableBuilder
implements TableBuilder {
    private static final Logger logger = Logger.getLogger(DataTableBuilder.class.getName());
    protected ClassLoader classLoader;
    protected DataTable dataTable;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DataTableBuilder.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DataTableBuilder.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DataTableBuilder.class.getName(), method, result);
    }

    @Override
    public synchronized ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    @Override
    public synchronized DataTable getDataTable() {
        if (this.dataTable != null) {
            return this.dataTable;
        }
        this.dataTable = new DataTable();
        return this.dataTable;
    }

    public synchronized void setDataTable(DataTable mt) {
        this.dataTable = mt;
    }

    @Override
    public synchronized void begin() {
        DataTable tbl = this.getDataTable();
        tbl.drop();
        tbl.setTrackChanges(false);
    }

    @Override
    public synchronized void beginColumns() {
    }

    @Override
    public synchronized void addColumn(DataColumn col) {
        this.getDataTable().addColumn(col);
    }

    @Override
    public synchronized void endColumns() {
    }

    @Override
    public synchronized void unchangedRow(final DataRow row) {
        this.getDataTable().lockRunInternal(new Fn1<DataTable.InternalRun, Object>(){

            public Object apply(DataTable.InternalRun irun) {
                irun.getWorkedRows().add(row);
                return null;
            }
        });
    }

    @Override
    public synchronized void changedRow(final DataRow row) {
        this.getDataTable().lockRunInternal(new Fn1<DataTable.InternalRun, Object>(){

            public Object apply(DataTable.InternalRun irun) {
                irun.getWorkedRows().add(row);
                return null;
            }
        });
    }

    @Override
    public synchronized void insertedRow(final DataRow row) {
        this.getDataTable().lockRunInternal(new Fn1<DataTable.InternalRun, Object>(){

            public Object apply(DataTable.InternalRun irun) {
                irun.getWorkedRows().add(row);
                irun.getInsertedRows().add(row);
                return null;
            }
        });
    }

    @Override
    public synchronized void deletedRow(final DataRow row) {
        this.getDataTable().lockRunInternal(new Fn1<DataTable.InternalRun, Object>(){

            public Object apply(DataTable.InternalRun irun) {
                irun.getDeletedRows().add(row);
                return null;
            }
        });
    }

    @Override
    public synchronized void end() {
        DataTable tbl = this.getDataTable();
        tbl.setTrackChanges(true);
    }
}

