/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table;

import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.data.events.DataEvent;
import xyz.cofe.data.events.DataEventListener;
import xyz.cofe.data.table.DataColumn;
import xyz.cofe.data.table.DataColumnEvent;
import xyz.cofe.data.table.DataRow;
import xyz.cofe.data.table.DataTable;
import xyz.cofe.data.table.JdbcColumn;
import xyz.cofe.ecolls.Closeables;
import xyz.cofe.fn.Fn1;

public class DataTableInserting {
    private static final Logger logger = Logger.getLogger(DataTableInserting.class.getName());
    protected final WeakHashMap<String, Integer> firstIndexCache = new WeakHashMap();
    private DataTable table;
    protected final Closeables tableListeners = new Closeables();
    private Object[] values;
    private boolean fixed = false;
    private DataRow dataRow;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DataTableInserting.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DataTableInserting.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DataTableInserting.class.getName(), method, result);
    }

    public DataTableInserting() {
    }

    public DataTableInserting(DataTable dt) {
        this.table = dt;
        if (dt != null) {
            this.values = new Object[dt.getColumnsCount()];
        }
    }

    public DataTableInserting(DataTable dt, Object[] values) {
        this.table = dt;
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int firstIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("columnName == null");
        }
        DataTable dt = this.table;
        if (dt == null) {
            return -1;
        }
        WeakHashMap<String, Integer> weakHashMap = this.firstIndexCache;
        synchronized (weakHashMap) {
            Integer cachedRes = this.firstIndexCache.get(columnName);
            if (cachedRes != null) {
                return cachedRes;
            }
            Integer res = null;
            try {
                int ccnt = dt.getColumnsCount();
                if (ccnt < 1) {
                    res = -1;
                    int n = res;
                    return n;
                }
                for (int ci = 0; ci < ccnt; ++ci) {
                    DataColumn dc = dt.getColumn(ci);
                    if (dc == null) continue;
                    if (dc instanceof JdbcColumn) {
                        String name2;
                        String colLabel;
                        JdbcColumn jc = (JdbcColumn)dc;
                        if (!jc.isCaseSensitive()) {
                            colLabel = jc.getColumnLabel();
                            if (colLabel.equalsIgnoreCase(columnName)) {
                                res = ci;
                                int n = res;
                                return n;
                            }
                            name2 = jc.getName();
                            if (!name2.equalsIgnoreCase(columnName)) continue;
                            res = ci;
                            int n = ci;
                            return n;
                        }
                        colLabel = jc.getColumnLabel();
                        if (colLabel.equals(columnName)) {
                            res = ci;
                            int name2 = ci;
                            return name2;
                        }
                        name2 = jc.getName();
                        if (!name2.equals(columnName)) continue;
                        res = ci;
                        int n = ci;
                        return n;
                    }
                    String name = dc.getName();
                    if (!name.equals(columnName)) continue;
                    res = ci;
                    int n = ci;
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                if (res != null && res >= 0) {
                    this.firstIndexCache.put(columnName, res);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEmptyValues() {
        DataTableInserting dataTableInserting = this;
        synchronized (dataTableInserting) {
            if (this.values != null) {
                return;
            }
            if (this.table == null) {
                throw new IllegalStateException("table not set");
            }
            this.values = new Object[this.table.getColumnsCount()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTableInserting set(int columnIndex, Object value) {
        DataTableInserting dataTableInserting = this;
        synchronized (dataTableInserting) {
            this.initEmptyValues();
            if (columnIndex < 0) {
                throw new IllegalArgumentException("columnIndex(" + columnIndex + ") < 0");
            }
            if (columnIndex >= this.values.length) {
                throw new IllegalArgumentException("columnIndex(" + columnIndex + ") > columnCount(" + this.values.length + ")");
            }
            this.values[columnIndex] = value;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTableInserting set(String columnName, Object value) {
        if (columnName == null) {
            throw new IllegalArgumentException("columnName == null");
        }
        DataTableInserting dataTableInserting = this;
        synchronized (dataTableInserting) {
            this.initEmptyValues();
            int columnIndex = this.firstIndex(columnName);
            if (columnIndex < 0) {
                throw new IllegalArgumentException("columnName(" + columnName + ") not found");
            }
            this.values[columnIndex] = value;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTable getTable() {
        DataTableInserting dataTableInserting = this;
        synchronized (dataTableInserting) {
            return this.table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(DataTable table) {
        DataTableInserting dataTableInserting = this;
        synchronized (dataTableInserting) {
            this.tableListeners.close();
            this.table = table;
            this.values = this.table != null ? new Object[this.table.getColumnsCount()] : null;
            WeakHashMap<String, Integer> weakHashMap = this.firstIndexCache;
            synchronized (weakHashMap) {
                this.firstIndexCache.clear();
            }
            if (table != null) {
                table.addDataEventListener(new DataEventListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dataEvent(DataEvent ev) {
                        if (ev instanceof DataColumnEvent) {
                            WeakHashMap<String, Integer> weakHashMap = DataTableInserting.this.firstIndexCache;
                            synchronized (weakHashMap) {
                                DataTableInserting.this.firstIndexCache.clear();
                            }
                        }
                    }
                }, true);
            }
        }
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public DataTableInserting values(Object ... values) {
        this.setValues(values);
        return this;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public DataTableInserting fixed(boolean fix) {
        this.fixed = fix;
        return this;
    }

    public DataTableInserting fixed() {
        return this.fixed(true);
    }

    public DataRow getDataRow() {
        return this.dataRow;
    }

    public void setDataRow(DataRow dataRow) {
        this.dataRow = dataRow;
    }

    public DataRow go() {
        final DataTable dt = this.table;
        if (dt == null) {
            throw new IllegalStateException("table not set");
        }
        final Object[] vals = this.values;
        if (vals == null) {
            throw new IllegalStateException("values not set");
        }
        dt.lockRunInternal(new Fn1<DataTable.InternalRun, Object>(){

            public Object apply(DataTable.InternalRun irun) {
                irun.nextScn();
                DataRow dr = new DataRow(dt, vals);
                DataTableInserting.this.dataRow = dr;
                irun.getWorkedRows().add(dr);
                if (DataTableInserting.this.fixed) {
                    dt.fixed(dr);
                }
                return null;
            }
        });
        return this.dataRow;
    }

    public DataTableInserting insert(Object ... vals) {
        this.values = vals;
        this.go();
        return this;
    }
}

