/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.data.table.DataColumn;

public class JdbcColumn
extends DataColumn {
    private static final Logger logger = Logger.getLogger(JdbcColumn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected String columnLabel;
    protected String schemaName;
    protected String catalogName;
    protected String tableName;
    protected String columnName;
    protected int columnType;
    protected String columnTypeName;
    protected int displaySize;
    protected int precision;
    protected int scale;
    protected boolean autoIncrement;
    protected boolean caseSensitive;
    protected boolean currency;
    protected boolean definitelyWritable;
    protected int nullable;
    protected boolean searchable;
    protected boolean readOnly;
    protected boolean signed;
    protected boolean writable;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(JdbcColumn.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(JdbcColumn.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(JdbcColumn.class.getName(), method, result);
    }

    public JdbcColumn(String name, Class dataType) {
        super(name, dataType);
    }

    public JdbcColumn(JdbcColumn sample) {
        super(sample);
        if (sample != null) {
            this.columnLabel = sample.columnLabel;
            this.schemaName = sample.schemaName;
            this.catalogName = sample.catalogName;
            this.tableName = sample.tableName;
            this.columnName = sample.columnName;
            this.columnType = sample.columnType;
            this.columnTypeName = sample.columnTypeName;
            this.displaySize = sample.displaySize;
            this.precision = sample.precision;
            this.scale = sample.scale;
            this.autoIncrement = sample.autoIncrement;
            this.caseSensitive = sample.caseSensitive;
            this.currency = sample.currency;
            this.definitelyWritable = sample.definitelyWritable;
            this.nullable = sample.nullable;
            this.searchable = sample.searchable;
            this.signed = sample.signed;
            this.writable = sample.writable;
        }
    }

    @Override
    public JdbcColumn clone() {
        return new JdbcColumn(this);
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public JdbcColumn columnLabel(String label) {
        JdbcColumn c = this.clone();
        c.columnLabel = label;
        return c;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public JdbcColumn schemaName(String name) {
        JdbcColumn c = new JdbcColumn(this);
        c.schemaName = name;
        return c;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public JdbcColumn catalogName(String name) {
        JdbcColumn c = this.clone();
        c.catalogName = name;
        return c;
    }

    public String getTableName() {
        return this.tableName;
    }

    public JdbcColumn tableName(String name) {
        JdbcColumn c = this.clone();
        c.tableName = name;
        return c;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public JdbcColumn columnName(String name) {
        JdbcColumn c = this.clone();
        c.columnName = name;
        return c;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public JdbcColumn columnType(int t) {
        JdbcColumn c = this.clone();
        c.columnType = t;
        return c;
    }

    public String getColumnTypeName() {
        return this.columnTypeName;
    }

    public JdbcColumn columnTypeName(String name) {
        JdbcColumn c = this.clone();
        c.columnTypeName = name;
        return c;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public JdbcColumn displaySize(int displaySize) {
        JdbcColumn c = this.clone();
        c.displaySize = displaySize;
        return c;
    }

    public int getPrecision() {
        return this.precision;
    }

    public JdbcColumn precision(int precision) {
        JdbcColumn c = this.clone();
        c.precision = precision;
        return c;
    }

    public int getScale() {
        return this.scale;
    }

    public JdbcColumn scale(int scale) {
        JdbcColumn c = this.clone();
        c.scale = scale;
        return c;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public JdbcColumn autoIncrement(boolean autoIncrement) {
        JdbcColumn c = this.clone();
        c.autoIncrement = autoIncrement;
        return c;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public JdbcColumn caseSensitive(boolean caseSensitive) {
        JdbcColumn c = this.clone();
        c.caseSensitive = caseSensitive;
        return c;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public JdbcColumn currency(boolean currency) {
        JdbcColumn c = this.clone();
        c.currency = currency;
        return c;
    }

    public boolean isDefinitelyWritable() {
        return this.definitelyWritable;
    }

    public JdbcColumn definitelyWritable(boolean definitelyWritable) {
        JdbcColumn c = this.clone();
        c.definitelyWritable = definitelyWritable;
        return c;
    }

    public int getNullable() {
        return this.nullable;
    }

    public JdbcColumn nullable(int nullable) {
        JdbcColumn c = this.clone();
        c.nullable = nullable;
        if (nullable == 2) {
            c.allowNull = true;
        } else {
            switch (nullable) {
                case 1: {
                    c.allowNull = true;
                    break;
                }
                case 0: {
                    c.allowNull = false;
                    break;
                }
                default: {
                    c.allowNull = true;
                }
            }
        }
        return c;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public JdbcColumn searchable(boolean searchable) {
        JdbcColumn c = this.clone();
        c.searchable = searchable;
        return c;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public JdbcColumn readOnly(boolean readOnly) {
        JdbcColumn c = this.clone();
        c.readOnly = readOnly;
        return c;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public JdbcColumn signed(boolean signed) {
        JdbcColumn c = this.clone();
        c.signed = signed;
        return c;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public JdbcColumn writable(boolean writable) {
        JdbcColumn c = this.clone();
        c.writable = writable;
        return c;
    }

    public static JdbcColumn createFrom(ResultSetMetaData meta, int column, ClassLoader cl) throws SQLException, ClassNotFoundException {
        if (meta == null) {
            throw new IllegalArgumentException("meta == null");
        }
        if (cl == null && (cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = JdbcColumn.class.getClassLoader();
        }
        String label = meta.getColumnLabel(column);
        String clsName = meta.getColumnClassName(column);
        Class<?> cls = Class.forName(clsName, true, cl);
        JdbcColumn jc = new JdbcColumn(label, cls);
        jc = jc.columnLabel(label);
        String schemaName = meta.getSchemaName(column);
        jc = jc.schemaName(schemaName);
        String catalogName = meta.getCatalogName(column);
        jc = jc.catalogName(catalogName);
        String tableName = meta.getTableName(column);
        jc = jc.tableName(tableName);
        String columnName = meta.getColumnName(column);
        jc = jc.columnName(columnName);
        int colType = meta.getColumnType(column);
        jc = jc.columnType(colType);
        String colTypeName = meta.getColumnTypeName(column);
        jc = jc.columnTypeName(colTypeName);
        int displaySize = meta.getColumnDisplaySize(column);
        jc = jc.displaySize(displaySize);
        int precision = meta.getPrecision(column);
        jc = jc.precision(precision);
        int scale = meta.getScale(column);
        jc = jc.scale(scale);
        boolean ai = meta.isAutoIncrement(column);
        jc = jc.autoIncrement(ai);
        boolean caseSens = meta.isCaseSensitive(column);
        jc = jc.caseSensitive(caseSens);
        jc = jc.currency(meta.isCurrency(column));
        jc = jc.definitelyWritable(meta.isDefinitelyWritable(column));
        jc = jc.nullable(meta.isNullable(column));
        jc = jc.searchable(meta.isSearchable(column));
        jc = jc.readOnly(meta.isReadOnly(column));
        jc = jc.signed(meta.isSigned(column));
        jc = jc.writable(meta.isWritable(column));
        return jc;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

