/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.data.table.DataColumn;
import xyz.cofe.data.table.DataTable;

public class JdbcUtils {
    private static final Logger logger = Logger.getLogger(JdbcUtils.class.getName());

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(JdbcUtils.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(JdbcUtils.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(JdbcUtils.class.getName(), method, result);
    }

    public static DataTable tableOf(ResultSet rs) throws SQLException, ClassNotFoundException {
        boolean hasNext;
        if (rs == null) {
            throw new IllegalArgumentException("rs == null");
        }
        ResultSetMetaData rsmeta = rs.getMetaData();
        ArrayList<DataColumn> dcList = new ArrayList<DataColumn>();
        int ccnt = rsmeta.getColumnCount();
        for (int cn = 1; cn <= ccnt; ++cn) {
            DataColumn dc = null;
            String clsName = rsmeta.getColumnClassName(cn);
            String label = rsmeta.getColumnLabel(cn);
            label = label != null ? label : "column" + cn;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = JdbcUtils.class.getClassLoader();
            }
            Class<?> cls = Class.forName(clsName, true, cl);
            dc = new DataColumn(label, cls);
            int sqlnull = rsmeta.isNullable(cn);
            if (sqlnull != 2) {
                if (sqlnull == 1) {
                    dc = dc.allowNull(true);
                } else if (sqlnull == 0) {
                    dc = dc.allowNull(false);
                }
            }
            dcList.add(dc);
        }
        DataTable dt = new DataTable(dcList.toArray(new DataColumn[0]));
        while (hasNext = rs.next()) {
            Object[] values = new Object[ccnt];
            for (int cn = 1; cn <= ccnt; ++cn) {
                values[cn - 1] = rs.getObject(cn);
            }
            dt.insert(values).fixed().go();
        }
        return dt;
    }
}

