/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.SwingPropertyChangeSupport;
import xyz.cofe.data.table.DataRow;
import xyz.cofe.data.table.DataTable;
import xyz.cofe.data.table.DataTableInserting;
import xyz.cofe.data.table.JdbcColumn;

public class ResultSetFetcher {
    private static final Logger logger = Logger.getLogger(ResultSetFetcher.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final PropertyChangeSupport psupport;
    protected ResultSet resultSet;
    private ClassLoader classLoader = null;
    private List<JdbcColumn> columns = null;
    protected Function<SQLException, Object> sqlExceptionHook = null;
    protected DataTable dataTable;
    private boolean dataTableRebuilded = false;
    protected long fetchStart = 0L;
    protected long fetchLast = 0L;
    protected long fetchCount = 0L;
    protected long sumFetchTimeNS = 0L;
    protected long minFetchTimeNS = Long.MAX_VALUE;
    protected long maxFetchTimeNS = Long.MIN_VALUE;
    protected long sumInsertTimeNS = 0L;
    protected long minInsertTimeNS = Long.MAX_VALUE;
    protected long maxInsertTimeNS = Long.MIN_VALUE;
    protected long rebuildStart = 0L;
    protected long rebuildFinish = 0L;
    protected long rebuildColumns = 0L;
    protected Map<String, Number> counters;
    protected boolean withClose = false;
    protected boolean releaseResultSet = true;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(ResultSetFetcher.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(ResultSetFetcher.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(ResultSetFetcher.class.getName(), method, result);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.psupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.psupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.psupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.psupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.psupport.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.psupport.getPropertyChangeListeners(propertyName);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.psupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean hasListeners(String propertyName) {
        return this.psupport.hasListeners(propertyName);
    }

    public ResultSetFetcher() {
        this.psupport = new PropertyChangeSupport(true);
    }

    public ResultSetFetcher(ResultSet rs, boolean withClose, DataTable table, ClassLoader cl, boolean evInAwt) {
        this.psupport = evInAwt ? new SwingPropertyChangeSupport(this, false) : new PropertyChangeSupport(true);
        this.setClassLoader(cl);
        this.setResultSet(rs);
        this.setWithClose(withClose);
        this.setDataTable(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            return this.resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSet(ResultSet resultSet) {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            this.resultSet = resultSet;
            this.columns = null;
            if (resultSet != null) {
                try {
                    if (!resultSet.isClosed()) {
                        this.getColumns();
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(ResultSetFetcher.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader classLoader() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            if (this.classLoader != null) {
                return this.classLoader;
            }
            ClassLoader cl = null;
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            if (cl == null) {
                cl = ResultSetFetcher.class.getClassLoader();
            }
            this.classLoader = cl;
            return cl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            return this.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassLoader(ClassLoader cl) {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            this.classLoader = cl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnCount() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            return this.getColumns().size();
        }
    }

    public List<JdbcColumn> getColumns() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            if (this.columns != null) {
                return this.columns;
            }
            if (this.resultSet == null) {
                throw new IllegalStateException("resultSet not set");
            }
            try {
                ResultSetMetaData md = this.resultSet.getMetaData();
                JdbcColumn[] dcs = new JdbcColumn[md.getColumnCount()];
                for (int ci = 0; ci < md.getColumnCount(); ++ci) {
                    int sci = ci + 1;
                    dcs[ci] = JdbcColumn.createFrom(md, sci, this.classLoader());
                }
                this.columns = Arrays.asList(dcs);
                return this.columns;
            }
            catch (ClassNotFoundException | SQLException ex) {
                Logger.getLogger(ResultSetFetcher.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            if (this.resultSet == null) {
                return false;
            }
            try {
                boolean closed = this.resultSet.isClosed();
                if (closed) {
                    this.fetchFinished();
                    return false;
                }
                boolean fetchedAll = this.resultSet.isAfterLast();
                if (fetchedAll) {
                    this.fetchFinished();
                    return false;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ResultSetFetcher.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            return true;
        }
    }

    public synchronized Function<SQLException, Object> getSqlExceptionHook() {
        return this.sqlExceptionHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSqlExceptionHook(Function<SQLException, Object> sqlExceptionHook) {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            this.sqlExceptionHook = sqlExceptionHook;
        }
    }

    public Object[] next() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            if (this.resultSet == null) {
                return null;
            }
            try {
                boolean fetched = this.resultSet.next();
                if (!fetched) {
                    this.fetchFinished();
                    return null;
                }
                int cc = this.getColumnCount();
                if (cc <= 0) {
                    return new Object[0];
                }
                Object[] res = new Object[cc];
                for (int ci = 0; ci < cc; ++ci) {
                    Object v;
                    res[ci] = v = this.resultSet.getObject(ci + 1);
                }
                return res;
            }
            catch (SQLException ex) {
                Logger.getLogger(ResultSetFetcher.class.getName()).log(Level.SEVERE, null, ex);
                if (this.sqlExceptionHook != null) {
                    this.sqlExceptionHook.apply(ex);
                    this.fetchFinished();
                    return null;
                }
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTable getDataTable() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            if (this.dataTable != null) {
                return this.dataTable;
            }
            this.dataTable = new DataTable();
            this.dataTableRebuilded = false;
            return this.dataTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataTable(DataTable dataTable) {
        DataTable cur;
        DataTable old;
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            old = this.dataTable;
            this.dataTable = dataTable;
            this.dataTableRebuilded = false;
            cur = this.dataTable;
        }
        this.firePropertyChange("dataTable", old, cur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTable rebuildTable() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            this.rebuildStart = System.currentTimeMillis();
            DataTable dt = this.getDataTable();
            if (dt == null) {
                throw new IllegalStateException("dataTable not set");
            }
            this.rebuildColumns = 0L;
            dt.drop();
            for (JdbcColumn col : this.getColumns()) {
                dt.addColumn(col);
                ++this.rebuildColumns;
            }
            this.dataTableRebuilded = true;
            this.rebuildFinish = System.currentTimeMillis();
            return dt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataTableRebuilded() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            return this.dataTableRebuilded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Number> getCounters() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            if (this.counters == null) {
                this.counters = new LinkedHashMap<String, Number>();
            }
            long fetchTime = Math.abs(this.fetchLast - this.fetchStart);
            this.counters.put("fetchStart", this.fetchStart);
            this.counters.put("fetchLast", this.fetchLast);
            this.counters.put("fetchTime", fetchTime);
            this.counters.put("fetchCount", this.fetchCount);
            this.counters.put("fetchRowTimeAvg", this.fetchCount > 0L ? (double)fetchTime / (double)this.fetchCount : Double.NaN);
            this.counters.put("sumFetchTimeNS", this.sumFetchTimeNS);
            this.counters.put("minFetchTimeNS", this.minFetchTimeNS);
            this.counters.put("maxFetchTimeNS", this.maxFetchTimeNS);
            this.counters.put("sumInsertTimeNS", this.sumInsertTimeNS);
            this.counters.put("minInsertTimeNS", this.minInsertTimeNS);
            this.counters.put("maxInsertTimeNS", this.maxInsertTimeNS);
            this.counters.put("rebuildStart", this.rebuildStart);
            this.counters.put("rebuildFinish", this.rebuildFinish);
            this.counters.put("rebuildTime", Math.abs(this.rebuildStart - this.rebuildFinish));
            this.counters.put("rebuildColumns", this.rebuildColumns);
            return this.counters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fetch() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            long t0 = -1L;
            long t0ns = -1L;
            long t1 = -1L;
            long t1ns = -1L;
            long t2 = -1L;
            long t2ns = -1L;
            try {
                if (this.dataTable == null) {
                    throw new IllegalStateException("dataTable == null");
                }
                if (!this.dataTableRebuilded) {
                    this.rebuildTable();
                }
                t0 = System.currentTimeMillis();
                t0ns = System.nanoTime();
                if (!this.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                Object[] vals = this.next();
                int rownum = -1;
                if (this.resultSet != null) {
                    try {
                        rownum = this.resultSet.getRow();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(ResultSetFetcher.class.getName()).log(Level.SEVERE, null, ex);
                        if (this.sqlExceptionHook != null) {
                            this.sqlExceptionHook.apply(ex);
                        }
                        boolean insertTimeNS = false;
                        if (this.fetchStart <= 0L && t0 > 0L) {
                            this.fetchStart = t0;
                        }
                        if (t2 > 0L) {
                            this.fetchLast = t2;
                        }
                        if (t0ns > 0L && t1ns > 0L && t2ns > 0L) {
                            long fetchTimeNS = Math.abs(t1ns - t0ns);
                            this.sumFetchTimeNS += fetchTimeNS;
                            this.minFetchTimeNS = Math.min(fetchTimeNS, this.minFetchTimeNS);
                            this.maxFetchTimeNS = Math.max(fetchTimeNS, this.maxFetchTimeNS);
                            long insertTimeNS2 = Math.abs(t2ns - t1ns);
                            this.sumInsertTimeNS += insertTimeNS2;
                            this.minInsertTimeNS = Math.min(fetchTimeNS, this.minInsertTimeNS);
                            this.maxInsertTimeNS = Math.max(fetchTimeNS, this.maxInsertTimeNS);
                        }
                        return insertTimeNS;
                    }
                }
                if (vals == null) {
                    boolean ex = false;
                    return ex;
                }
                t1 = System.currentTimeMillis();
                t1ns = System.nanoTime();
                DataTableInserting ins = this.dataTable.insert(vals).fixed(true);
                ins.go();
                t2 = System.currentTimeMillis();
                t2ns = System.nanoTime();
                DataRow dr = ins.getDataRow();
                ++this.fetchCount;
                boolean bl = true;
                return bl;
            }
            finally {
                if (this.fetchStart <= 0L && t0 > 0L) {
                    this.fetchStart = t0;
                }
                if (t2 > 0L) {
                    this.fetchLast = t2;
                }
                if (t0ns > 0L && t1ns > 0L && t2ns > 0L) {
                    long fetchTimeNS = Math.abs(t1ns - t0ns);
                    this.sumFetchTimeNS += fetchTimeNS;
                    this.minFetchTimeNS = Math.min(fetchTimeNS, this.minFetchTimeNS);
                    this.maxFetchTimeNS = Math.max(fetchTimeNS, this.maxFetchTimeNS);
                    long insertTimeNS = Math.abs(t2ns - t1ns);
                    this.sumInsertTimeNS += insertTimeNS;
                    this.minInsertTimeNS = Math.min(fetchTimeNS, this.minInsertTimeNS);
                    this.maxInsertTimeNS = Math.max(fetchTimeNS, this.maxInsertTimeNS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWithClose() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            return this.withClose;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWithClose(boolean withClose) {
        Boolean cur;
        Boolean old;
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            old = this.withClose;
            this.withClose = withClose;
            cur = this.withClose;
        }
        this.firePropertyChange("withClose", old, cur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReleaseResultSet() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            return this.releaseResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReleaseResultSet(boolean releaseResultSet) {
        Boolean cur;
        Boolean old;
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            old = this.releaseResultSet;
            this.releaseResultSet = releaseResultSet;
            cur = this.releaseResultSet;
        }
        this.firePropertyChange("closeResultSet", old, cur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchFinished() {
        ResultSetFetcher.logFine("fetchFinished", new Object[0]);
        boolean fireClosed = false;
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            if (this.releaseResultSet && this.resultSet != null) {
                if (this.withClose) {
                    try {
                        if (!this.resultSet.isClosed()) {
                            this.resultSet.close();
                        }
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(ResultSetFetcher.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.resultSet = null;
                fireClosed = true;
            }
        }
        if (fireClosed) {
            this.firePropertyChange("closed", false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ResultSetFetcher resultSetFetcher = this;
        synchronized (resultSetFetcher) {
            return this.resultSet == null;
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

