/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table.store;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.SwingPropertyChangeSupport;
import xyz.cofe.collection.BasicEventList;
import xyz.cofe.data.table.store.FixedColumn;

public class CSVDesc {
    protected final PropertyChangeSupport psupp = new SwingPropertyChangeSupport(this);
    protected String cellDelimiter = ",";
    protected String cellQuote = "\"";
    protected boolean skipEmptyLines = true;
    protected boolean skipFirstWS = false;
    protected QuoteVariants quoteVariants = QuoteVariants.Sometimes;
    protected int skipLines = 0;
    protected boolean firstLineAsName = true;
    protected boolean fixedWidth = false;
    protected List<FixedColumn> fixedColumns = new BasicEventList();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(CSVDesc.class.getName()).log(Level.SEVERE, null, ex);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.psupp.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.psupp.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.psupp.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.psupp.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.psupp.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.psupp.getPropertyChangeListeners(propertyName);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.psupp.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        this.psupp.firePropertyChange(event);
    }

    public CSVDesc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVDesc(CSVDesc src) {
        if (src != null) {
            CSVDesc cSVDesc = src;
            synchronized (cSVDesc) {
                this.cellDelimiter = src.cellDelimiter;
                this.cellQuote = src.cellQuote;
                this.skipEmptyLines = src.skipEmptyLines;
                this.skipFirstWS = src.skipFirstWS;
                this.quoteVariants = src.quoteVariants;
                this.skipLines = src.skipLines;
                this.firstLineAsName = src.firstLineAsName;
                this.fixedWidth = src.fixedWidth;
                if (src.fixedColumns != null) {
                    if (this.fixedColumns != null) {
                        this.fixedColumns.clear();
                    } else {
                        this.fixedColumns = new ArrayList<FixedColumn>();
                    }
                    for (FixedColumn fc : src.fixedColumns) {
                        if (fc != null) {
                            this.fixedColumns.add(fc.clone());
                            continue;
                        }
                        this.fixedColumns.add(null);
                    }
                }
            }
        }
    }

    public CSVDesc clone() {
        return new CSVDesc(this);
    }

    public synchronized String getCellDelimiter() {
        if (this.cellDelimiter == null) {
            this.cellDelimiter = ",";
        }
        return this.cellDelimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCellDelimiter(String cellDelimiter) {
        String old = this.getCellDelimiter();
        CSVDesc cSVDesc = this;
        synchronized (cSVDesc) {
            this.cellDelimiter = cellDelimiter;
        }
        this.firePropertyChange("cellDelimiter", old, this.getCellDelimiter());
    }

    public synchronized String getCellQuote() {
        if (this.cellQuote == null) {
            this.cellQuote = "\"";
        }
        return this.cellQuote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCellQuote(String cellQuote) {
        String old = this.getCellQuote();
        CSVDesc cSVDesc = this;
        synchronized (cSVDesc) {
            this.cellQuote = cellQuote;
        }
        this.firePropertyChange("cellQuote", old, this.getCellQuote());
    }

    public synchronized boolean isSkipEmptyLines() {
        return this.skipEmptyLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkipEmptyLines(boolean skipEmptyLines) {
        Boolean old = this.isSkipEmptyLines();
        CSVDesc cSVDesc = this;
        synchronized (cSVDesc) {
            this.skipEmptyLines = skipEmptyLines;
        }
        this.firePropertyChange("skipEmptyLines", old, this.isSkipEmptyLines());
    }

    public synchronized boolean isSkipFirstWS() {
        return this.skipFirstWS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkipFirstWS(boolean skipFirstWS) {
        Boolean old = this.isSkipFirstWS();
        CSVDesc cSVDesc = this;
        synchronized (cSVDesc) {
            this.skipFirstWS = skipFirstWS;
        }
        this.firePropertyChange("skipFirstWS", old, this.isSkipFirstWS());
    }

    public synchronized QuoteVariants getQuoteVariants() {
        if (this.quoteVariants == null) {
            this.quoteVariants = QuoteVariants.Sometimes;
        }
        return this.quoteVariants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuoteVariants(QuoteVariants quoteVariants) {
        QuoteVariants old = this.getQuoteVariants();
        CSVDesc cSVDesc = this;
        synchronized (cSVDesc) {
            this.quoteVariants = quoteVariants;
        }
        this.firePropertyChange("quoteVariants", (Object)old, (Object)this.getQuoteVariants());
    }

    public synchronized int getSkipLines() {
        return this.skipLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkipLines(int skipLines) {
        Integer old = this.getSkipLines();
        CSVDesc cSVDesc = this;
        synchronized (cSVDesc) {
            this.skipLines = skipLines;
        }
        this.firePropertyChange("skipLines", old, this.getSkipLines());
    }

    public synchronized boolean isFirstLineAsName() {
        return this.firstLineAsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstLineAsName(boolean firstLineAsName) {
        Boolean old = this.isFirstLineAsName();
        CSVDesc cSVDesc = this;
        synchronized (cSVDesc) {
            this.firstLineAsName = firstLineAsName;
        }
        this.firePropertyChange("firstLineAsName", old, this.isFirstLineAsName());
    }

    public synchronized boolean isFixedWidth() {
        return this.fixedWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFixedWidth(boolean fixedWidth) {
        Boolean old = this.isFixedWidth();
        CSVDesc cSVDesc = this;
        synchronized (cSVDesc) {
            this.fixedWidth = fixedWidth;
        }
        this.firePropertyChange("fixedWidth", old, this.isFixedWidth());
    }

    public List<FixedColumn> getFixedColumns() {
        if (this.fixedColumns == null) {
            this.fixedColumns = new BasicEventList();
        }
        return this.fixedColumns;
    }

    public void setFixedColumns(List<FixedColumn> fixedColumns) {
        this.fixedColumns = fixedColumns;
    }

    public static enum QuoteVariants {
        Always,
        Sometimes,
        Never;

    }
}

