/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table.store;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.graph.Path;
import xyz.cofe.data.table.DataColumn;
import xyz.cofe.data.table.DataRow;
import xyz.cofe.data.table.DataTable;
import xyz.cofe.data.table.store.CSVDesc;
import xyz.cofe.data.table.store.CSVSpecialColumn;
import xyz.cofe.data.table.store.CSVUtil;
import xyz.cofe.iter.Eterable;
import xyz.cofe.simpletypes.SimpleTypes;
import xyz.cofe.text.out.Output;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;

public class CSVStore
extends CSVDesc {
    private static final Logger logger = Logger.getLogger(CSVStore.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected TypeCastGraph castGraph;
    protected CSVUtil csvUtil = new CSVUtil();
    protected boolean writeAllRows = false;
    protected List<CSVSpecialColumn> specialColumns;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(CSVStore.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(CSVStore.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(CSVStore.class.getName(), method, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeCastGraph getCastGraph() {
        CSVStore cSVStore = this;
        synchronized (cSVStore) {
            if (this.castGraph != null) {
                return this.castGraph;
            }
            this.castGraph = new ExtendedCastGraph();
            return this.castGraph;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCastGraph(TypeCastGraph castGraph) {
        CSVStore cSVStore = this;
        synchronized (cSVStore) {
            this.castGraph = castGraph;
        }
    }

    public String asString(Object val) {
        if (val == null) {
            return null;
        }
        TypeCastGraph tc = this.getCastGraph();
        return (String)tc.cast(val, String.class);
    }

    public Object asValueOf(String str, Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        if (str == null) {
            if (!SimpleTypes.isSimple((Class)cls)) {
                return null;
            }
            if (SimpleTypes.boolObject().equals(cls)) {
                return Boolean.FALSE;
            }
            if (SimpleTypes.byteObject().equals(cls)) {
                return (byte)0;
            }
            if (SimpleTypes.charObject().equals(cls)) {
                return Character.valueOf('\u0000');
            }
            if (SimpleTypes.doubleObject().equals(cls)) {
                return 0.0;
            }
            if (SimpleTypes.floatObject().equals(cls)) {
                return Float.valueOf(0.0f);
            }
            if (SimpleTypes.intObject().equals(cls)) {
                return 0;
            }
            if (SimpleTypes.longObject().equals(cls)) {
                return 0L;
            }
            if (SimpleTypes.shortObject().equals(cls)) {
                return (short)0;
            }
            return null;
        }
        TypeCastGraph tc = this.getCastGraph();
        return tc.cast((Object)str, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportDeserialize(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        CSVStore cSVStore = this;
        synchronized (cSVStore) {
            TypeCastGraph tc = this.getCastGraph();
            Path path = tc.findPath(String.class, cls);
            return path != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportSerialize(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        CSVStore cSVStore = this;
        synchronized (cSVStore) {
            TypeCastGraph tc = this.getCastGraph();
            Path path = tc.findPath(cls, String.class);
            return path != null;
        }
    }

    public CSVStore() {
    }

    public CSVStore(CSVStore sample) {
        super(sample);
    }

    @Override
    public CSVStore clone() {
        return new CSVStore(this);
    }

    public boolean isWriteAllRows() {
        return this.writeAllRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteAllRows(boolean writeAllRows) {
        Boolean cur;
        Boolean old;
        CSVStore cSVStore = this;
        synchronized (cSVStore) {
            old = this.writeAllRows;
            this.writeAllRows = writeAllRows;
            cur = this.writeAllRows;
        }
        this.firePropertyChange("writeAllRows", old, cur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CSVSpecialColumn> getSpecialColumns() {
        CSVStore cSVStore = this;
        synchronized (cSVStore) {
            if (this.specialColumns != null) {
                return this.specialColumns;
            }
            this.specialColumns = new ArrayList<CSVSpecialColumn>();
            return this.specialColumns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpecialColumns(List<CSVSpecialColumn> list) {
        CSVStore cSVStore = this;
        synchronized (cSVStore) {
            this.specialColumns = list;
        }
    }

    public synchronized void write(Writer out, DataTable table) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (table == null) {
            throw new IllegalArgumentException("table == null");
        }
        Output output = new Output(out);
        this.write(output, table);
        output.flush();
    }

    public synchronized void write(Output out, DataTable table) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (table == null) {
            throw new IllegalArgumentException("table == null");
        }
        if (this.isFirstLineAsName()) {
            this.writeHeader(out, table);
        }
        Eterable<DataRow> itr = table.getRowsIterable();
        if (this.writeAllRows) {
            itr = table.getRowsIterableAll();
        }
        for (DataRow dr : itr) {
            String[] cells;
            if (dr == null || (cells = this.toStringArray(table, dr)) == null) continue;
            String line = this.csvUtil.toString(cells, (CSVDesc)this);
            out.println(line);
        }
    }

    protected synchronized void writeHeader(Output out, DataTable dt) {
        ArrayList<String> cells = new ArrayList<String>(dt.getColumnsCount());
        for (CSVSpecialColumn sc : this.getSpecialColumns()) {
            cells.add(sc.getName());
        }
        for (DataColumn dc : dt.getColumns()) {
            cells.add(dc.getName());
        }
        String[] arr = cells.toArray(new String[0]);
        String line = this.csvUtil.toString(arr, (CSVDesc)this);
        out.println(line);
    }

    protected synchronized String[] toStringArray(DataTable dt, DataRow row) {
        String str;
        ArrayList<String> cells = new ArrayList<String>(dt.getColumnsCount());
        for (CSVSpecialColumn sc : this.getSpecialColumns()) {
            str = sc.asString(row);
            if (str == null) {
                str = "";
            }
            cells.add(str);
        }
        for (int ci = 0; ci < dt.getColumnsCount(); ++ci) {
            Object val = row.get(ci);
            str = this.asString(val);
            if (str == null) {
                str = "";
            }
            cells.add(str);
        }
        String[] arr = cells.toArray(new String[0]);
        return arr;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

