/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table.store;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.data.table.store.CSVDesc;
import xyz.cofe.data.table.store.FixedColumn;
import xyz.cofe.fn.Pair;
import xyz.cofe.text.Text;

public class CSVUtil {
    private static void logFine(String message, Object ... args) {
        Logger.getLogger(CSVUtil.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(CSVUtil.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(CSVUtil.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(CSVUtil.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(CSVUtil.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(CSVUtil.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(CSVUtil.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Pair<String, Integer> parseCellDelimiter(String line, int beginIndex, CSVDesc desc) {
        if (line == null) {
            return null;
        }
        if (beginIndex < 0) {
            return null;
        }
        if (desc == null) {
            return null;
        }
        String delim = desc.getCellDelimiter();
        if (delim == null) {
            return null;
        }
        if (delim.length() < 1) {
            return null;
        }
        int delimLen = delim.length();
        int dStart = line.indexOf(delim, beginIndex);
        if (dStart < 0) {
            return null;
        }
        return Pair.of((Object)line.substring(beginIndex, dStart + delimLen), (Object)(dStart + delimLen));
    }

    public Pair<String, Integer> parseQoutedString(String line, int beginIndex, CSVDesc desc) {
        if (line == null) {
            return null;
        }
        if (beginIndex < 0) {
            return null;
        }
        if (desc == null) {
            return null;
        }
        String quote = desc.getCellQuote();
        if (quote == null) {
            return null;
        }
        if (quote.length() < 1) {
            return null;
        }
        int quoteLen = quote.length();
        if (beginIndex >= line.length()) {
            return null;
        }
        int qStart = line.indexOf(quote, beginIndex);
        if (qStart < 0) {
            return null;
        }
        int ptr = qStart + quoteLen;
        int nextPTR = -1;
        StringBuilder sb = new StringBuilder();
        while (true) {
            String CHR = Text.lookupText((String)line, (int)ptr, (int)1);
            String L0 = Text.lookupText((String)line, (int)ptr, (int)quoteLen);
            String L1 = Text.lookupText((String)line, (int)(ptr + quoteLen), (int)quoteLen);
            if (CHR.length() < 1) {
                nextPTR = ptr;
                break;
            }
            if (L0.equals(quote) && L1.equals(quote)) {
                ptr += quoteLen * 2;
                sb.append(quote);
                continue;
            }
            if (L0.equals(quote) && !L1.equals(quote)) {
                nextPTR = ptr + quoteLen;
                break;
            }
            sb.append(CHR);
            ptr += CHR.length();
        }
        return Pair.of((Object)sb.toString(), (Object)nextPTR);
    }

    public String[] parseLine(String line, CSVDesc desc) {
        if (line == null) {
            throw new IllegalArgumentException("line==null");
        }
        if (desc == null) {
            throw new IllegalArgumentException("desc==null");
        }
        if (desc.isFixedWidth()) {
            return this.parseFixedWidthLine(line, desc);
        }
        return this.parseNonFixedWidthLine(line, desc);
    }

    public String[] parseFixedWidthLine(String line, CSVDesc desc) {
        if (line == null) {
            throw new IllegalArgumentException("line==null");
        }
        if (desc == null) {
            throw new IllegalArgumentException("desc==null");
        }
        List<FixedColumn> lcolumns = desc.getFixedColumns();
        String[] acolumns = new String[lcolumns.size()];
        for (int icol = 0; icol < acolumns.length; ++icol) {
            acolumns[icol] = "";
        }
        int idxCol = -1;
        for (FixedColumn fcol : lcolumns) {
            String data;
            ++idxCol;
            int begin = fcol == null ? -1 : fcol.getBegin();
            int len = fcol == null ? -1 : fcol.getLength();
            if (len < 1 || begin < 0 || begin >= line.length()) continue;
            int end = begin + len;
            if (end > line.length()) {
                end = line.length();
            }
            acolumns[idxCol] = data = line.substring(begin, end);
        }
        return acolumns;
    }

    public String[] parseNonFixedWidthLine(String line, CSVDesc desc) {
        if (line == null) {
            throw new IllegalArgumentException("line==null");
        }
        if (desc == null) {
            throw new IllegalArgumentException("desc==null");
        }
        if (line.length() == 0) {
            return new String[0];
        }
        String cellQuote = desc.getCellQuote();
        if (cellQuote == null) {
            throw new IllegalStateException("desc.getCellQuote()==null");
        }
        if (cellQuote.length() < 1) {
            throw new IllegalStateException("desc.getCellQuote().length()<1");
        }
        String cellDelim = desc.getCellDelimiter();
        if (cellDelim == null) {
            throw new IllegalStateException("desc.getCellDelimiter()==null");
        }
        if (cellDelim.length() < 1) {
            throw new IllegalStateException("desc.getCellDelimiter().length()<1");
        }
        ArrayList<String> cellData = new ArrayList<String>();
        int ptr = 0;
        int co = 0;
        Pair<String, Integer> res = null;
        if (desc.isSkipFirstWS()) {
            boolean found = false;
            for (int p = 0; p < line.length(); ++p) {
                char c = line.charAt(p);
                if (Character.isWhitespace(c)) continue;
                ptr = p;
                found = true;
                break;
            }
            if (!found) {
                return new String[0];
            }
        }
        while (ptr < line.length()) {
            if (co > 0) {
                res = this.parseCellDelimiter(line, ptr, desc);
                if (res == null) break;
                ptr = (Integer)res.b();
            }
            boolean stopRead = false;
            switch (desc.getQuoteVariants()) {
                case Always: {
                    res = this.parseQoutedString(line, ptr, desc);
                    if (res == null) {
                        stopRead = true;
                        break;
                    }
                    ptr = (Integer)res.b();
                    cellData.add((String)res.a());
                    ++co;
                    break;
                }
                case Never: {
                    int di = line.indexOf(cellDelim, ptr);
                    if (di < 0) {
                        String data = line.substring(ptr);
                        cellData.add(data);
                        ++co;
                        stopRead = true;
                        break;
                    }
                    if (di > ptr) {
                        int from = ptr;
                        int toEx = di;
                        ptr = di;
                        cellData.add(line.substring(from, toEx));
                        ++co;
                        break;
                    }
                    ptr = di;
                    cellData.add("");
                    ++co;
                    break;
                }
                case Sometimes: {
                    String q = Text.lookupText((String)line, (int)ptr, (int)cellQuote.length());
                    if (q.equals(cellQuote)) {
                        res = this.parseQoutedString(line, ptr, desc);
                        if (res == null) {
                            stopRead = true;
                            break;
                        }
                        ptr = (Integer)res.b();
                        cellData.add((String)res.a());
                        ++co;
                        break;
                    }
                    int di = line.indexOf(cellDelim, ptr);
                    if (di < 0) {
                        String data = line.substring(ptr);
                        cellData.add(data);
                        ++co;
                        stopRead = true;
                        break;
                    }
                    if (di > ptr) {
                        int from = ptr;
                        int toEx = di;
                        ptr = di;
                        cellData.add(line.substring(from, toEx));
                        ++co;
                        break;
                    }
                    ptr = di;
                    cellData.add("");
                    ++co;
                }
            }
            if (!stopRead) continue;
            break;
        }
        return cellData.toArray(new String[0]);
    }

    public String toString(String[] cells, CSVDesc desc) {
        if (cells == null) {
            return null;
        }
        if (desc == null) {
            return null;
        }
        if (cells.length == 0) {
            return "";
        }
        if (desc.isFixedWidth()) {
            return this.toStringFixedWidthLine(cells, desc.getFixedColumns());
        }
        return this.toStringNonFixedWidthLine(cells, desc);
    }

    public String toString(List<String> cells, CSVDesc desc) {
        if (cells == null) {
            return null;
        }
        if (desc == null) {
            return null;
        }
        if (cells.isEmpty()) {
            return "";
        }
        if (desc.isFixedWidth()) {
            return this.toStringFixedWidthLine(cells.toArray(new String[0]), desc.getFixedColumns());
        }
        return this.toStringNonFixedWidthLine(cells.toArray(new String[0]), desc);
    }

    public String toString(Iterable<String> cells, CSVDesc desc) {
        if (cells == null) {
            return null;
        }
        if (desc == null) {
            return null;
        }
        ArrayList<String> cdata = new ArrayList<String>();
        for (String str : cells) {
            cdata.add(str);
        }
        return this.toString((List<String>)cdata, desc);
    }

    protected String toStringFixedWidthLine(String[] cells, List<FixedColumn> fcolumns) {
        if (fcolumns.isEmpty()) {
            return "";
        }
        LinkedList<Pair> cellValues = new LinkedList<Pair>();
        int strWidth = 0;
        for (int coli = 0; coli < fcolumns.size() && coli < cells.length; ++coli) {
            String cellValue = cells[coli];
            if (cellValue == null) {
                cellValue = "";
            }
            if (cellValue.contains("\r\n")) {
                cellValue = cellValue.replace("\r\n", " ");
            }
            if (cellValue.contains("\n\r")) {
                cellValue = cellValue.replace("\n\r", " ");
            }
            if (cellValue.contains("\n")) {
                cellValue = cellValue.replace("\n", " ");
            }
            if (cellValue.contains("\r")) {
                cellValue = cellValue.replace("\r", " ");
            }
            FixedColumn fcol = fcolumns.get(coli);
            int begin = fcol.getBegin();
            int len = fcol.getLength();
            if (len < 0) continue;
            if (len == 0) {
                cellValue = "";
            } else if (cellValue.length() < len) {
                StringBuilder sb = new StringBuilder();
                int padSize = len - cellValue.length();
                for (int pi = 0; pi < padSize; ++pi) {
                    sb.append(" ");
                }
                cellValue = cellValue + sb.toString();
            } else if (cellValue.length() >= len) {
                cellValue = cellValue.substring(0, len);
            }
            if (begin < 0) continue;
            int cellValueEnd = begin + len;
            if (strWidth < cellValueEnd) {
                strWidth = cellValueEnd;
            }
            cellValues.add(Pair.of((Object)begin, (Object)cellValue));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Text.repeat((String)" ", (int)strWidth));
        for (Pair cellVal : cellValues) {
            sb.replace((Integer)cellVal.a(), (Integer)cellVal.a() + ((String)cellVal.b()).length(), (String)cellVal.b());
        }
        return sb.toString();
    }

    protected String toStringNonFixedWidthLine(String[] cells, CSVDesc desc) {
        StringBuilder csvLine = new StringBuilder();
        block8: for (int celi = 0; celi < cells.length; ++celi) {
            String cellValue = cells[celi];
            if (cellValue == null) {
                cellValue = "";
            }
            if (desc.isSkipFirstWS() && celi == 0) {
                int state = 0;
                StringBuilder sbCell = new StringBuilder();
                block9: for (int ci = 0; ci < cellValue.length(); ++ci) {
                    char ch = cellValue.charAt(ci);
                    switch (state) {
                        case 0: {
                            if (Character.isWhitespace(ch)) continue block9;
                            sbCell.append(ch);
                            state = 1;
                            continue block9;
                        }
                        case 1: {
                            sbCell.append(ch);
                        }
                    }
                }
                cellValue = sbCell.toString();
            }
            String delim = desc.getCellDelimiter();
            boolean replaceDelim = true;
            String delimReplacer = " ";
            String cellQuete = desc.getCellQuote();
            String string = cellQuete = cellQuete == null ? "\"" : cellQuete;
            if (delim != null && delim.length() > 0 && celi > 0) {
                csvLine.append(delim);
            }
            if (cellValue.contains("\r\n")) {
                cellValue = cellValue.replace("\r\n", " ");
            }
            if (cellValue.contains("\n\r")) {
                cellValue = cellValue.replace("\n\r", " ");
            }
            if (cellValue.contains("\n")) {
                cellValue = cellValue.replace("\n", " ");
            }
            if (cellValue.contains("\r")) {
                cellValue = cellValue.replace("\r", " ");
            }
            switch (desc.getQuoteVariants()) {
                case Never: {
                    if (replaceDelim && this.replacableDelimiter(cellValue, delim, delimReplacer)) {
                        csvLine.append(this.replaceDelimiter(cellValue, delim, delimReplacer));
                        continue block8;
                    }
                    csvLine.append(cellValue);
                    continue block8;
                }
                case Sometimes: {
                    if (this.needQuete_sometime(cellValue, cellQuete, delim)) {
                        csvLine.append(this.queteCellValue(cellValue, cellQuete));
                        continue block8;
                    }
                    csvLine.append(cellValue);
                    continue block8;
                }
                default: {
                    csvLine.append(this.queteCellValue(cellValue, cellQuete));
                }
            }
        }
        return csvLine.toString();
    }

    private boolean needQuete_sometime(String cellValue, String quete, String delim) {
        if (cellValue == null || cellValue.length() < 1) {
            return false;
        }
        for (int ci = 0; ci < cellValue.length(); ++ci) {
            if (Text.matchText((String)cellValue, (String)quete, (int)ci, (boolean)false)) {
                return true;
            }
            if (delim == null || delim.length() <= 0 || !Text.matchText((String)cellValue, (String)delim, (int)ci, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private boolean containsDelimeter(String cellValue, String delim) {
        if (cellValue == null || cellValue.length() < 1) {
            return false;
        }
        return delim != null && delim.length() > 0 && !delim.equals(" ") && cellValue.contains(delim);
    }

    private String replaceDelimiter(String cellValue, String delim, String replacer) {
        return cellValue.replace(delim, replacer);
    }

    private boolean replacableDelimiter(String cellValue, String delim, String replacer) {
        return this.containsDelimeter(cellValue, delim) && delim != null && !delim.equals(replacer);
    }

    private String queteCellValue(String cellValue, String cellQuete) {
        StringBuilder sbCell = new StringBuilder();
        for (int ci = 0; ci < cellValue.length(); ++ci) {
            boolean matched = Text.matchText((String)cellValue, (String)cellQuete, (int)ci, (boolean)false);
            if (matched) {
                sbCell.append(cellQuete);
                sbCell.append(cellQuete);
                if (cellQuete.length() <= 1) continue;
                ci += cellQuete.length() - 1;
                continue;
            }
            sbCell.append(cellValue.charAt(ci));
        }
        return cellQuete + sbCell.toString() + cellQuete;
    }
}

