/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table.store;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import xyz.cofe.collection.graph.Path;
import xyz.cofe.data.table.DataColumn;
import xyz.cofe.data.table.DataRow;
import xyz.cofe.data.table.DataTable;
import xyz.cofe.data.table.store.TableBuilder;
import xyz.cofe.simpletypes.SimpleTypes;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;
import xyz.cofe.xml.FormatXMLWriter;
import xyz.cofe.xml.stream.path.PathMatch;
import xyz.cofe.xml.stream.path.XEventPath;
import xyz.cofe.xml.stream.path.XVisitor;
import xyz.cofe.xml.stream.path.XVisitorAdapter;
import xyz.cofe.xml.stream.path.XmlReader;

public class XmlStreamStorage {
    private static final Logger logger = Logger.getLogger(XmlStreamStorage.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private static final String TABLE_TAG = "datatable";
    private static final String COLUMN_TAG = "column";
    private static final String COLUMN_NAME_ATTR = "name";
    private static final String ROW_TAG = "row";
    protected TypeCastGraph castGraph;
    public static final String COLUMNS_TAG = "columns";
    public static final String ROWS_TAG = "rows";

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(XmlStreamStorage.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(XmlStreamStorage.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(XmlStreamStorage.class.getName(), method, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeCastGraph getCastGraph() {
        XmlStreamStorage xmlStreamStorage = this;
        synchronized (xmlStreamStorage) {
            if (this.castGraph != null) {
                return this.castGraph;
            }
            this.castGraph = new ExtendedCastGraph();
            return this.castGraph;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCastGraph(TypeCastGraph castGraph) {
        XmlStreamStorage xmlStreamStorage = this;
        synchronized (xmlStreamStorage) {
            this.castGraph = castGraph;
        }
    }

    public String asString(Object val) {
        if (val == null) {
            return null;
        }
        TypeCastGraph tc = this.getCastGraph();
        return (String)tc.cast(val, String.class);
    }

    public Object asValueOf(String str, Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        if (str == null) {
            if (!SimpleTypes.isSimple((Class)cls)) {
                return null;
            }
            if (SimpleTypes.boolObject().equals(cls)) {
                return Boolean.FALSE;
            }
            if (SimpleTypes.byteObject().equals(cls)) {
                return (byte)0;
            }
            if (SimpleTypes.charObject().equals(cls)) {
                return Character.valueOf('\u0000');
            }
            if (SimpleTypes.doubleObject().equals(cls)) {
                return 0.0;
            }
            if (SimpleTypes.floatObject().equals(cls)) {
                return Float.valueOf(0.0f);
            }
            if (SimpleTypes.intObject().equals(cls)) {
                return 0;
            }
            if (SimpleTypes.longObject().equals(cls)) {
                return 0L;
            }
            if (SimpleTypes.shortObject().equals(cls)) {
                return (short)0;
            }
            return null;
        }
        TypeCastGraph tc = this.getCastGraph();
        return tc.cast((Object)str, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportDeserialize(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        XmlStreamStorage xmlStreamStorage = this;
        synchronized (xmlStreamStorage) {
            TypeCastGraph tc = this.getCastGraph();
            Path path = tc.findPath(String.class, cls);
            return path != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportSerialize(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        XmlStreamStorage xmlStreamStorage = this;
        synchronized (xmlStreamStorage) {
            TypeCastGraph tc = this.getCastGraph();
            Path path = tc.findPath(cls, String.class);
            return path != null;
        }
    }

    public synchronized void write(XMLStreamWriter xout, DataColumn memColumn) throws XMLStreamException {
        if (xout == null) {
            throw new IllegalArgumentException("xout==null");
        }
        if (memColumn == null) {
            throw new IllegalArgumentException("memColumn==null");
        }
        xout.writeStartElement(COLUMN_TAG);
        xout.writeAttribute(COLUMN_NAME_ATTR, memColumn.getName());
        xout.writeAttribute("dataType", memColumn.getDataType().getName());
        xout.writeAttribute("allowNull", memColumn.isAllowNull() ? "true" : "false");
        xout.writeAttribute("allowSubTypes", memColumn.isAllowSubTypes() ? "true" : "false");
        xout.writeEndElement();
    }

    public synchronized void write(XMLStreamWriter xout, DataRow memRow) throws XMLStreamException {
        Object v;
        if (xout == null) {
            throw new IllegalArgumentException("xout==null");
        }
        if (memRow == null) {
            throw new IllegalArgumentException("memRow==null");
        }
        xout.writeStartElement(ROW_TAG);
        xout.writeAttribute("changed", memRow.isChanged() ? "true" : "false");
        xout.writeAttribute("deleted", memRow.isDeleted() ? "true" : "false");
        xout.writeAttribute("inserted", memRow.isInserted() ? "true" : "false");
        xout.writeAttribute("updated", memRow.isUpdated() ? "true" : "false");
        Object[] vals = memRow.getData();
        Object[] orig = memRow.getOrigin();
        int changeCnt = memRow.getChangeCount();
        xout.writeAttribute("changeCounter", Integer.toString(changeCnt));
        List<DataRow.ChangedValue> chvals = memRow.getChangedValues();
        if (chvals != null && chvals.size() > 0) {
            xout.writeStartElement("changes");
            for (DataRow.ChangedValue chval : chvals) {
                xout.writeStartElement("changed");
                xout.writeAttribute(COLUMN_TAG, Integer.toString(chval.getColumn()));
                Object from = chval.getFrom();
                Object to = chval.getTo();
                if (from != null) {
                    xout.writeStartElement("from");
                    xout.writeAttribute("type", from.getClass().getName());
                    xout.writeCharacters(this.asString(from));
                    xout.writeEndElement();
                }
                if (to != null) {
                    xout.writeStartElement("to");
                    xout.writeAttribute("type", to.getClass().getName());
                    xout.writeCharacters(this.asString(to));
                    xout.writeEndElement();
                }
                xout.writeEndElement();
            }
            xout.writeEndElement();
        }
        if (orig != null) {
            xout.writeStartElement("origin");
            for (int i = 0; i < orig.length; ++i) {
                v = orig[i];
                xout.writeStartElement("value");
                if (v == null) {
                    xout.writeAttribute("isnull", "true");
                } else {
                    xout.writeAttribute("isnull", "false");
                    xout.writeAttribute("type", v.getClass().getName());
                    xout.writeCharacters(this.asString(v));
                }
                xout.writeEndElement();
            }
            xout.writeEndElement();
        }
        if (vals != null) {
            xout.writeStartElement("current");
            for (int i = 0; i < vals.length; ++i) {
                v = vals[i];
                xout.writeStartElement("value");
                if (v == null) {
                    xout.writeAttribute("isnull", "true");
                } else {
                    xout.writeAttribute("isnull", "false");
                    xout.writeAttribute("type", v.getClass().getName());
                    xout.writeCharacters(this.asString(v));
                }
                xout.writeEndElement();
            }
            xout.writeEndElement();
        }
        xout.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(XMLStreamWriter xout, DataTable dataTable) throws XMLStreamException {
        if (xout == null) {
            throw new IllegalArgumentException("xout==null");
        }
        if (dataTable == null) {
            throw new IllegalArgumentException("dataTable==null");
        }
        DataTable dataTable2 = dataTable;
        synchronized (dataTable2) {
            xout.writeStartElement(TABLE_TAG);
            xout.writeStartElement(COLUMNS_TAG);
            for (DataColumn mc : dataTable.getColumns()) {
                this.write(xout, mc);
            }
            xout.writeEndElement();
            xout.writeStartElement(ROWS_TAG);
            for (int ri = 0; ri < dataTable.getRowsCount(); ++ri) {
                DataRow mrow = dataTable.getRow(ri);
                if (mrow == null) {
                    throw new IllegalStateException("dataTable.getRow(" + ri + ")==null");
                }
                if (mrow.isInserted() || mrow.isDeleted()) continue;
                this.write(xout, mrow);
            }
            xout.writeEndElement();
            for (DataRow dr : dataTable.getRowsIterableAll()) {
                if (dr.isInserted()) {
                    xout.writeStartElement("inserted");
                    this.write(xout, dr);
                    xout.writeEndElement();
                    continue;
                }
                if (!dr.isDeleted()) continue;
                xout.writeStartElement("deleted");
                this.write(xout, dr);
                xout.writeEndElement();
            }
            xout.writeEndElement();
        }
    }

    public synchronized void write(Writer xout, DataTable mtable) {
        try {
            FormatXMLWriter fxml = new FormatXMLWriter(xout);
            fxml.setWriteOutline(true);
            XmlStreamStorage mtStorage = new XmlStreamStorage();
            mtStorage.write((XMLStreamWriter)fxml, mtable);
            fxml.flush();
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public synchronized void write(OutputStream xout, Charset cs, DataTable mtable) {
        if (cs == null) {
            cs = Charset.forName("utf-8");
        }
        try {
            FormatXMLWriter fxml = new FormatXMLWriter(xout, cs.name());
            fxml.setWriteOutline(true);
            XmlStreamStorage mtStorage = new XmlStreamStorage();
            mtStorage.write((XMLStreamWriter)fxml, mtable);
            fxml.flush();
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public synchronized void write(OutputStream xout, DataTable mtable) {
        this.write(xout, Charset.forName("utf-8"), mtable);
    }

    public synchronized void write(File xout, Charset cs, DataTable mtable) {
        if (cs == null) {
            cs = Charset.forName("utf-8");
        }
        try {
            FormatXMLWriter fxml = new FormatXMLWriter(xout, cs);
            fxml.setWriteOutline(true);
            XmlStreamStorage mtStorage = new XmlStreamStorage();
            mtStorage.write((XMLStreamWriter)fxml, mtable);
            fxml.flush();
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public synchronized void write(File xout, DataTable mtable) {
        try {
            FormatXMLWriter fxml = new FormatXMLWriter(xout, Charset.forName("utf-8"));
            fxml.setWriteOutline(true);
            XmlStreamStorage mtStorage = new XmlStreamStorage();
            mtStorage.write((XMLStreamWriter)fxml, mtable);
            fxml.flush();
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public XVisitor createXVisitor(TableBuilder tbuilder) {
        if (tbuilder == null) {
            throw new IllegalArgumentException("tbuilder == null");
        }
        return new XmlTableVisitor(tbuilder);
    }

    public synchronized void read(TableBuilder tbuilder, URL url) {
        if (tbuilder == null) {
            throw new IllegalArgumentException("tbuilder==null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        try {
            new XmlReader(url, this.createXVisitor(tbuilder));
        }
        catch (IOException | XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public synchronized void read(TableBuilder tbuilder, Reader xml) {
        if (tbuilder == null) {
            throw new IllegalArgumentException("tbuilder==null");
        }
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        try {
            new XmlReader(xml, this.createXVisitor(tbuilder));
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public synchronized void read(TableBuilder tbuilder, InputStream xml, Charset cs) {
        if (tbuilder == null) {
            throw new IllegalArgumentException("tbuilder==null");
        }
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        try {
            if (cs != null) {
                new XmlReader(xml, cs, this.createXVisitor(tbuilder));
            } else {
                new XmlReader(xml, this.createXVisitor(tbuilder));
            }
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public synchronized void read(TableBuilder tbuilder, InputStream xml) {
        if (tbuilder == null) {
            throw new IllegalArgumentException("tbuilder==null");
        }
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        try {
            new XmlReader(xml, this.createXVisitor(tbuilder));
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public synchronized void read(TableBuilder tbuilder, File xml, Charset cs) {
        if (tbuilder == null) {
            throw new IllegalArgumentException("tbuilder==null");
        }
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        try {
            if (cs != null) {
                new XmlReader(xml, cs, this.createXVisitor(tbuilder));
            } else {
                new XmlReader(xml, this.createXVisitor(tbuilder));
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public synchronized void read(TableBuilder tbuilder, File xml) {
        if (tbuilder == null) {
            throw new IllegalArgumentException("tbuilder==null");
        }
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        try {
            new XmlReader(xml, this.createXVisitor(tbuilder));
        }
        catch (IOException | XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public class XmlTableVisitor
    extends XVisitorAdapter {
        public final TableBuilder tbuilder;
        public final ArrayList origin = new ArrayList();
        public final ArrayList current = new ArrayList();
        public boolean rowChanged = false;
        public boolean rowDeleted = false;
        public boolean rowInserted = false;
        public boolean rowUpdated = false;
        public int rowChangeCounter = 0;

        public XmlTableVisitor(TableBuilder tbuilder) {
            this.tbuilder = tbuilder;
        }

        @PathMatch(enter="datatable")
        public void begin(XEventPath path) {
            this.tbuilder.begin();
        }

        @PathMatch(exit="datatable")
        public void end(XEventPath path) {
            this.tbuilder.end();
        }

        public ClassLoader classLoader() {
            ClassLoader cl = this.tbuilder.getClassLoader();
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            if (cl == null) {
                cl = XmlStreamStorage.class.getClassLoader();
            }
            return cl;
        }

        @PathMatch(enter="columns")
        public void beginColumn(XEventPath path) {
            this.tbuilder.beginColumns();
        }

        @PathMatch(enter="column")
        public void column(XEventPath path) {
            String name = path.readAttributeAsString(XmlStreamStorage.COLUMN_NAME_ATTR, "?noAttrib_name");
            String type = path.readAttributeAsString("dataType", "?noAttrib_dataType");
            ClassLoader cl = this.classLoader();
            Class<Object> dataType = null;
            try {
                dataType = Class.forName(type, true, cl);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(XmlStreamStorage.class.getName()).log(Level.SEVERE, null, ex);
                dataType = String.class;
            }
            DataColumn mc = new DataColumn(name, dataType);
            switch (path.readAttributeAsString("allowNull", "?")) {
                case "true": {
                    mc = mc.allowNull(true);
                    break;
                }
                case "false": {
                    mc = mc.allowNull(false);
                }
            }
            switch (path.readAttributeAsString("allowSubTypes", "?")) {
                case "true": {
                    mc = mc.allowSubTypes(true);
                    break;
                }
                case "false": {
                    mc = mc.allowSubTypes(false);
                }
            }
            this.tbuilder.addColumn(mc);
        }

        @PathMatch(exit="columns")
        public void endColumn(XEventPath path) {
            this.tbuilder.endColumns();
        }

        @PathMatch(enter="row")
        public void beginRow(XEventPath path) {
            this.origin.clear();
            this.current.clear();
            this.rowChanged = false;
            this.rowDeleted = false;
            this.rowInserted = false;
            this.rowUpdated = false;
            this.rowChangeCounter = 0;
            this.rowChanged = path.readAttributeAsBoolean("changed", Boolean.valueOf(false));
            this.rowDeleted = path.readAttributeAsBoolean("deleted", Boolean.valueOf(false));
            this.rowInserted = path.readAttributeAsBoolean("inserted", Boolean.valueOf(false));
            this.rowUpdated = path.readAttributeAsBoolean("updated", Boolean.valueOf(false));
            this.rowChangeCounter = path.readAttributeAsInteger("changeCounter", Integer.valueOf(0));
        }

        @PathMatch(enter="row/origin/value")
        public void rowOriginNullValue(XEventPath path) {
            if (path.readAttributeAsBoolean("isnull", Boolean.valueOf(false)).booleanValue()) {
                this.origin.add(null);
            }
        }

        @PathMatch(content="row/origin/value")
        public void rowOriginValue(XEventPath path, String content) {
            if (path.readAttributeAsBoolean("isnull", Boolean.valueOf(false)).booleanValue()) {
                return;
            }
            String type = path.readAttributeAsString("type", "?noAttrib_type");
            try {
                Class<?> cls = Class.forName(type, true, this.classLoader());
                Object v = XmlStreamStorage.this.asValueOf(content, cls);
                this.origin.add(v);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(XmlStreamStorage.class.getName()).log(Level.SEVERE, null, ex);
                this.origin.add(content);
            }
        }

        @PathMatch(enter="row/current/value")
        public void rowCurrentNullValue(XEventPath path) {
            if (path.readAttributeAsBoolean("isnull", Boolean.valueOf(false)).booleanValue()) {
                this.current.add(null);
            }
        }

        @PathMatch(content="row/current/value")
        public void rowCurrentValue(XEventPath path, String content) {
            if (path.readAttributeAsBoolean("isnull", Boolean.valueOf(false)).booleanValue()) {
                return;
            }
            String type = path.readAttributeAsString("type", "?noAttrib_type");
            try {
                Class<?> cls = Class.forName(type, true, this.classLoader());
                Object v = XmlStreamStorage.this.asValueOf(content, cls);
                this.current.add(v);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(XmlStreamStorage.class.getName()).log(Level.SEVERE, null, ex);
                this.current.add(content);
            }
        }

        @PathMatch(exit="row")
        public void endRow(XEventPath path) {
            DataTable mt = this.tbuilder.getDataTable();
            if (mt == null) {
                Logger.getLogger(XmlStreamStorage.class.getName()).log(Level.SEVERE, "table builder return null table");
                return;
            }
            DataRow mrow = new DataRow(mt, this.current.toArray(), this.origin.toArray(), this.rowChangeCounter);
            if (this.rowInserted) {
                this.tbuilder.insertedRow(mrow);
            } else if (this.rowDeleted) {
                this.tbuilder.deletedRow(mrow);
            } else if (this.rowChanged) {
                this.tbuilder.changedRow(mrow);
            } else {
                this.tbuilder.unchangedRow(mrow);
            }
        }
    }
}

