/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.fs;

import java.nio.charset.Charset;
import xyz.cofe.collection.Func2;

/**
 *
 * @author user
 */
public interface FileReadText {

    /**
     * Чтение текстового содержимого файла
     * @param cs Кодировка (возможно null, тогда будет использоваться кодировка по умолчанию)
     * @param maxSize Максимальное кол-во байт или -1
     * @param blockSize Размер блока читаемого за раз или -1
     * @param progress Функция уведомления чтения или null. <br>
     * Первый аргумент - прочитаное кол-во байт <br>
     * Второй аргумент - всего кол-во байт, которое должно быть прочтено <br>
     * @return Текстовое содержимое
     */
    String readText(Charset cs, int maxSize, int blockSize, Func2<Object, Long, Long> progress);

    /**
     * Чтение текстового содержимого файла
     * @param cs Кодировка (возможно null, тогда будет использоваться кодировка по умолчанию)
     * @param maxSize Максимальное кол-во байт или -1
     * @return Текстовое содержимое
     */
    String readText(Charset cs, int maxSize);

    /**
     * Чтение текстового содержимого файла
     * @param cs Кодировка (возможно null, тогда будет использоваться кодировка по умолчанию)
     * @return Текстовое содержимое
     */
    String readText(Charset cs);

}
