/*
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.fs;

/**
 * Работа с путями файла
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public interface Path extends Comparable<Path> {
    /**
     * Возвращает компоненты пути
     * @return компоненты пути
     */
    public String[] getComponents();
    
    /**
     * Возвращает имя файла/каталога, т.е. обычно последний компонент пути
     * @return имя файла/каталога
     */
    public String getName();
    
    /**
     * Возвращает весь путь
     * @return путь
     */
    public String getPath();
    
    /**
     * Возвращает путь соответствующий предку файла/каталога
     * @return Предок или null
     */
    public Path getParent();
    
    /**
     * Возвращает дочерний путь файла / каталога
     * @param name Имя файла/каталога
     * @return Дочерний элемент
     */
    public Path getChild( String name );
    
    /**
     * Проверяет, путь является абсолютным или относительным
     * @return true - Абсолютный
     */
    public boolean isAbsolute();
    
    /**
     * Проверят что путь является корневым
     * @return true - корень
     */
    public boolean isRoot();
    
    /**
     * Возвращает каноническую форму
     * @return Каноническая форма
     */
    public Path getCanonical();
    
    /**
     * Возвращает абсолютный путь
     * @return Абсолютный путь
     */
    public Path getAbsolute();
}
