/*
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.fs;

import java.util.Date;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public interface UnixFile 
extends File, SymbolicLinkSupport<UnixFile>
{
    /**
     * Возвращает unix path
     * @return unix path
     */
    public UnixPath getUnixPath();

    //<editor-fold defaultstate="collapsed" desc="Тип файла">
    /**
     * Возвращает симвользоное представление типа файла
     * @return тип файла
     */
    public String getType();
    
    /**
     * Возвращает информацию о файле
     * @return инф о файле
     */
    public UnixFileStat getFileStat();
    
    /**
     * Файл является FIFO
     * @return Файл является FIFO
     */
    public boolean isFifo();
    
    /**
     * Файл является символьным устройством
     * @return Файл является символьным устройством
     */
    public boolean isCharDevice();
    
    /**
     * Файл является блочным устройством
     * @return Файл является блочным устройством
     */
    public boolean isBlockDevice();
    
    /**
     * Файл является обычным "регулярным" файлом
     * @return Файл является обычным "регулярным" файлом
     */
    public boolean isRegularFile();
    
    /**
     * Файл является сокетом
     * @return Файл является сокетом
     */
    public boolean isSocket();
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="user read, write, exec">
    //<editor-fold defaultstate="collapsed" desc="user read">
    /**
     * Файл доступн для чтения владельцу
     * @return Файл доступн для чтения владельцу
     */
    public boolean isUserRead();
    
    /**
     * Файл доступн для чтения владельцу
     * @param read Файл доступн для чтения владельцу
     */
    public void setUserRead( boolean read );
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="user write">
    /**
     * Файл доступн для записи владельцу
     * @return Файл доступн для записи владельцу
     */
    public boolean isUserWrite();
    
    /**
     * Файл доступн для записи владельцу
     * @param write Файл доступн для записи владельцу
     */
    public void setUserWrite( boolean write );
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="user exec">
    /**
     * Файл доступн для исполнения владельцу
     * @return Файл доступн для исполнения владельцу
     */
    public boolean isUserExec();
    
    /**
     * Файл доступн для исполнения владельцу
     * @param exec Файл доступн для исполнения владельцу
     */
    public void setUserExec( boolean exec );
    //</editor-fold>
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="group read, write, exec">
    //<editor-fold defaultstate="collapsed" desc="group read">
    /**
     * Файл доступн для чтения группе
     * @return Файл доступн для чтения группе
     */
    public boolean isGroupRead();
    
    /**
     * Файл доступн для чтения группе
     * @param value Файл доступн для чтения группе
     */
    public void setGroupRead( boolean value );
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="group write">
    /**
     * Файл доступн для записи группе
     * @return Файл доступн для записи группе
     */
    public boolean isGroupWrite();
    
    /**
     * Файл доступн для записи группе
     * @param value Файл доступн для записи группе
     */
    public void setGroupWrite( boolean value );
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="group exec">
    /**
     * Файл доступн для исполения группе
     * @return Файл доступн для исполения группе
     */
    public boolean isGroupExec();
    
    /**
     * Файл доступн для исполения группе
     * @param value Файл доступн для исполения группе
     */
    public void setGroupExec( boolean value );
    //</editor-fold>
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="other read, write, exec">
    //<editor-fold defaultstate="collapsed" desc="other read">
    /**
     * Файл доступн для чтения остальным
     * @return Файл доступн для чтения остальным
     */
    public boolean isOtherRead();
    
    /**
     * Файл доступн для чтения остальным
     * @param value Файл доступн для чтения остальным
     */
    public void setOtherRead( boolean value );
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="other write">
    /**
     * Файл доступн для записи остальным
     * @return Файл доступн для записи остальным
     */
    public boolean isOtherWrite();
    
    /**
     * Файл доступн для записи остальным
     * @param value Файл доступн для записи остальным
     */
    public void setOtherWrite( boolean value );
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="other exec">
    /**
     * Файл доступн для исполнения остальным
     * @return Файл доступн для исполнения остальным
     */
    public boolean isOtherExec();
    
    /**
     * Файл доступн для исполнения остальным
     * @param value Файл доступн для исполнения остальным
     */
    public void setOtherExec( boolean value );
    //</editor-fold>
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="mode">
    /**
     * Указывает режим доступа к файлу
     * @return режим доступа к файлу
     */
    public int getMode();
    
    /**
     * Указывает режим доступа к файлу
     * @param mode режим доступа к файлу
     */
    public void setMode(int mode);
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="UID">
    /**
     * Указывает владельца файла
     * @return владельца файла
     */
    public int getUID();
    
    /**
     * Указывает владельца файла
     * @param uid владельца файла
     */
    public void setUID(int uid);
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="GID">
    /**
     * Указывает группу файла
     * @return группа файла
     */
    public int getGID();
    
    /**
     * Указывает группу файла
     * @param gid группа файла
     */
    public void setGID(int gid);
    //</editor-fold>
    
    /**
     * Указывает владельца файла и группу
     * @param uid Владелец
     * @param gid Группа
     */
    public void setOwner(int uid,int gid);
    
    /**
     * Возвращает время создания файла
     * @return Время создания файла
     */
    public Date getCreateDate();
    
    /**
     * Возвращает время последнего доступа файлу
     * @return время последнего доступа файлу
     */
    public Date getAccessDate();
    
    /**
     * Создает каталог с указанными правами
     * @param mode права
     */
    public void mkdir(int mode);
    
    /**
     * Создает каталог и под каталоги с указанными правами
     * @param mode права
     */
    public void mkdirs(int mode);
}
