/*
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.fs;

/**
 * Описание файла/каталога
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public interface UnixFileStat {
    /**
     * Размер в байтах
     * @return Размер в байтах
     */
    long getSize();

    /**
     * Права доступа, и прочее
     * @return права доступа и прочее
     */
    int	getMode();
    
    /**
     * INO файла.<br>
     * Из описания:
     * <i>
     * The file serial number, which distinguishes this file from all other files on 
     * the same device.
     * </i>
     * @return INO файла
     */
    long getINO();
    
    /**
     * Кол-во жестких ссылок. <br>
     * Из описания:
     * <i>
     * The number of hard links to the file. This count keeps track of how many
directories have entries for this file. If the count is ever decremented to
zero, then the file itself is discarded as soon as no process still holds it
open. Symbolic links are not counted in the total.
     * </i>
     * @return Кол-во жестких ссылок
     */
    int getNlink();

    /**
     * UID владельца файла
     * @return UID владельца файла
     */
    int getUID();
    
    /**
     * GID группы файла 
     * @return GID группы файла
     */
    int	getGID();

    /**
     * Время в секундах (от 1970 см. UNIX-Time) последнего доступа в файлу
     * @return Время в секундах (от 1970 см. UNIX-Time)
     */
    long getAccessTime();
    
    /**
     * Время в секундах (от 1970 см. UNIX-Time) модификации файла
     * @return Время в секундах (от 1970 см. UNIX-Time)
     */
    long getModifyTime();
    
    /**
     * Время в секундах (от 1970 см. UNIX-Time) создания файла
     * @return Время в секундах (от 1970 см. UNIX-Time)
     */
    long getCreateTime();

    /**
     * Кол-во блоков<br>
     * Из описания:<br>
     * <i>
     * The optimal block size for reading of writing this file, in bytes. You might
use this size for allocating the buffer space for reading of writing the file.
(This is unrelated to st_blocks (getBlocks()).)
     * </i>
     * @return Кол-во блоков
     */
    long getBlocks();
    
    /**
     * Размер блока в байтах. <br>
     * Из описания:<br>
     * <i>
This is the amount of disk space that the file occupies, measured in units
of 512-byte blocks.<br><br>
The number of disk blocks is not strictly proportional to the size of the
file, for two reasons: the file system may use some blocks for internal
record keeping; and the file may be sparse—it may have “holes” which
contain zeros but do not actually take up space on the disk.<br>
You can tell (approximately) whether a file is sparse by comparing this
value with st_size, like this:<br><br>
(st.st_blocks * 512 &lt; st.st_size)<br><br>
This test is not perfect because a file that is just slightly sparse might
not be detected as sparse at all. For practical applications, this is not a
problem.
     * </i>
     * @return Размер блока
     */
    long getBlockSize();

    /**
     * ХЗ...
     * @return см док linux / libc
     */
    long getDev();
    /**
     * ХЗ...
     * @return см док linux / libc
     */
    long getRDev();

    /**
     * ХЗ...
     * @param dev см док linux / libc
     * @return см док linux / libc
     */
    int	getMajor(long dev);
    /**
     * ХЗ...
     * @param dev см док linux / libc
     * @return см док linux / libc
     */
    int	getMinor(long dev);
}

