/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.fs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.iterators.TreeWalk;
import xyz.cofe.collection.iterators.TreeWalkItreator;
import xyz.cofe.fs.File;
import xyz.cofe.fs.IsSymbolicLink;
import xyz.cofe.fs.ResolveLink;

public class FileVisitor {
    private Set<File> visitHistory = new TreeSet<File>();
    private ErrorBehavior errorBehavior = ErrorBehavior.Continue;
    private boolean checkHistory = true;
    private boolean followLink = true;
    private boolean resolveLink = false;
    private int maxRecusiveLinkLevel = 100;
    private boolean useCanonicalPath = true;
    private boolean useAbsolutePath = false;
    protected Predicate<Stack<File>> filter = null;
    private boolean walk_isRunning = false;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(FileVisitor.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(FileVisitor.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(FileVisitor.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(FileVisitor.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(FileVisitor.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(FileVisitor.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(FileVisitor.class.getName()).log(Level.SEVERE, null, ex);
    }

    public FileVisitor() {
    }

    public FileVisitor(FileVisitor src, CopyOptions opts) {
        if (src != null && opts != null) {
            if (opts.checkHistory) {
                this.checkHistory = src.isCheckHistory();
            }
            if (opts.history) {
                this.visitHistory.clear();
                this.visitHistory.addAll(src.getVisitHistory());
            }
            if (opts.resolveLink) {
                this.resolveLink = src.isResolveLink();
            }
            if (opts.followLink) {
                this.followLink = src.isFollowLink();
            }
            if (opts.maxRecursiveLinkLevel) {
                this.maxRecusiveLinkLevel = src.getMaxRecusiveLinkLevel();
            }
            if (opts.useCanonicalPath) {
                this.useCanonicalPath = src.isUseCanonicalPath();
            }
            if (opts.useAbsolutePath) {
                this.useAbsolutePath = src.isUseAbsolutePath();
            }
            if (opts.filter) {
                this.filter = src.filter;
            }
        }
    }

    public FileVisitor clone() {
        CopyOptions opts = new CopyOptions();
        return this.clone(opts);
    }

    public FileVisitor clone(CopyOptions opts) {
        return new FileVisitor(this, opts);
    }

    public void enter(Stack<File> path) {
    }

    public void exit(Stack<File> path) {
    }

    public ErrorBehavior error(Throwable err) {
        System.err.println("error " + err.getMessage());
        return this.errorBehavior;
    }

    public Set<File> getVisitHistory() {
        if (this.visitHistory == null) {
            this.visitHistory = new TreeSet<File>();
        }
        return this.visitHistory;
    }

    public ErrorBehavior getErrorBehavior() {
        return this.errorBehavior;
    }

    public void setErrorBehavior(ErrorBehavior errorBehavior) {
        this.errorBehavior = errorBehavior;
    }

    public boolean isCheckHistory() {
        return this.checkHistory;
    }

    public void setCheckHistory(boolean checkHistory) {
        this.checkHistory = checkHistory;
    }

    public boolean isFollowLink() {
        return this.followLink;
    }

    public void setFollowLink(boolean followLink) {
        this.followLink = followLink;
    }

    public boolean isResolveLink() {
        return this.resolveLink;
    }

    public void setResolveLink(boolean resolveLink) {
        this.resolveLink = resolveLink;
    }

    public int getMaxRecusiveLinkLevel() {
        return this.maxRecusiveLinkLevel;
    }

    public void setMaxRecusiveLinkLevel(int maxRecusiveLinkLevel) {
        this.maxRecusiveLinkLevel = maxRecusiveLinkLevel;
    }

    public boolean isUseCanonicalPath() {
        return this.useCanonicalPath;
    }

    public void setUseCanonicalPath(boolean useCanonicalPath) {
        this.useCanonicalPath = useCanonicalPath;
    }

    public boolean isUseAbsolutePath() {
        return this.useCanonicalPath;
    }

    public void setUseAbsolutePath(boolean useCanonicalPath) {
        this.useCanonicalPath = useCanonicalPath;
    }

    protected File resolveLink(ResolveLink<File> rl, int currentResolve, int maxResolve) {
        if (currentResolve > maxResolve && maxResolve >= 0) {
            return null;
        }
        File f = rl.resolveLink();
        if (f == null) {
            return null;
        }
        if (f instanceof IsSymbolicLink && f instanceof ResolveLink) {
            ResolveLink frl = (ResolveLink)((Object)f);
            IsSymbolicLink fis = (IsSymbolicLink)((Object)f);
            if (fis.isSymbolicLink()) {
                File rf = this.resolveLink(frl, currentResolve + 1, maxResolve);
                if (rf == null) {
                    return f;
                }
                return rf;
            }
        }
        return f;
    }

    public Predicate<Stack<File>> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<Stack<File>> filter) {
        this.filter = filter;
    }

    private List<File> getChildrenOf_post(List<File> children) {
        for (int i = 0; i < children.size(); ++i) {
            File c = children.get(i);
            if (this.isUseAbsolutePath()) {
                c = c.getAbsolute();
            }
            if (this.isUseCanonicalPath()) {
                c = c.getCanonical();
            }
            children.set(i, c);
        }
        return children;
    }

    private Iterable<File> getChildrenOf(File parent) {
        boolean islink;
        ArrayList<File> res = new ArrayList<File>();
        if (parent == null) {
            return res;
        }
        if (this.isCheckHistory()) {
            Set<File> hist = this.getVisitHistory();
            if (hist.contains(parent)) {
                return res;
            }
            hist.add(parent);
        }
        if (parent instanceof IsSymbolicLink && (islink = ((IsSymbolicLink)((Object)parent)).isSymbolicLink())) {
            File resolved;
            if (!this.isFollowLink()) {
                return res;
            }
            if (this.isResolveLink() && parent instanceof ResolveLink && (resolved = this.resolveLink((ResolveLink)((Object)parent), 1, this.getMaxRecusiveLinkLevel())) != null) {
                if (resolved.isDirectory()) {
                    List<File> files = resolved.listFiles();
                    return this.getChildrenOf_post(files);
                }
                return this.getChildrenOf_post(res);
            }
        }
        if (parent.isDirectory()) {
            List<File> files = parent.listFiles();
            for (File f : files) {
                res.add(f);
            }
        }
        return this.getChildrenOf_post(res);
    }

    public void walk(File root) {
        if (root == null) {
            throw new IllegalArgumentException("root==null");
        }
        if (this.walk_isRunning) {
            throw new IllegalStateException("walk is running");
        }
        try {
            this.walk_isRunning = true;
            this.getVisitHistory().clear();
            Stack<File> s = new Stack<File>();
            s.push(this.isUseCanonicalPath() ? root.getCanonical() : root);
            this.walk(s);
            s.pop();
        }
        finally {
            this.walk_isRunning = false;
        }
    }

    private int walk(Stack<File> s) {
        int res = 0;
        if (this.filter != null && !this.filter.validate(s)) {
            return res;
        }
        this.enter(s);
        if (!s.empty()) {
            Iterable<File> children;
            boolean stop;
            boolean hasErr;
            block13: {
                File p = s.peek();
                hasErr = false;
                stop = false;
                children = null;
                try {
                    children = this.getChildrenOf(p);
                }
                catch (Throwable err) {
                    hasErr = true;
                    ErrorBehavior eb = this.error(err);
                    if (eb == null) break block13;
                    switch (eb) {
                        case Continue: {
                            stop = false;
                            break;
                        }
                        case Stop: {
                            stop = true;
                        }
                    }
                }
            }
            if (!hasErr) {
                if (children != null) {
                    for (File f : children) {
                        s.push(f);
                        int r = this.walk(s);
                        if (r != 0) {
                            s.pop();
                            res = 1;
                            break;
                        }
                        s.pop();
                    }
                }
            } else {
                res = stop ? 1 : 0;
            }
        }
        this.exit(s);
        return res;
    }

    public Iterable<TreeWalk<File>> treeWalkIterable(File root) {
        if (root == null) {
            throw new IllegalArgumentException("root==null");
        }
        final FileVisitor fv = this.clone();
        NodesExtracter<File, File> ne = new NodesExtracter<File, File>(){

            public Iterable<File> extract(File from) {
                Iterable itr = null;
                try {
                    itr = fv.getChildrenOf(from);
                }
                catch (Throwable err) {
                    fv.error(err);
                    itr = null;
                }
                return itr;
            }
        };
        fv.getVisitHistory().clear();
        File froot = root;
        if (this.isUseAbsolutePath()) {
            froot = froot.getAbsolute();
        }
        if (this.isUseCanonicalPath()) {
            File canon;
            froot = canon = froot.getCanonical();
        }
        final Stack stack = new Stack();
        Iterable itr = TreeWalkItreator.createIterable((Object)froot, (NodesExtracter)ne, (Predicate)new Predicate<TreeWalk<File>>(){

            public boolean validate(TreeWalk<File> value) {
                if (fv.filter == null) {
                    return true;
                }
                stack.clear();
                for (File n : value.nodePath()) {
                    stack.add(n);
                }
                return fv.filter.validate((Object)stack);
            }
        });
        return itr;
    }

    public Iterable<File> walkIterable(File root) {
        if (root == null) {
            throw new IllegalArgumentException("root==null");
        }
        Iterable<TreeWalk<File>> itr = this.treeWalkIterable(root);
        Iterable resitr = Iterators.convert(itr, new ConvertTreeWalk());
        return resitr;
    }

    public static class ConvertTreeWalk<T extends File>
    implements Convertor<TreeWalk<T>, T> {
        public T convert(TreeWalk<T> from) {
            return (T)((File)from.currentNode());
        }
    }

    public static class CopyOptions {
        public boolean checkHistory = true;
        public boolean history = false;
        public boolean followLink = true;
        public boolean resolveLink = true;
        public boolean maxRecursiveLinkLevel = true;
        public boolean useCanonicalPath = true;
        public boolean useAbsolutePath = true;
        public boolean errorBehavior = true;
        public boolean filter = true;
    }

    public static enum ErrorBehavior {
        Continue,
        Stop;

    }
}

