/*
 * The MIT License
 *
 * Copyright 2018 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.collection.tree;


import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.tree.BasicTreeNodeEvent;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeEvent;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;

/**
 * Завершения асинхронного получения списка дочерних узлов дерева
 * @author nt.gocha@gmail.com
 */
public class TreeNodeAsyncFollowed extends BasicTreeNodeEvent<TreeTableNodeBasic> implements TreeNodeEvent<TreeTableNodeBasic> {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(TreeNodeAsyncFollowed.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method,Object ... params){
        logger.entering(TreeNodeAsyncFollowed.class.getName(), method, params);
    }
    
    private static void logExiting(String method){
        logger.exiting(TreeNodeAsyncFollowed.class.getName(), method);
    }
    
    private static void logExiting(String method, Object result){
        logger.exiting(TreeNodeAsyncFollowed.class.getName(), method, result);
    }
    //</editor-fold>

    public TreeNodeAsyncFollowed(TreeNode<TreeTableNodeBasic> source) {
        super(source);
    }
    
    //<editor-fold defaultstate="collapsed" desc="fetched">
    protected volatile List<TreeTableNodeBasic> fetched;

    /**
     * Возвращает список полученых дочерних узлов
     * @return дочерние узлы
     */
    public synchronized List<TreeTableNodeBasic> getFetched(){
        if( fetched!=null )return fetched;
        fetched = new CopyOnWriteArrayList<TreeTableNodeBasic>();
        return fetched;
    }

    /**
     * Указывает список полученых дочерних узлов
     * @param fetched дочерние узлы
     */
    public synchronized void setFetched(List<TreeTableNodeBasic> fetched){
        this.fetched = fetched;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="parentEvent">
    protected volatile TreeNodeAsyncFollowing parentEvent;

    /**
     * Возвращает начальное асинхронного событие
     * @return начальное событие
     */
    public synchronized TreeNodeAsyncFollowing getParentEvent() {
        return parentEvent;
    }

    /**
     * Указывает начальное асинхронного событие
     * @param parentEvent начальное событие
     */
    public synchronized void setParentEvent(TreeNodeAsyncFollowing parentEvent) {
        this.parentEvent = parentEvent;
    }
    //</editor-fold>
}
