/*
 * The MIT License
 *
 * Copyright 2015 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.gui.swing;


import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Сохраненное состояние Graphics
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class GraphicsState {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(GraphicsState.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        Logger.getLogger(GraphicsState.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        Logger.getLogger(GraphicsState.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        Logger.getLogger(GraphicsState.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(GraphicsState.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        Logger.getLogger(GraphicsState.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(GraphicsState.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    protected boolean clipSaved = false;
    protected Shape clip = null;

    protected AffineTransform transform = null;
    protected boolean transformSaved = false;

    protected Stroke stroke = null;
    protected boolean strokeSaved = false;

    protected Paint paint = null;
    protected boolean paintSaved = false;

    protected Font font = null;
    protected boolean fontSaved = false;

    protected Color color = null;
    protected boolean colorSaved = false;

    protected Color background = null;
    protected boolean backgroundSaved = false;

    public static GraphicsState backup( Graphics gs ){
        if( gs==null )throw new IllegalArgumentException( "gs==null" );

        GraphicsState state = new GraphicsState();
        state.clip = gs.getClip();
        state.clipSaved = true;

        state.font = gs.getFont();
        state.fontSaved = true;

        state.color = gs.getColor();
        state.colorSaved = true;

        if( gs instanceof Graphics2D ){
            Graphics2D gs2 = (Graphics2D)gs;

            Object trClone = gs2.getTransform().clone();
            if( trClone instanceof AffineTransform ){
                state.transform = (AffineTransform)trClone;
                state.transformSaved = true;
            }

            state.stroke = gs2.getStroke();
            state.strokeSaved = true;

            state.paint = gs2.getPaint();
            state.paintSaved = true;

            state.background = gs2.getBackground();
            state.backgroundSaved = true;
        }

        return state;
    }

    public void restore( Graphics gs ){
        if( gs==null )throw new IllegalArgumentException( "gs==null" );

        if( fontSaved )gs.setFont(font);
        if( colorSaved )gs.setColor(color);

        if( gs instanceof Graphics2D ){
            Graphics2D gs2 = (Graphics2D)gs;

            if(transformSaved)gs2.setTransform(transform);
            if(strokeSaved)gs2.setStroke(stroke);
            if(paintSaved)gs2.setPaint(paint);
            if(backgroundSaved)gs2.setBackground(background);
        }

        if( clipSaved )gs.setClip(clip);
    }
}
