/*
 * The MIT License
 *
 * Copyright 2017 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.gui.swing.cell;

import java.awt.geom.Rectangle2D;

/**
 * Контекст (значение/расположение/таблица/...) ячнйки
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public interface CellContext {
    /**
     * Клонирование
     * @return клон
     */
    public CellContext clone();
    
    //<editor-fold defaultstate="collapsed" desc="bounds : Rectangle2D">
    /**
     * Указывает расположение контекста/рамка в которую производится отображение
     * @return Рамка
     */
    public Rectangle2D getBounds();
    
    /**
     * Указывает расположение контекста/рамка в которую производится отображение
     * @param bounds Рамка
     */
    public void setBounds(Rectangle2D bounds);
    //</editor-fold>
    
    /**
     * Уменьшает размер прямоугольника (bounds) слева
     * @param pad на сколько уменьшить
     * @return self ссылка
     */
    public CellContext padLeft( double pad );
    
    /**
     * Уменьшает размер прямоугольника (bounds) сверху
     * @param pad на сколько уменьшить
     * @return self ссылка
     */
    public CellContext padTop( double pad );
    
    /**
     * Уменьшает размер прямоугольника (bounds) справа
     * @param pad на сколько уменьшить
     * @return self ссылка
     */
    public CellContext padRight( double pad );
    
    /**
     * Уменьшает размер прямоугольника (bounds) снизу
     * @param pad на сколько уменьшить
     * @return self ссылка
     */
    public CellContext padBottom( double pad );
    
    /**
     * Смещает прямоугольник контекста
     * @param x на сколько по x
     * @param y на сколько по y
     * @return self ссылка
     */
    public CellContext move( double x, double y );
    
    /**
     * Устанавливает размер прямоугольника
     * @param width ширина
     * @param height высота
     * @return self ссылка
     */
    public CellContext size( double width, double height );
    
    //<editor-fold defaultstate="collapsed" desc="value : Object">
    /**
     * Указывает отображаемое значение
     * @return отображаемое значение
     */
    public Object getValue();
    
    /**
     * Указывает отображаемое значение
     * @param value отображаемое значение
     */
    public void setValue(Object value);
    
    /**
     * Указывает отображаемое значение
     * @param value отображаемое значение
     * @return self ссылка
     */
    public CellContext value(Object value);
    //</editor-fold>
}
