/*
 * The MIT License
 *
 * Copyright 2017 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import xyz.cofe.gui.swing.cell.CellContext;

/**
 * Рендер ячейки
 * @author Kamnev Georgiy nt.gocha@gmail.com
 */
public interface CellRender {
    /**
     * Получение размера отображаемых данных
     * @param gs объект граф вывода
     * @param context Контекст отображения
     * @return Размер и расположение отображаемых данных 
     * или null если нет определенного размера (залива и т.д.)
     */
    Rectangle2D cellRectangle( Graphics2D gs, CellContext context );
    
    /**
     * Отоброжение/рендер данных
     * @param gs объект граф вывода
     * @param context Контекст отображения
     */
    void cellRender( Graphics2D gs, CellContext context );
    
    /**
     * Создание клона
     * @return клон рендера
     */
    CellRender clone();
}
