/*
 * The MIT License
 *
 * Copyright 2018 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.gui.swing.data;


import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.data.DataRow;

/**
 * Строка таблицы подготовленная для копирования в буфер обмена
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class PreparedCopyCells {
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(PreparedCopyCells.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method,Object ... params){
        logger.entering(PreparedCopyCells.class.getName(), method, params);
    }
    
    private static void logExiting(String method){
        logger.exiting(PreparedCopyCells.class.getName(), method);
    }
    
    private static void logExiting(String method, Object result){
        logger.exiting(PreparedCopyCells.class.getName(), method, result);
    }
    //</editor-fold>
    
    /**
     * Конструктор
     */
    public PreparedCopyCells(){}

    /**
     * Конструктор
     * @param row индекс строки
     * @param dataRow строка данных
     * @param cells подготовленные ячейки
     */
    public PreparedCopyCells(int row, DataRow dataRow, List<PreparedCopyCell> cells){
        this.row = row;
        this.dataRow = dataRow;
        this.cells = cells;
    }

    private int row;
    /**
     * Возвращает индекс строки
     * @return индекс строки
     */
    public int getRow(){ return row; }
    /**
     * Указывает индекс строки
     * @param row индекс строки
     */
    public void setRow(int row) { this.row = row; }

    private DataRow dataRow;
    /**
     * Возвращает строку данных
     * @return строка данных
     */
    public DataRow getDataRow(){ return dataRow; }
    /**
     * Указывает строку данных
     * @param dataRow строка данных
     */
    public void setDataRow(DataRow dataRow) { this.dataRow = dataRow; }

    private List<PreparedCopyCell> cells;
    /**
     * Возвращает подготовленные данные ячеек строки таблицы
     * @return подготовленные данные
     */
    public List<PreparedCopyCell> getCells(){ return cells; }
    /**
     * Указывает подготовленные данные ячеек строки таблицы
     * @param cells подготовленные данные
     */
    public void setCells(List<PreparedCopyCell> cells) { this.cells = cells; }    
}
