/*
 * The MIT License
 *
 * Copyright 2017 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.gui.swing.log;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public enum LoggerLevel {
    UNDEFINED,
    ALL,
    FINEST,FINER,FINE,CONFIG,INFO,WARNING,SEVERE,
    OFF;

    public Level level(){
        switch(this){
            case ALL: return Level.ALL;
            case FINEST: return Level.FINEST;
            case FINER: return Level.FINER;
            case FINE: return Level.FINE;
            case CONFIG: return Level.CONFIG;
            case INFO: return Level.INFO;
            case WARNING: return Level.WARNING;
            case SEVERE: return Level.SEVERE;
            case OFF: return Level.OFF;
        }
        return null;
    }

    public static LoggerLevel level( Level lvl ){
        if( lvl==null )return LoggerLevel.UNDEFINED;
        if( lvl.intValue()==Level.ALL.intValue() )return LoggerLevel.ALL;
        if( lvl.intValue()==Level.FINEST.intValue() )return LoggerLevel.FINEST;
        if( lvl.intValue()==Level.FINER.intValue() )return LoggerLevel.FINER;
        if( lvl.intValue()==Level.FINE.intValue() )return LoggerLevel.FINE;
        if( lvl.intValue()==Level.CONFIG.intValue() )return LoggerLevel.CONFIG;
        if( lvl.intValue()==Level.INFO.intValue() )return LoggerLevel.INFO;
        if( lvl.intValue()==Level.WARNING.intValue() )return LoggerLevel.WARNING;
        if( lvl.intValue()==Level.SEVERE.intValue() )return LoggerLevel.SEVERE;
        if( lvl.intValue()==Level.OFF.intValue() )return LoggerLevel.OFF;
        return LoggerLevel.UNDEFINED;
    }
}