/*
 * The MIT License
 *
 * Copyright 2016 nt.gocha@gmail.com.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package xyz.cofe.gui.swing.menu;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * описывает ui действие
 * @author nt.gocha@gmail.com
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface MenuAction {
    /**
     * Идентификатор действия
     * @return идентификатор
     */
    String actionId() default "";
    
    /**
     * На кого направлено это ui действие
     * @return класс или void.class на который направлено действие
     */
    Class target() default Void.class;

    /**
     * Имя действия
     * @return имя
     */
    String name() default "";

    /**
     * Комбинации клавиш
     * @return Комбинации клавиш
     */
    Shortcut[] shortcuts() default {};

    /**
     * Идентификатор меню контейнера
     * @return идентификатор меню
     */
    String menuContainerId() default "";
    
    /**
     * Идентификатор меню
     * @return идентификатор меню
     */
    String menuId() default "";
    
    /**
     * Значение для сортировки
     * @return значение для сортировки
     */
    int menuOrder() default 0;

    /**
     * Значение для сортировки
     * @return значение для сортировки
     */
    String menuOrderAfter() default "";
}
