/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.gui.swing.menu;

/**
 * Адаптер событий меню
 * @author nt.gocha@gmail.com
 */
public class MenuAdapter implements MenuListener
{    
    @Override
    public void menuEvent(MenuEvent event) {
        if( event instanceof MenuContainer.ItemAddedEvent ){
            itemAddedEvent((MenuContainer.ItemAddedEvent)event);
        }else if( event instanceof MenuContainer.ItemRemovedEvent ){
            itemRemovedEvent((MenuContainer.ItemRemovedEvent)event);
        }else if( event instanceof MenuItem.PropertyChangedEvent ){
            propertyChangedEvent((MenuItem.PropertyChangedEvent)event);
        }
    }
 
    /**
     * Вызывается при добавлении пункта меню в котейнер меню
     * @param event описание события
     */
    protected void itemAddedEvent(MenuContainer.ItemAddedEvent event){
    }
    
    /**
     * Вызывается при удалении пункта меню из котейнера меню
     * @param event описание события
     */
    protected void itemRemovedEvent(MenuContainer.ItemRemovedEvent event){
    }
    
    /**
     * Вызывается при измении свойства пункта меню
     * @param event описание события
     */
    protected void propertyChangedEvent(MenuItem.PropertyChangedEvent event){
    }
}
