/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.gui.swing.menu;

import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JMenuBar;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.SimpleListAdapter;

/**
 * В РАЗРАБОТКЕ
 * Менюбар с автматическим обновлением при измении дерва меню
 * @author gocha
 */
public class ObserverMenuBar 
    extends JMenuBar
    implements EventListListener<MenuItem>,
    ObserverMenu
{
    /**
     * Конструктор
     */
    public ObserverMenuBar()
    {
    }

    // <editor-fold defaultstate="collapsed" desc="menu">
    private MenuItem menu = null;

    /**
     * Указывает меню
     * @return меню
     */
    public MenuItem getMenu() {
        return menu;
    }

    /**
     * Указывает меню
     * @param menu меню
     */
    public void setMenu(MenuItem menu) {
        detach();
        Object old = this.menu;
        this.menu = menu;
        attach();
        refresh();
        firePropertyChange("menu", old, menu);
    }// </editor-fold>

    // <editor-fold defaultstate="collapsed" desc="root visible">
    private boolean rootVisible = false;

    /**
     * Указывает оторбражать/нет корневой элемент меню
     * @return true - оторбажать; false - отображать дочерние как корни
     */
    public boolean isRootVisible() {
        return rootVisible;
    }

    /**
     * Указывает оторбражать/нет корневой элемент меню
     * @param rootVisible true - оторбажать; false - отображать дочерние как корни
     */
    public void setRootVisible(boolean rootVisible) {
        Object old = this.rootVisible;
        this.rootVisible = rootVisible;
        firePropertyChange("rootVisible", old, rootVisible);
    }// </editor-fold>

    private void detach(){
        Collection<Component> removeList = new HashSet<Component>();
        for( int i=0; i<this.getMenuCount(); i++ ){
            Component c = getMenu(i);
            if( c instanceof ObserverMenu ){
                ((ObserverMenu)c).setMenu(null);
                removeList.add(c);
            }
        }

        for( Component c : getComponents() ){
            if( c instanceof ObserverMenu ){
                ((ObserverMenu)c).setMenu(null);
                removeList.add(c);
            }
        }

        for( Component c : removeList ){
            remove(c);
        }

        //--------------
        if( menu instanceof MenuContainer )
            ((MenuContainer)menu).getChildren().removeEventListListener(this);
    }

    private void attach(){
        if( menu instanceof MenuContainer ){
            MenuContainer mc = (MenuContainer)menu;
            int idx = -1;
            for( MenuItem mi : mc.getChildren() ){
                idx++;
                add(idx,mi);
            }
        }

        if( menu instanceof MenuContainer )
            ((MenuContainer)menu).getChildren().addEventListListener(this);
    }
    
    protected ObserverMenuItem createObserverMenuItem(){
        return new ObserverMenuItem();
    }

    protected ObserverMenuItemCheked createObserverMenuItemCheked(){
        return new ObserverMenuItemCheked();
    }

    protected ObserverMenuContainer createObserverMenuContainer(){
        return new ObserverMenuContainer();
    }

    private void add(int idx,MenuItem mi){
        int size = this.getMenuCount();
        if( idx>size )idx = size;
        if( idx<-1 )idx=-1;

        if( mi instanceof MenuActionItem ){
            MenuActionItem mai = (MenuActionItem)mi;
            switch( mai.getType() ){
                case Checked:
                    ObserverMenuItemCheked coa = createObserverMenuItemCheked();
                    coa.setMenu((MenuActionItem)mi);
                    super.add(coa,idx);
                    break;
                case Default:
                default:
                    ObserverMenuItem oa = createObserverMenuItem();
                    oa.setMenu((MenuActionItem)mi);
                    super.add(oa,idx);
                    break;
            }
        }

        if( mi instanceof MenuContainer ){
            ObserverMenuContainer oc = createObserverMenuContainer();
            oc.setMenu((MenuContainer)mi);
            super.add(oc,idx);
        }

        refresh();
    }

    private SimpleListAdapter<MenuItem> mlAdapter = new SimpleListAdapter<MenuItem>(){
        @Override
        protected void removed(MenuItem e, EventList<MenuItem> list, Integer position) {
            MenuItem mi = e;
            remove(mi);
        }

        @Override
        protected void added(MenuItem e, EventList<MenuItem> list, Integer position) {
            MenuItem mi = e;
            add(position==null ? 0 : (int)position,mi);
        }
        
//        @Override
//        protected void deleted(EventListArgs<MenuItem> evnt)
//        {
//            MenuItem mi = evnt.getItem();
//            remove(mi);
//        }
//
//        @Override
//        protected void inserted(EventListArgs<MenuItem> evnt)
//        {
//            MenuItem mi = evnt.getItem();
//            add(evnt.getItemIndex(),mi);
//        }
    };

    private void remove(MenuItem mi){
        Collection<Component> removeList = new HashSet<Component>();
        for( int i=0; i<this.getMenuCount(); i++ ){
            Component c = getMenu(i);
            if( c instanceof ObserverMenu ){
                MenuItem cmi = ((ObserverMenu)c).getMenu();
                if( cmi!=null && cmi==mi ){
                    ((ObserverMenu)c).setMenu(null);
                    removeList.add(c);
                }
            }
        }

        for( Component c : getComponents() ){
            if( c instanceof ObserverMenu ){
                MenuItem cmi = ((ObserverMenu)c).getMenu();
                if( cmi!=null && cmi==mi ){
                    ((ObserverMenu)c).setMenu(null);
                    removeList.add(c);
                }
            }
        }

        for( Component c : removeList ){
            remove(c);
        }

        refresh();
    }

    @Override
    public void listItemsChanged(Object evnt) {
        mlAdapter.listItemsChanged(evnt);
    }
    
//    @Override
//    public void listItemsChanged(EventListArgs<MenuItem> evnt)
//    {
//        mlAdapter.listItemsChanged(evnt);
//    }

    private void refresh(){
//        invalidate();
        validate();
//        repaint();
    }
}
