/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.gui.swing.menu;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.EventListListener;
import xyz.cofe.collection.list.SimpleListAdapter;

public class ObserverMenuContainer extends JMenu
                                 implements PropertyChangeListener,
                                            EventListListener<MenuItem>,
                                            ObserverMenu
{
    public ObserverMenuContainer(){
        addMenuListener(new javax.swing.event.MenuListener() {
            @Override
            public void menuSelected(MenuEvent e) {
                onSelected(e);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
//                throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
            }

            @Override
            public void menuCanceled(MenuEvent e) {
//                throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
            }
        });
    }
    
    protected void onSelected(MenuEvent ev){
        if( menu!=null ){
            for( Object o : MenuItem.actionsOf(menu) ){
                if( o instanceof UpdateUI ){
                    ((UpdateUI)o).updateUI();
                }
            }
        }
    }

    private MenuItem menu = null;

    @Override
    public MenuItem getMenu()
    {
        return menu;
    }

    @Override
    public void setMenu(MenuItem menu)
    {
        if( this.menu!=null )detach();
        unbindChildren();

        this.menu = menu;

        refreshView();
        bindChildren();
        if( this.menu!=null )attach();
    }

    private void detach(){
        menu.removePropertyChangeListener(this);
        if( menu instanceof MenuContainer )((MenuContainer)menu).getChildren().removeEventListListener(this);
    }

    private void attach(){
        menu.addPropertyChangeListener(this);
        if( menu instanceof MenuContainer )((MenuContainer)menu).getChildren().addEventListListener(this);
    }

    private void refreshView(){
        setText();
        setIcon( (menu==null || !(menu instanceof MenuContainer)) ? null : ((MenuContainer)menu).getIcon() );
    }

    private void unbindChildren(){
        Collection<Component> toRemove = new ArrayList<Component>();
        for( Component c : getMenuComponents() ){
            if( c==null )continue;
            if( !(c instanceof ObserverMenu) )continue;
//                MenuItem cmi = ((ObserverMenu)c).getMenu();
            toRemove.add( c );
            ((ObserverMenu)c).setMenu(null);
        }
        for( Component c : toRemove )remove(c);
    }

    private void bindChildren(){
        if( menu instanceof MenuContainer ){
            MenuContainer mc = ((MenuContainer)menu);
            int idx = -1;
            for( MenuItem mi : mc.getChildren() ){
                idx++;
//                int idx = mc.getChildren().indexOf(mi);
                add(idx,mi);
            }
        }
    }

    private void setText()
    {
        String text = (menu==null || !(menu instanceof MenuContainer)) ? null : ((MenuContainer)menu).getText();
        if( text==null )text = (menu!=null ? menu.getId() : null);
        if( text==null )text = "???";
        setText(text);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt)
    {
        if( evt==null )return;
        refreshView();
    }

    private SimpleListAdapter<MenuItem> mlAdapter = new SimpleListAdapter<MenuItem>(){
        @Override
        protected void removed(MenuItem e, EventList<MenuItem> list, Integer position) {
            MenuItem mi = e;
            remove(mi);
        }

        @Override
        protected void added(MenuItem e, EventList<MenuItem> list, Integer position) {
            MenuItem mi = e;
            int idx = position==null ? 0 : (int)position;
            add(idx,mi);
        }
//        @Override
//        protected void deleted(EventListArgs<MenuItem> evnt)
//        {
//            MenuItem mi = evnt.getItem();
//            remove(mi);
//        }
//
//        @Override
//        protected void inserted(EventListArgs<MenuItem> evnt)
//        {
//            MenuItem mi = evnt.getItem();
//            int idx = evnt.getItemIndex();
//            add(idx,mi);
//        }
    };

    private void remove(MenuItem mi){
        Collection<Component> toRemove = new ArrayList<Component>();
        for( Component c : getMenuComponents() ){
            if( c==null )continue;
            if( !(c instanceof ObserverMenu) )continue;
            MenuItem cmi = ((ObserverMenu)c).getMenu();
            if( cmi!=null && cmi==mi ){
                toRemove.add( c );
                ((ObserverMenu)c).setMenu(null);
            }
        }
        for( Component c : toRemove )remove(c);
    }

    protected ObserverMenuItem createObserverMenuItem(){
        return new ObserverMenuItem();
    }

    protected ObserverMenuItemCheked createObserverMenuItemCheked(){
        return new ObserverMenuItemCheked();
    }

    protected ObserverMenuContainer createObserverMenuContainer(){
        return new ObserverMenuContainer();
    }
    
    protected ObserverMenuSeparator createObserverMenuSeparator(){
        return new ObserverMenuSeparator();
    }
    
    private void add(int idx,MenuItem mi){
        int size = ObserverMenuContainer.this.getMenuComponentCount();
        if( idx>size )idx = size;

        if( mi instanceof MenuActionItem ){
            Component c = null;
            ObserverMenu om = null;
            
            switch( ((MenuActionItem)mi).getType() ){
                case Checked:
                    ObserverMenuItemCheked coa = createObserverMenuItemCheked();
                    c = coa;
                    om = coa;
                    break;
                case Default:
                default:
                    ObserverMenuItem oa = createObserverMenuItem();
                    c = oa;
                    om = oa;
                    break;
            }

            om.setMenu((MenuActionItem)mi);

            if( idx>=0 ){
                super.add(c,idx);
            }else{
                super.add(c);
            }
        }

        if( mi instanceof MenuContainer ){
            ObserverMenuContainer oc = createObserverMenuContainer();
            oc.setMenu((MenuContainer)mi);
            if( idx>=0 ){
                super.add(oc,idx);
            }else{
                super.add(oc);
            }
        }

        if( mi instanceof MenuSeparatorItem ){
            ObserverMenuSeparator os = createObserverMenuSeparator();
            os.setMenu(mi);
            if( idx>=0 ){
                super.add(os,idx);
            }else{
                super.add(os);
            }
        }
    }

    @Override
    public void listItemsChanged(Object evnt) {
        mlAdapter.listItemsChanged(evnt);
    }
}
