/*
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"),
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ,
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ,
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.gui.swing.menu;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.SimpleListAdapter;
import xyz.cofe.gui.swing.button.DropDownButton;

/**
 * @author gocha
 */
public class ObserverMenuDropDownButton extends DropDownButton implements ObserverMenu
{
    public ObserverMenuDropDownButton(){
    }

    private JPopupMenu getPopupMenu(){
        JPopupMenu popup = getComponentPopupMenu();
        if( popup==null ){
            popup = new JPopupMenu();
            setComponentPopupMenu(popup);
        }
        return popup;
    }

    // <editor-fold defaultstate="collapsed" desc="Menu property">
    private MenuItem menu = null;

    @Override
    public MenuItem getMenu() {
        return menu;
    }

    @Override
    public void setMenu(MenuItem menu) {
        Object old = this.menu;
        if (this.menu != null) {
            detach();
        }
        this.menu = menu;
        if (this.menu != null) {
            attach();
        }
        firePropertyChange("menu", old, menu);
    }// </editor-fold>
    // <editor-fold defaultstate="collapsed" desc="attach / detach">
    private void attach() {
        if (menu instanceof MenuActionItem) {
            MenuActionItem mai = (MenuActionItem) menu;
            setAction(mai.getAction());
        } else if (menu instanceof MenuContainer) {
            bindChildren();
            refreshMenuContainerProperties();
            menu.addPropertyChangeListener(menuPropListener);
        }
        setEnabled(true);
    }

    private void detach() {
        if (menu instanceof MenuActionItem) {
            setAction(null);
        } else if (menu instanceof MenuContainer) {
            unbindChildren();
            menu.removePropertyChangeListener(menuPropListener);
        }
        setEnabled(false);
    }// </editor-fold>
    // <editor-fold defaultstate="collapsed" desc="Menu container properties listener">
    private PropertyChangeListener menuPropListener = new PropertyChangeListener()
    {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null)
                return;

            if (propName.equals("text"))
                refreshMenuContainerProperties();
            else if (propName.equals("icon"))
                refreshMenuContainerProperties();
            else if (propName.equals("id"))
                refreshMenuContainerProperties();
        }
    };

    private void refreshMenuContainerProperties() {
        if (!(menu instanceof MenuContainer))return;
        MenuContainer mc = (MenuContainer) menu;

        javax.swing.Icon ico = mc.getIcon();
        String text = mc.getText();

        if (ico != null) {
            setIcon(ico);
            setText("");
            setToolTipText(text == null ? null : text);
        } else {
            String id = mc.getId();
            if (text == null)
                text = id;
            if (text == null)
                text = "?";
            setToolTipText(null);
            setIcon(null);
            setText(text);
        }
    }// </editor-fold>
    // <editor-fold defaultstate="collapsed" desc="Binding children list">
    private void unbindChildren() {
        MenuContainer mc = (MenuContainer) menu;
        mc.getChildren().removeEventListListener(menuContainerListener);
        clearChildren();
    }

    private void bindChildren() {
        MenuContainer mc = (MenuContainer) menu;
        mc.getChildren().addEventListListener(menuContainerListener);
        for (MenuItem mi : mc.getChildren()) {
            onChildInserted(mi);
        }
    }

    private void clearChildren() {
        JPopupMenu popup = getComponentPopupMenu();
        if (popup == null)
            return;

        MenuElement[] elements = popup.getSubElements();
        for (MenuElement e : elements) {
            if (e instanceof Component) {
                Component c = (Component) e;
                popup.remove(c);
            }
            if (e instanceof ObserverMenu) {
                ObserverMenu om = (ObserverMenu) e;
                om.setMenu(null);
            }
        }
    }

    private SimpleListAdapter<MenuItem> menuContainerListener = new SimpleListAdapter<MenuItem>()
    {
        @Override
        protected void removed(MenuItem e, EventList<MenuItem> list, Integer position) {
            onChildDeleted(e);
        }

        @Override
        protected void added(MenuItem e, EventList<MenuItem> list, Integer position) {
            int idx = position==null ? 0 : (int)position;
            MenuItem mi = e;
            onChildInserted(idx, mi);
        }

//        @Override
//        protected void deleted(MenuItem item) {
//            onChildDeleted(item);
//        }
//
//        @Override
//        protected void inserted(EventListArgs<MenuItem> evnt) {
//            int idx = evnt.getItemIndex();
//            MenuItem mi = evnt.getItem();
//            onChildInserted(idx, mi);
//        }
    };

    private void onChildDeleted(MenuItem mi) {
        if (mi == null)
            return;

        JPopupMenu popup = getComponentPopupMenu();
        if (popup == null)
            return;

        Set forDelete = new HashSet();
        MenuElement[] elements = popup.getSubElements();
        for (MenuElement e : elements) {
            if (e instanceof ObserverMenu) {
                ObserverMenu om = (ObserverMenu) e;
                if (mi == om.getMenu()) {
                    forDelete.add(e);
                }
            }
        }

        for (Object e : forDelete) {
            if (e instanceof Component) {
                Component c = (Component) e;
                popup.remove(c);
            }
            ObserverMenu om = (ObserverMenu) e;
            om.setMenu(null);
        }
    }

    protected ObserverMenuItem createObserverMenuItem(){
        return new ObserverMenuItem();
    }

    protected ObserverMenuItemCheked createObserverMenuItemCheked(){
        return new ObserverMenuItemCheked();
    }

    protected ObserverMenuContainer createObserverMenuContainer(){
        return new ObserverMenuContainer();
    }

    protected ObserverMenuSeparator createObserverMenuSeparator(){
        return new ObserverMenuSeparator();
    }

    private void onChildInserted(int idx, MenuItem mi) {
        int subElementsCount = getPopupMenu().getSubElements().length;
        boolean append = idx < 0 || idx >= subElementsCount;

        Component miComponent = null;
        if (mi instanceof MenuSeparatorItem) {
            ObserverMenuSeparator oms = createObserverMenuSeparator();
            oms.setMenu(mi);
            miComponent = oms;
        } else if (mi instanceof MenuActionItem) {
            ObserverMenuItem omi = createObserverMenuItem();
            omi.setMenu(mi);
            miComponent = omi;
        } else if (mi instanceof MenuContainer) {
            ObserverMenuContainer omc = createObserverMenuContainer();
            omc.setMenu(mi);
            miComponent = omc;
        }

        if (miComponent != null) {
            if (append) {
                getPopupMenu().add(miComponent);
            } else {
                getPopupMenu().insert(miComponent, idx);
            }
        }
    }

    private void onChildInserted(MenuItem mi) {
        onChildInserted(-1, mi);
    }// </editor-fold>
}
