/*
 * The MIT License
 *
 * Copyright 2016 nt.gocha@gmail.com.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package xyz.cofe.gui.swing.menu;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import xyz.cofe.gui.swing.BasicAction;
import xyz.cofe.gui.swing.shortcuts.ShortcutManager;

/**
 * Клавиатурная комбинация
 * @author nt.gocha@gmail.com
 * @see ShortcutManager
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface Shortcut {
    /**
     * Описывает комюинацю меню.
     * <p>
     * 
     * Синтаксис
     * <pre>
     * &lt;modifiers&gt;* (&lt;typedID&gt; | &lt;pressedReleasedID&gt;)
     * modifiers := shift | control | ctrl | meta | alt | altGraph
     * typedID := typed &lt;typedKey&gt;
     * typedKey := string of length 1 giving Unicode character.
     * pressedReleasedID := (pressed | released) key
     * key := KeyEvent key code name, i.e. the name following "VK_".
     * @return комбинация клавиш
     * </pre>
     */
    String keys() default "";

    /**
     * Для какого элемента UI вызывается действие
     * @return класс UI
     * @see BasicAction#setTarget(java.lang.Class) 
     */
    Class target() default Void.class;
}
