/*
 * The MIT License
 *
 * Copyright 2017 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.gui.swing.properties.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func2;
import xyz.cofe.common.ListenersHelper;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class PropertyEditorSupport {    
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(PropertyEditorSupport.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method,Object ... params){
        logger.entering(PropertyEditorSupport.class.getName(), method, params);
    }
    
    private static void logExiting(String method){
        logger.exiting(PropertyEditorSupport.class.getName(), method);
    }
    
    private static void logExiting(String method, Object result){
        logger.exiting(PropertyEditorSupport.class.getName(), method, result);
    }
    //</editor-fold>
    
    public PropertyEditorSupport(PropertyEditor pe){
        if (pe== null) {
            throw new IllegalArgumentException("pe==null");
        }
        this.pe = pe;
    }
    
    protected PropertyEditor pe;
    
    protected String[] tags = new String[]{};

    public String[] getTags() {
        return tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }
    
    protected final ListenersHelper<PropertyChangeListener, PropertyChangeEvent>
        propertiesListeners = new ListenersHelper<PropertyChangeListener, PropertyChangeEvent>( 
            new Func2<Object, PropertyChangeListener, PropertyChangeEvent>() {
                @Override
                public Object apply(PropertyChangeListener ls, PropertyChangeEvent ev) {
                    ls.propertyChange(ev);
                    return null;
                }
            }            
        );

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if( listener!=null ){
            propertiesListeners.addListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if( listener!=null ){
            propertiesListeners.removeListener(listener);
        }
    }
    
    public void firePropertyChanged( String name, Object oldValue, Object newValue ){
        if (name== null) {
            throw new IllegalArgumentException("name==null");
        }
        propertiesListeners.fireEvent(new PropertyChangeEvent(pe, name, oldValue, newValue));
    }
}
