/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.gui.swing.table.impl;

import xyz.cofe.gui.swing.table.*;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import xyz.cofe.collection.Predicate;
import xyz.cofe.common.Reciver;
import xyz.cofe.text.Output;

/**
 * @author gocha
 */
public class FilterRowTMUnOrdererMaps extends WrapTM 
    implements GetRowToSourceMap, GetSourceToRowMap
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(FilterRowTMUnOrdererMaps.class.getName());
    //private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logger.getLevel()==null 
        ? true
        : logger.getLevel().intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logger.getLevel()==null 
        ? true
        : logger.getLevel().intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logger.getLevel()==null 
        ? true
        : logger.getLevel().intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logger.getLevel()==null 
        ? true
        : logger.getLevel().intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logger.getLevel()==null 
        ? true
        : logger.getLevel().intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest(){ return 
        logger.getLevel()==null 
        ? false
        : logger.getLevel().intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method,Object ... params){
        logger.entering(FilterRowTMUnOrdererMaps.class.getName(), method, params);
    }
    
    private static void logExiting(String method){
        logger.exiting(FilterRowTMUnOrdererMaps.class.getName(), method);
    }
    
    private static void logExiting(String method, Object result){
        logger.exiting(FilterRowTMUnOrdererMaps.class.getName(), method, result);
    }
    //</editor-fold>

    // <editor-fold defaultstate="collapsed" desc="rowFilter">
    protected Predicate<RowData> rowFilter = null;
    private RowData rowData = new RowData();

    public void setRowFilter(Predicate<RowData> filter) {
        Object old = this.rowFilter;
        this.rowFilter = filter;
        applyFilter();
        firePropertyChange("rowFilter", old, rowFilter);
    }

    public Predicate<RowData> getRowFilter() {
        return rowFilter;
    }
    // </editor-fold>

    //<editor-fold defaultstate="collapsed" desc="validateIndexOnInsertEach">
    private static volatile Integer validateIndexOnInsertEach = null;
    
    /**
     * Сис. свойство <b>xyz.cofe.gui.swing.table.FilterRowTMImpl.validateIndex.onInsertEach</b> <i>=100</i>.
     * <p>
     * 
     * Указывает через сколько вставок проводить проверку на правильность индексов 
     * @return кол-во, 0-не проводить, 1-каждая, 2-каждая вторая
     */
    public static int getValidateIndexOnInsertEach() {
        if( validateIndexOnInsertEach==null ){
            String val =
            System.getProperties().getProperty(
                "xyz.cofe.gui.swing.table.FilterRowTM.validateIndex.onInsertEach", "100");
            
            if( val==null || !val.matches("-?\\d+") ){
                validateIndexOnInsertEach = 100;
            }else{
                validateIndexOnInsertEach = Integer.parseInt(val);
            }
        }
        return validateIndexOnInsertEach;
    }
    
    /**
     * см ссылку
     * @param validateIndexOnInsertEach Проверять индекс на кажой N вставке
     * @see #getValidateIndexOnInsertEach() 
     */
    public static void setValidateIndexOnInsertEach(int validateIndexOnInsertEach) {
       FilterRowTMUnOrdererMaps.validateIndexOnInsertEach = validateIndexOnInsertEach;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="validateIndexOnUpdateEach">
    private static volatile Integer validateIndexOnUpdateEach = null;
    
    /**
     * Сис. свойство <b>xyz.cofe.gui.swing.table.FilterRowTMImpl.validateIndex.onUpdateEach</b> <i>=100</i>.
     * <p>
     * 
     * Указывает через сколько обновлений проводить проверку на правильность индексов 
     * @return кол-во, 0-не проводить, 1-каждая, 2-каждая вторая
     */
    public static int getValidateIndexOnUpdateEach() {
        if( validateIndexOnUpdateEach==null ){
            String val =
            System.getProperties().getProperty(
                "xyz.cofe.gui.swing.table.FilterRowTM.validateIndex.onUpdateEach", "100");
            
            if( val==null || !val.matches("-?\\d+") ){
                validateIndexOnUpdateEach = 100;
            }else{
                validateIndexOnUpdateEach = Integer.parseInt(val);
            }
        }
        return validateIndexOnUpdateEach;
    }
    
    /**
     * см ссылку
     * @param validateIndexOnUpdateEach Проверять индекс на кажой N обновлении
     * @see #getValidateIndexOnUpdateEach() 
     */
    public static void setValidateIndexOnUpdateEach(int validateIndexOnUpdateEach) {
        FilterRowTMUnOrdererMaps.validateIndexOnUpdateEach = validateIndexOnUpdateEach;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="validateIndexOnDeleteEach">
    private static volatile Integer validateIndexOnDeleteEach = null;
    
    /**
     * Сис. свойство <b>xyz.cofe.gui.swing.table.FilterRowTMImpl.validateIndex.onDeleteEach</b> <i>=100</i>.
     * <p>
     * 
     * Указывает через сколько обновлений проводить проверку на правильность индексов 
     * @return кол-во, 0-не проводить, 1-каждая, 2-каждая вторая
     */
    public static int getValidateIndexOnDeleteEach() {
        if( validateIndexOnDeleteEach==null ){
            String val =
            System.getProperties().getProperty(
                "xyz.cofe.gui.swing.table.FilterRowTM.validateIndex.onDeleteEach", "100");
            
            if( val==null || !val.matches("-?\\d+") ){
                validateIndexOnDeleteEach = 100;
            }else{
                validateIndexOnDeleteEach = Integer.parseInt(val);
            }
        }
        return validateIndexOnDeleteEach;
    }
    
    /**
     * см ссылку
     * @param validateIndexOnDeleteEach Проверять индекс на кажой N удалении
     * @see #getValidateIndexOnUpdateEach() 
     */
    public static void setValidateIndexOnDeleteEach(int validateIndexOnDeleteEach) {
        FilterRowTMUnOrdererMaps.validateIndexOnDeleteEach = validateIndexOnDeleteEach;
    }
    //</editor-fold>
    
    private static boolean eq( Object a, Object b ){
        if( a==null && b==null )return true;
        if( a==null && b!=null )return false;
        if( a!=null && b==null )return false;
        return a.equals(b);
    }
    
    private TreeMap<Integer,Integer> row2srcMap = null;
    private TreeMap<Integer,Integer> src2rowMap = null;
    
    public synchronized TreeMap<Integer,Integer> getRowToSourceMap(){
        if( row2srcMap==null )return new TreeMap<>();
        return new TreeMap<>(row2srcMap);
    }

    public synchronized TreeMap<Integer,Integer> getSourceToRowMap(){
        if( src2rowMap==null )return new TreeMap<>();
        return new TreeMap<>(src2rowMap);
    }

    @Override
    public synchronized int getRowCount() {
        if( row2srcMap==null )return super.getRowCount();
        return row2srcMap.size();
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount();
    }

    @Override
    public int mapColumnToInside(int columnIndex) {
        return super.mapColumnToInside(columnIndex);
    }

    @Override
    public synchronized int mapRowToInside(int rowIndex) {
        if( row2srcMap!=null ){
            if( row2srcMap.containsKey(rowIndex) )
                return row2srcMap.get(rowIndex);
            return -1;
        }
        return super.mapRowToInside(rowIndex);
    }

    @Override
    public synchronized int mapRowToOutside(int rowIndex) {
        if( src2rowMap==null )return rowIndex;
        if( !src2rowMap.containsKey(rowIndex) )return -1;
        return src2rowMap.get(rowIndex);
    }
    
    public void applyFilter(){
        applyFilter( true );
    }
    
    public synchronized void applyFilter(boolean fireAllChanged){
        logFine("applyFilter({0}), filter setted={1}", fireAllChanged, rowFilter!=null);
        
        if(row2srcMap!=null)row2srcMap.clear();
        row2srcMap = null;

        if( src2rowMap!=null )src2rowMap.clear();
        src2rowMap = null;

        if( rowFilter!=null && tableModel!=null ){
            row2srcMap = new TreeMap<>();
            src2rowMap = new TreeMap<>();

            rowData.setTableModel(tableModel);
            int destRi = 0;
            for( int srcRi=0; srcRi<tableModel.getRowCount(); srcRi++ ){
                rowData.setRowIndex(srcRi);
                if( rowFilter.validate(rowData) ){
                    row2srcMap.put(destRi, srcRi);
                    src2rowMap.put(srcRi, destRi);
                    destRi++;
                }
            }
        }

        if( fireAllChanged )fireAllChanged();
    }

    @Override
    public synchronized void setTableModel(TableModel tableModel) {
        super.setTableModel(tableModel);
        rowData.setTableModel(tableModel);
        applyFilter();
    }
    
    /**
     * Сдвиг индексов при вставке исходных
     * @param from  исходный индекс - начало
     * @param toInc исходный индекс - конец
     */
    protected synchronized void shiftOnInsertIndexes( int from, int toInc ){
        logFine("shiftOnInsertIndexes({0},{1})", from,toInc);
        
        if( row2srcMap==null )return;
        
        int icnt = toInc - from + 1;
        if( icnt<=0 )return;
        
        for( Map.Entry<Integer,Integer> me : row2srcMap.entrySet() ){
            Integer si = me.getValue();
            if( si>=from ){
                me.setValue(si+icnt);
//                log
            }
        }
        
        if( src2rowMap == null )src2rowMap = new TreeMap<>();
        src2rowMap.clear();        
        for( Map.Entry<Integer,Integer> me : row2srcMap.entrySet() ){
            src2rowMap.put(me.getValue(), me.getKey());
        }
    }
    
    /**
     * Сдвиг индексов при удалении исходных
     * @param from  исходный индекс - начало
     * @param toInc исходный индекс - конец
     * @param deletedOutterIndexes удаление исходящих индексов
     */
    protected synchronized void shiftOnDeleteIndexes( int from, int toInc, Reciver<Integer> deletedOutterIndexes ){
        logFine("shiftOnDeleteIndexes({0},{1})", from,toInc);
        if( row2srcMap==null )return;
        
        int icnt = toInc - from + 1;
        if( icnt<=0 )return;
        
        LinkedHashSet<Integer> removedDI = new LinkedHashSet<>();
        
        for( Map.Entry<Integer,Integer> me : row2srcMap.entrySet() ){
            Integer di = me.getKey();
            Integer si = me.getValue();
            if( si < from )continue;
            if( si <= toInc ){
                removedDI.add(di);
            }else{
                Integer si2 = si - icnt;
                me.setValue(si2);
            }
        }
        
        for( Integer di : removedDI ){        
        //removedDI.forEach( di -> {
            row2srcMap.remove(di);
            if( deletedOutterIndexes!=null )
                deletedOutterIndexes.recive(di );
        } //);

        // reindex row2srcMap
        AtomicInteger ni = new AtomicInteger(0);
        TreeMap<Integer,Integer> nrow2srcMap = new TreeMap<>();
        for( Map.Entry<Integer,Integer> en : row2srcMap.entrySet() ){
            Integer di = en.getKey();
            Integer si = en.getValue();
        //row2srcMap.forEach( (di,si) -> {
            nrow2srcMap.put(ni.get(), si);
            ni.incrementAndGet();
        }//);
        row2srcMap = nrow2srcMap;
        
        if( src2rowMap == null )src2rowMap = new TreeMap<>();
        src2rowMap.clear();        
        for( Map.Entry<Integer,Integer> me : row2srcMap.entrySet() ){
            src2rowMap.put(me.getValue(), me.getKey());
        }
    }
    
    /**
     * Быстрая проверка ключей rows2srcMap, на предмет заполнения от 0 до N
     */
    protected synchronized void checkDestIndexesFast(){
        if( row2srcMap==null )return;
        
        int size = row2srcMap.size();
        if( size<1 )return;
        
        int fk = row2srcMap.firstKey();
        if( fk!=0 )throw new Error("checkDestIndexesFast fail, fk="+fk);
        
        int lk = row2srcMap.lastKey();
        if( lk!=(size-1) )
            throw new Error("checkDestIndexesFast fail, lk="+lk+" size="+size);
    }
    
    /**
     * Проверка валидности индексов. <br>
     * Индексы должны:
     * <ul>
     * <li>row2srcMap - ключи начинаться 0</li>
     * <li>row2srcMap - ключи закачиваться row2srcMap.size()-1</li>
     * <li>row2srcMap - ключи не иметь пропусков</li>
     * <li>row2srcMap - значения ссылаться на src2rowMap</li>
     * <li>row2srcMap - значения ссылаться на src2rowMap, те ссылаться на изначальные ключи row2srcMap</li>
     * <li>row2srcMap.size() = src2rowMap.size()</li>
     * </ul>
     * @return Индексы валидны
     */
    protected synchronized boolean isIndexesValid(){
        logFine("isIndexesValid() r2s.size={0} s2r.size={1} begin", 
            row2srcMap==null ? null : row2srcMap.size(),
            src2rowMap==null ? null : src2rowMap.size()
        );
        
        Boolean res = null;
        long ms0 = System.currentTimeMillis();
        long ns0 = System.nanoTime();
        
        try {
            //<editor-fold defaultstate="collapsed" desc="validateing">
            if( row2srcMap==null ){
                if( src2rowMap!=null ){
                    logWarning("isIndexesValid row2srcMap==null && src2rowMap!=null");
                    res = false;
                    return false;
                }
            }
            if( src2rowMap==null ){
                if( row2srcMap!=null ){
                    logWarning("isIndexesValid row2srcMap!=null && src2rowMap==null");
                    res = false;
                    return false;
                }
            }
            if( src2rowMap==null && row2srcMap==null ){
                res = true;
                return true;
            }
            
            if( row2srcMap.size()!=src2rowMap.size() ){
                logWarning("isIndexesValid row2srcMap.size() != src2rowMap.size()");
                res = false;
                return false;
            }
            
            if( row2srcMap.size()<1 ){
                res = true;
                return true;
            }
            
            Integer rs_fk = row2srcMap.firstKey();
            Integer rs_lk = row2srcMap.lastKey();
            
            if( rs_fk==null ){
                logWarning("row2srcMap.firstKey() == null");
                return false;
            }
            
            if( rs_lk==null ){
                logWarning("row2srcMap.lastKey() == null");
                res = false;
                return false;
            }
            
            if( rs_fk!=0 ){
                logWarning("row2srcMap.lastKey() != 0");
                res = false;
                return false;
            }
            
            if( rs_lk!=(row2srcMap.size()-1) ){
                logWarning("row2srcMap.lastKey() != (row2srcMap.size()-1)");
                if( isLogFiner ){
                    StringWriter sw = new StringWriter();
                    dump( new Output(sw,true) );
                    logWarning("dump:\n{0}", sw.toString());
                }
                res = false;
                return false;
            }
            
            int idx = -1;
            for( Map.Entry<Integer,Integer> rs_e : row2srcMap.entrySet() ){
                idx++;
                Integer rs_di = rs_e.getKey();
                Integer rs_si = rs_e.getValue();
                if( rs_di==null || rs_di!=idx ){
                    logWarning("row2srcMap key={0} waitKey={1} key null or not equ wait", rs_di, idx);
                    if( isLogFiner ){
                        StringWriter sw = new StringWriter();
                        dump( new Output(sw,true) );
                        logWarning("dump:\n{0}", sw.toString());
                    }
                    res = false;
                    return false;
                }
                if( rs_si==null ){
                    logWarning("row2srcMap key={0} value={1} value null", rs_di, rs_si);
                    if( isLogFiner ){
                        StringWriter sw = new StringWriter();
                        dump( new Output(sw,true) );
                        logWarning("dump:\n{0}", sw.toString());
                    }
                    res = false;
                    return false;
                }
                
                if( !src2rowMap.containsKey(rs_si) ){
                    logWarning("src2rowMap key={0} not found", rs_si );
                    if( isLogFiner ){
                        StringWriter sw = new StringWriter();
                        dump( new Output(sw,true) );
                        logWarning("dump:\n{0}", sw.toString());
                    }
                    res = false;
                    return false;
                }
                
                Integer sr_di = src2rowMap.get(rs_si);
                if( sr_di==null ){
                    logWarning("src2rowMap key={0} value={1} value null", rs_si, sr_di );
                    if( isLogFiner ){
                        StringWriter sw = new StringWriter();
                        dump( new Output(sw,true) );
                        logWarning("dump:\n{0}", sw.toString());
                    }
                    res = false;
                    return false;
                }
                
                if( !eq(sr_di, rs_di) ){
                    logWarning("src2rowMap key={0} value={1} reverse fail ( rs d{2} -> s{3} sr s{0} -> d{4}  )",
                        rs_si, sr_di,
                        rs_di, rs_si,
                        sr_di
                    );
                    if( isLogFiner ){
                        StringWriter sw = new StringWriter();
                        dump( new Output(sw,true) );
                        logWarning("dump:\n{0}", sw.toString());
                    }
                    res = false;
                    return false;
                }
            }
            
            res = true;
            return true;
            //</editor-fold>
        }
        finally {
            long ms1 = System.currentTimeMillis();
            long ns1 = System.nanoTime();
            
            logFine( "isIndexesValid() r2s.size={0} s2r.size={1} end res={4} t.ms={2} t.ns={3}", 
                row2srcMap==null ? null : row2srcMap.size(),
                src2rowMap==null ? null : src2rowMap.size(),
                ms1 - ms0, ns1 - ns0,
                res
            );
        }
    }
    
    /**
     * Счетчик вызовов onRowInserted
     */
    private int onRowInsertedCallCount = 0;
    
    @Override
    protected synchronized List<TableModelEvent> onRowInserted(TableModelEvent e, int firstRow,int lastRow){
        logFine("onRowInserted({0},{1})", firstRow, lastRow);
        
        onRowInsertedCallCount++;
        
        if( tableModel==null )return deletageTMEvent(e);
        if( lastRow<firstRow )return deletageTMEvent(e);

        shiftOnInsertIndexes(firstRow, lastRow);
        
        if( row2srcMap==null )return deletageTMEvent(e);
        
        LinkedHashSet<Integer> inserted = new LinkedHashSet<>();
        
        int icnt = firstRow - lastRow + 1;
        if( icnt>0 ){
            for( int si=firstRow; si<=lastRow; si++ ){
                try{
                    rowData.setRowIndex(si);
                    if( rowFilter==null || rowFilter.validate(rowData) ){
                        int lkey = row2srcMap.lastKey();
                        int nkey = lkey+1;
                        row2srcMap.put(nkey, si);
                        src2rowMap.put(si, nkey);
                        inserted.add(nkey);
                        logFiner("onRowInserted({0},{1}) - add d({2})->s({3})", firstRow, lastRow, nkey, si);
                    }
                }catch( java.util.NoSuchElementException ex ){
                    applyFilter(true);
                    return null;
                }
            }
        }
        
        int neach = getValidateIndexOnInsertEach();
        if( neach>0 ){
            if( neach==1 ){
                if( !isIndexesValid() ){
                    applyFilter(true);
                    return null;
                }
            }else if( onRowInsertedCallCount % neach == 0 ){
                if( !isIndexesValid() ){
                    applyFilter(true);
                    return null;
                }
            }
        }
        
        //inserted.forEach( idx -> fireRowsInserted(idx, idx) );
        for( Integer idx : inserted ){
            fireRowsInserted(idx, idx);
        }
        
        return null;
    }
    
    public synchronized void dump(){        
        Output out = new Output(System.out);
        dump(out);
    }
    
    public synchronized void dump(Output xout){
        if( xout==null )xout = new Output(System.out);
        Output out = xout;
        out.setLinePrefix("dump|");
        
        if( row2srcMap!=null && src2rowMap!=null ){
            out.template("row2srcMap(${rsc}) src2rowMap(${src})")
                .bind("rsc", row2srcMap.size())
                .bind("src", src2rowMap.size())
                .println();
            
            for( Map.Entry<Integer,Integer> enR2S : row2srcMap.entrySet() ){
                Integer di1 = enR2S.getKey();
                Integer si1 = enR2S.getValue();
            //row2srcMap.forEach( (di1,si1) -> {
                Integer si2 = src2rowMap.containsKey(si1) ? si1 : null;
                Integer di2 = si2!=null ? src2rowMap.get(si2) : null;
                out.template("d${di1:3} -> s${si1:3} | d${di2:3} <- s${si2:3} | ${ok}")
                    .bind("di1", di1)
                    .bind("di2", di2)
                    .bind("si1", si1)
                    .bind("si2", si2)
                    .bind("ok", si2!=null && di2!=null && 
                                si1!=null && di1!=null && 
                                Objects.equals(si1, si2) && Objects.equals(di1, di2) )
                    .println();
            }//);
        }else{
            out.println("row2srcMap = "+row2srcMap);
            out.println("src2rowMap = "+src2rowMap);
        }
        
        out.flush();
    }
    
    public synchronized List<TableModelEvent> processRowUpdated( int firstRow, int lastRow ){
        List<TableModelEvent> evs = new LinkedList<>();

        if( tableModel==null )return null;
        if( lastRow<firstRow) return null;
        
        //if( isLogFinest() )dump();
        
        checkDestIndexesFast();

        // Список src который надо включить
        TreeSet<Integer> incList = new TreeSet<>();
        
        // Список src который надо исключить
        TreeSet<Integer> decList = new TreeSet<>();
        
        // Список src который надо обновить
        TreeSet<Integer> updList = new TreeSet<>();
        
        if( rowFilter!=null && src2rowMap!=null && row2srcMap!=null ){
            for( int srcRi = firstRow; srcRi<=lastRow; srcRi++ ){
                rowData.setRowIndex(srcRi);
                boolean inc = rowFilter.validate(rowData);
                if( inc ){
                    if( !src2rowMap.containsKey(srcRi) ){
                        incList.add( srcRi );
                    }else{
                        updList.add(srcRi);
                    }
                }else{
                    if( src2rowMap.containsKey(srcRi) ){
                        decList.add( srcRi );
                    }
                }
            }
        }else{
            TableModelEvent e = new TableModelEvent(
                this, firstRow, lastRow, TableModelEvent.ALL_COLUMNS, TableModelEvent.UPDATE);
            
            evs.add(e);
            return evs;
        }

        if( src2rowMap!=null && row2srcMap!=null ){
            
            // Обработка списка update
            for( Integer srcRi : updList ){
                Integer destRi = src2rowMap.get(srcRi);
                if( destRi!=null ){
                    logFiner("processRowUpdated({0},{1}) - fire row updated {2}", firstRow, lastRow, destRi);
                    
                    TableModelEvent e = new TableModelEvent(
                        this, destRi, destRi, TableModelEvent.ALL_COLUMNS, TableModelEvent.UPDATE);
                    
                    //fireRowUpdated(destRi);
                    evs.add(e);
                }
            }
            
            // delete keys
            for( Integer si : decList.descendingSet() ){
            //decList.descendingSet().forEach(si -> {
                Integer di = src2rowMap.get(si);
                if( !row2srcMap.containsKey(di) ){
                    throw new Error("row2srcMap.containsKey("+di+")=false and src2rowMap("+si+")="+di);
                }
                //row2srcMap.remove(di);
                LinkedHashSet<Integer> removeDi = new LinkedHashSet<>();
                for( Map.Entry<Integer,Integer> m : src2rowMap.entrySet() ){
                    if( Objects.equals(m.getValue(), di) ){
                        removeDi.add(di);
                    }
                }
                src2rowMap.remove(si);
                //removeDi.forEach( di__2 -> row2srcMap.remove(di__2) );
                for( Integer di__2 : removeDi ){ row2srcMap.remove(di__2); }
                
                logFinest("remove di={0} si={1}",di,si);
                
                logFiner("processRowUpdated({0},{1}) - fire row delete {2} -> {3}", firstRow, lastRow, di, si);
                
                //fireRowsDeleted(di, di);
                TableModelEvent e = new TableModelEvent(
                    this, di, di, TableModelEvent.ALL_COLUMNS, TableModelEvent.DELETE);
                evs.add(e);
            }// );
            
            // reindex row2srcMap
            AtomicInteger ni = new AtomicInteger(0);
            TreeMap<Integer,Integer> nrow2srcMap = new TreeMap<>();
            //row2srcMap.forEach( (di,si) -> {
            for( Map.Entry<Integer,Integer> enR2S : row2srcMap.entrySet() ){
                Integer di = enR2S.getKey();
                Integer si = enR2S.getValue();
                nrow2srcMap.put(ni.get(), si);
                ni.incrementAndGet();
            }//);
            row2srcMap = nrow2srcMap;
            
            src2rowMap.clear();
            //row2srcMap.forEach( (di,si)->{ src2rowMap.put(si,di); } );
            for( Map.Entry<Integer,Integer> enR2S : row2srcMap.entrySet() ){
                Integer di = enR2S.getKey();
                Integer si = enR2S.getValue();
                src2rowMap.put(si,di);
            }
            
            //if( isLogFinest() )dump();
            
            // insert keys
            //incList.forEach( si -> {
            for( Integer si : incList ) {
                int lkey = row2srcMap.lastKey();
                int di = lkey+1;
                row2srcMap.put(di, si);
                src2rowMap.put(si, di);
                //fireRowsInserted(di, di);
                logFiner("processRowUpdated({0},{1}) - fire row inserted {2} -> {3}", firstRow, lastRow, di, si);
                
                TableModelEvent e = new TableModelEvent(
                    this, di, di, TableModelEvent.ALL_COLUMNS, TableModelEvent.INSERT);
                evs.add(e);
            }// );
            
            return evs;
        }
        
        return null;
    }
    
    private int onRowUpdatedCallCount = 0;

    @Override
    protected synchronized List<TableModelEvent> onRowUpdated(TableModelEvent e, int firstRow,int lastRow){
        logFine("onRowUpdated({0},{1})", firstRow, lastRow);
        onRowUpdatedCallCount++;
        
        List<TableModelEvent> evs = processRowUpdated(firstRow, lastRow);
        if( evs==null ){
            int eachN = getValidateIndexOnUpdateEach();
            if( eachN>0 ){
                if( eachN==1 || (onRowUpdatedCallCount % eachN == 0) ){
                    if( !isIndexesValid() ){
                        applyFilter(true);
                        return null;
                    }
                }
            }
            
            return deletageTMEvent(e);
        }
        
        return evs;        
    }
    
    private int onRowDeletedCallCount = 0;

    @Override
    protected synchronized List<TableModelEvent> onRowDeleted(TableModelEvent e, int firstRow,int lastRow){
        logFine("onRowDeleted({0},{1})", firstRow, lastRow);
        onRowDeletedCallCount++;
        
        if( tableModel==null )return deletageTMEvent(e);
        if( lastRow<firstRow) return deletageTMEvent(e);

        final TreeSet<Integer> deleted = new TreeSet<>();

        //shiftOnDeleteIndexes(firstRow, lastRow, idx -> deleted.add(idx) );
        shiftOnDeleteIndexes(firstRow, lastRow, new Reciver<Integer>() {
            @Override
            public void recive(Integer idx) {
                deleted.add(idx);
            }
        } );

        int eachN = getValidateIndexOnDeleteEach();
        if( eachN>0 && (eachN==1 || (onRowDeletedCallCount % eachN == 0)) ){
            if( !isIndexesValid() ){
                applyFilter(true);
                return null;
            }
        }
        
        //deleted.descendingSet().forEach( idx -> fireRowsDeleted(idx, idx) );
        for( Integer idx : deleted.descendingSet() ){
            fireRowsDeleted(idx, idx);
        }
        
        return null;
    }

    @Override
    protected List<TableModelEvent> onTableChanged(TableModelEvent e){
        logFine("onTableChanged({0},{1})");
        applyFilter();
        return null;
    }    
}
