/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.gui.swing.text;


import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;

/**
 * Событие изменения текстового документа
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class DocumentChangeEvent 
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(DocumentChangeEvent.class.getName());

    private static Level logLevel(){ 
        return logger.getLevel() ;
    }
    
    private static boolean isLogSevere(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.SEVERE.intValue();
    }
    
    private static boolean isLogWarning(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.WARNING.intValue();
    }
    
    private static boolean isLogInfo(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.INFO.intValue();
    }
    
    private static boolean isLogFine(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.FINE.intValue();
    }
    
    private static boolean isLogFiner(){
        Level level = logLevel();
        return level==null 
        ? false
        : level.intValue() <= Level.FINER.intValue();
    }    
    
    private static boolean isLogFinest(){
        Level level = logLevel();
        return level==null 
        ? false
        : level.intValue() <= Level.FINEST.intValue();
    }    
    
    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    
    private static void logEntering(String method,Object ... params){
        logger.entering(DocumentChangeEvent.class.getName(),method,params);
    }

    private static void logExiting(String method,Object result){
        logger.exiting(DocumentChangeEvent.class.getName(),method,result);
    }

    private static void logExiting(String method){
        logger.exiting(DocumentChangeEvent.class.getName(),method);
    }
    //</editor-fold>
    
    /**
     * Конструктор
     */
    public DocumentChangeEvent(){
    }
    
    /**
     * Конструктор
     * @param doc документ
     * @param prev предыдущее значение
     * @param curr текущее значение
     */
    public DocumentChangeEvent(Document doc, String prev, String curr){
        this.doc = doc;
        this.previous = prev;
        this.current = curr;
    }
    
    //<editor-fold defaultstate="collapsed" desc="document">
    protected Document doc;
    
    /**
     * Возвращает ссылку на текстовый документа
     * @return текстовый документа
     */
    public Document getDocument()
    {
        return doc;
    }
    
    /**
     * Указывает ссылку на текстовый документ
     * @param doc текстовый документ
     */
    public void setDocument(Document doc)
    {
        this.doc = doc;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="previous">
    protected String previous;
    
    /**
     * Возвращает предыдущее значение
     * @return предыдущее значение
     */
    public String getPrevious()
    {
        return previous;
    }
    
    /**
     * Указывает предыдущее значение
     * @param previous предыдущее значение
     */
    public void setPrevious(String previous)
    {
        this.previous = previous;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="current">
    protected String current;
    
    /**
     * Возвращает текущее состояние
     * @return текущее состояние
     */
    public String getCurrent()
    {
        return current;
    }
    
    /**
     * Указывает текущее состояние
     * @param current текущее состояние
     */
    public void setCurrent(String current)
    {
        this.current = current;
    }
    //</editor-fold>
    
    /**
     * Событие добавления текста в документа
     */
    public static class InsertEvent
        extends DocumentChangeEvent
    {
        //<editor-fold defaultstate="collapsed" desc="offset">
        protected int offset;
        
        /**
         * Возвращает смещение от начала текста
         * @return смещение
         */
        public int getOffset()
        {
            return offset;
        }
        
        /**
         * Указывает смещение от начала текста
         * @param offset смещение
         */
        public void setOffset(int offset)
        {
            this.offset = offset;
        }
        //</editor-fold>
        
        //<editor-fold defaultstate="collapsed" desc="inserted">
        protected String inserted;
        
        /**
         * Возвращает вставленный текст
         * @return вставленный текст
         */
        public String getInserted()
        {
            return inserted;
        }
        
        /**
         * Указывает вставленный текст
         * @param inserted вставленный текст
         */
        public void setInserted(String inserted)
        {
            this.inserted = inserted;
        }
        //</editor-fold>
    }

    /**
     * Событие обновления текста в документе
     */
    public static class UpdateEvent
        extends DocumentChangeEvent
    {
        //<editor-fold defaultstate="collapsed" desc="offset">
        protected int offset;
        
        /**
         * Возвращает смещение от начала текста
         * @return смещение
         */
        public int getOffset()
        {
            return offset;
        }
        
        /**
         * Указывает смещение от начала текста
         * @param offset смещение
         */
        public void setOffset(int offset)
        {
            this.offset = offset;
        }
        //</editor-fold>
        
        //<editor-fold defaultstate="collapsed" desc="from">
        protected String from;
        
        /**
         * Возвращает удаленный текст
         * @return удаленный текст
         */
        public String getFrom()
        {
            return from;
        }
        
        /**
         * Указывает удаленный текст
         * @param from удаленный текст
         */
        public void setFrom(String from)
        {
            this.from = from;
        }
        //</editor-fold>
        
        //<editor-fold defaultstate="collapsed" desc="to">
        protected String to;
        
        /**
         * Возвращает добавленный текст
         * @return добавленный текст
         */
        public String getTo()
        {
            return to;
        }
        
        /**
         * Указывает добавленный текст
         * @param to добавленный текст
         */
        public void setTo(String to)
        {
            this.to = to;
        }
        //</editor-fold>
    }

    /**
     * Событие удаление текста из документа
     */
    public static class DeleteEvent
        extends DocumentChangeEvent
    {
        //<editor-fold defaultstate="collapsed" desc="offset">
        protected int offset;
        
        /**
         * Указывает смещение от начала текста
         * @return смещение
         */
        public int getOffset()
        {
            return offset;
        }
        
        /**
         * Указывает смещение от начала текста
         * @param offset смещение
         */
        public void setOffset(int offset)
        {
            this.offset = offset;
        }
        //</editor-fold>
        
        //<editor-fold defaultstate="collapsed" desc="deleted">
        protected String deleted;
        
        /**
         * Возвращает удаленный текст
         * @return удаленный текст
         */
        public String getDeleted()
        {
            return deleted;
        }
        
        /**
         * Указывает удаленный текст
         * @param deleted удаленный текст
         */
        public void setDeleted(String deleted)
        {
            this.deleted = deleted;
        }
        //</editor-fold>
    }
}
