/*
 * The MIT License
 *
 * Copyright 2017 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.gui.swing.tree;

import javax.swing.table.TableModel;

/**
 * Модель дерева отображенное на таблицу
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public interface TreeTableModelInterface extends TableModel
{
    /**
     * Возвращает отображается ли корень дерева в таблице
     * @return true - корень дерева виден / false - корень скрыт, отображаются дочерние узлы дерева
     */
    boolean isRootVisible();
    
    /**
     * Указывает корень дерева
     * @return корень дерева
     */
    public TreeTableNode getRoot();
    
    /**
     * Указывает корень дерева
     * @param root корень дерева
     */
    public void setRoot(TreeTableNode root);
    
    /**
     * Возвращает узел для указанной строки
     * @param row строка
     * @return узел или null
     */
    public TreeTableNode getNodeOf( int row );
    
    /**
     * Возвращает номер строки для указанного узла
     * @param node узел
     * @return номер строки или -1
     */
    public int getRowOf( TreeTableNode node );
}
