/*
 * The MIT License
 *
 * Copyright 2017 Kamnev Georgiy <nt.gocha@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package xyz.cofe.gui.swing.tree;

import java.util.List;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeChildrenList;
import xyz.cofe.collection.tree.TreeNodeDeepOffset;
import xyz.cofe.collection.tree.TreeNodeGetNodePath;

/**
 * Узел дерева-таблицы (TreeTable)
 * @author user
 * @param <Node> Тип узла дерева
 */
public interface TreeTableNode<Node extends TreeTableNode>
    extends 
        TreeNode<Node>,
        TreeNodeDeepOffset<Node>,
        TreeNodeGetNodePath<Node>,
        TreeNodeChildrenList<Node>
{
    //<editor-fold defaultstate="collapsed" desc="data : Object">
    /**
     * Возвращает данные (для отображения) узла дерева
     * @return данные узла
     */
    public Object getData();
    
    /**
     * Указывает данные (для отображения) узла дерева
     * @param v данные узла
     */
    public void setData( Object v );
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="dataPath : List">
    /**
     * Возвращает путь состоящий из "данных" узлов
     * @return путь данных
     */
    public List<Object> getDataPath();
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="treeLevel : int">
    /**
     * Возвращает уровень вложенности узла в дереве
     * @return уровень узла в дереве
     */
    public int getTreeLevel();
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="expanded : boolean">
    /**
     * Возвращает узел развернут (отображаются дочерние узлы) или нет
     * @return true - узел развернут
     */
    public boolean isExpanded();
    
    /**
     * Указывает узел развернут (отображаются дочерние узлы) или нет
     * @param v - узел развернут
     */
    public void setExpanded( boolean v );
    
    /**
     * Разворачивает/раскрывает дочерние узлы
     */
    public void expand();
    
    /**
     * Сворачивает/скрывает дочерние узлы дерева
     */
    public void collapse();    
    //</editor-fold>
}
