/*
 * The MIT License
 *
 * Copyright 2017 Kamnev Georgiy <nt.gocha@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package xyz.cofe.gui.swing.tree;

import java.util.WeakHashMap;

/**
 * Функция для реализации TreeTableNode
 * @author nt.gocha@gmail.com
 */
public class TreeTableNodeDefs 
{
    //<editor-fold defaultstate="collapsed" desc="get/set data">
    protected static final WeakHashMap<TreeTableNode, Object>
        data = new WeakHashMap<TreeTableNode, Object>();
    
    public static Object getDataOf( TreeTableNode node ){
        synchronized( data ){
            if( node==null )return null;
            return data.get(node);
        }
    }
    
    public static Object setDataOf( TreeTableNode node, Object vdata ){
        synchronized( vdata ){
            if( node==null )return null;
            if( vdata==null ){
                return data.remove(node);
            }else{
                return data.put(node, vdata);
            }
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="get/set expanded">
    protected static final WeakHashMap<TreeTableNode, Boolean>
        expanded = new WeakHashMap<TreeTableNode, Boolean>();
    
    /**
     * Возвращает признак что данный узел уже распахнут
     * @param node узел
     * @return true/false/null
     */
    public static Boolean getExpandedOf( TreeTableNode node ){
        synchronized( expanded ){
            if( node==null )return null;
            return expanded.get(node);
        }
    }
    
    /**
     * Устанавливает признак что данный узел уже распахнут
     * @param node узел
     * @param vdata true/false/null
     * @return Предыдущее значение
     */
    public static Boolean setExpandedOf( TreeTableNode node, Boolean vdata ){
        synchronized( vdata ){
            if( node==null )return null;
            if( vdata==null ){
                return expanded.remove(node);
            }else{
                return expanded.put(node, vdata);
            }
        }
    }
    //</editor-fold>

//    protected static final WeakHashMap<TreeTableNode, Func1<String,TreeTableNode>>
//        dataText = new WeakHashMap<>();
//    
//    public static Func1<String,TreeTableNode> getDataTextFunOf( TreeTableNode node ){
//        synchronized( TreeTableNodeDefs.dataText ){
//            if( node==null )return null;
//            return TreeTableNodeDefs.dataText.get(node);
//        }
//    }
//    
//    public static Func1<String,TreeTableNode> setDataTexFuntOf( 
//        TreeTableNode node, 
//        Func1<String,TreeTableNode> dataText 
//    ){
//        synchronized( TreeTableNodeDefs.dataText ){
//            if( node==null )return null;
//            if( dataText==null ){
//                return TreeTableNodeDefs.dataText.remove(node);
//            }else{
//                return TreeTableNodeDefs.dataText.put(node, dataText);
//            }
//        }
//    }
}
