/*
 * The MIT License
 *
 * Copyright 2017 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package xyz.cofe.gui.swing.tree.impl;

import xyz.cofe.gui.swing.tree.TreeTableNodeExpander;

/**
 * Списифичные настройки поведения TreeTableNodeBasic
 * <p>
 * Системное свойство: <br>
 * xyz.cofe.gui.swing.tree.TreeTableNodeBasic.useExpanderThresholdTimeout = 500
 * <br>
 * Определяет время (мс) спустя которое TreeTableNodeBasic использует Expander
 * @author nt.gocha@gmail.com
 * @see TreeTableNodeExpander
 */
public class TreeTableNodeBasicImpl {
    //<editor-fold defaultstate="collapsed" desc="scn">
    private static long scn = 0;
    
    public static synchronized long getScn() {
        return scn;
    }
    
    protected static synchronized long nextScn(){
        scn++;
        return scn;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="useExpanderThresholdTimeout : int">
    private static final String KEY_PREFIX="xyz.cofe.gui.swing.tree.TreeTableNodeBasic.";
    private static final String USE_EXPANDER_THRESHOLD_TIMEOUT=KEY_PREFIX+"useExpanderThresholdTimeout";
    
    protected static Integer useExpanderThresholdTimeout;
    
    public synchronized static Integer getUseExpanderThresholdTimeout() {
        if( useExpanderThresholdTimeout!=null )return useExpanderThresholdTimeout;
        
        String val =
            System.getProperties().getProperty(
                USE_EXPANDER_THRESHOLD_TIMEOUT, "500");
        
        if( val==null || !val.matches("-?\\d+") ){
            useExpanderThresholdTimeout = 500;
        }else{
            useExpanderThresholdTimeout = Integer.parseInt(val);
        }
        
        return useExpanderThresholdTimeout;
    }
    public synchronized static void setUseExpanderThresholdTimeout(Integer useExpanderThresholdTimeout) {
        TreeTableNodeBasicImpl.useExpanderThresholdTimeout = useExpanderThresholdTimeout;
    }
    //</editor-fold>
}
