/*
 * The MIT License
 *
 * Copyright 2018 user.
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.gui.swing.tree.ob;

import java.awt.event.MouseEvent;
import javax.swing.Icon;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;

/**
 * Построение контекста для объекта
 * @author user
 * @param <T> тип объекта (контекст)
 */
public interface Context<T> {
    /**
     * Указывает функцию именования узла
     * @param nameFn функция именования
     * @return построение контекста (self ссылка)
     */
    Context<T> naming( Func1<String,T> nameFn );
    
    /**
     * Указывает иконку для типа объекта
     * @param ico иконка
     * @return построение контекста (self ссылка)
     */
    Context<T> icon( Icon ico );
    
    /**
     * Указывает иконку для типа объекта
     * @param iconFun функция получения иконки
     * @return построение контекста (self ссылка)
     */
    Context<T> icon( Func1<Icon,T> iconFun );
    
    /**
     * Указывает функцию "следования" узла и проверки возможности "следования"
     * @param followerFn функция "следования" узла
     * @param followable функция проверки возможности "следования" узла
     * @return построение контекста (self ссылка)
     * @param <A> тип извлекаемого дочернего элемента
     */
    <A> Context<T> follower( NodesExtracter<T,A> followerFn, Followable<T> followable );
    
    /**
     * Указывает функцию "следования" узла и проверки возможности "следования"
     * @param followerFn функция "следования" узла
     * @return построение контекста (self ссылка)
     * @param <A> тип извлекаемого дочернего элемента
     */
    <A> Context<T> follower( NodesExtracter<T,A> followerFn );
    
    /**
     * Указывает функцию форматириования
     * @param fmtfn функция
     * @return построение контекста (self ссылка)
     */
    Context<T> format( Func1<TreeTableNodeFormat,T> fmtfn );
    
    /**
     * Указание контекстного меню
     * @return создание к. меню
     */
    ContextMenu<T> menu();
    
    /**
     * Указание контекстного меню
     * @param matchSoft true - сравнение делается по instanceof, без перекрытия типов
     * @return создание к. меню
     */
    ContextMenu<T> menu(boolean matchSoft);
    
    /**
     * Добавляет обработчик на левый клик мыши
     * @param clickfn обработчик
     * @return построение контекста (self ссылка)
     */
    Context<T> leftClick( final Func3<Object,T,TreeTableNodeBasic,MouseEvent> clickfn );
    
    /**
     * Добавляет обработчик на левый двойной клик мыши
     * @param clickfn обработчик
     * @return построение контекста (self ссылка)
     */
    Context<T> leftDblClick( final Func3<Object,T,TreeTableNodeBasic,MouseEvent> clickfn );
    
    /**
     * Применяет настройки для указанного контекста
     * @return отмена изменений для данного контекста
     */
    AutoCloseable apply();
}
