/*
 * The MIT License
 *
 * Copyright 2018 user.
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.gui.swing.tree.ob;

import javax.swing.Icon;
import javax.swing.JMenuItem;
import xyz.cofe.collection.Func2;
import xyz.cofe.common.Reciver;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;

/**
 * Конструирование контекстного меню
 * @author nt.gocha@gmail.com
 * @param <T> Класс данных узла дерева, для которого создается контекст
 */
public interface ContextMenu<T> {
    /**
     * Указыает текст отображаемый в пункте меню
     * @param label текст
     * @return конструктор меню (self ссылка)
     */
    ContextMenu<T> label(String label);
    
    /**
     * Указыает иконку отображаемую в пункте меню
     * @param icon иконка
     * @return конструктор меню (self ссылка)
     */
    ContextMenu<T> icon(Icon icon);
    
    /**
     * Указыает функцию вызываемую при нажатие на пункт меню
     * @param callfn функция обработчик
     * @return конструктор меню (self ссылка)
     */
    ContextMenu<T> call(Reciver<T> callfn);
    
    /**
     * Указыает функцию вызываемую при нажатие на пункт меню
     * @param callfn функция обработчик
     * @return конструктор меню (self ссылка)
     */
    ContextMenu<T> call(final Func2<Object,TreeTableNodeBasic,T> callfn);
    
    /**
     * Добавляет пункт меню
     * @return конструктор контекста
     */
    Context<T> add();
    
    /**
     * Создает пункты меню для данного объекта
     * @param buildMenus функция вызваемая при создании контекстного меню
     * @return конструктор контекста
     */
    Context<T> items( Func2<Iterable<JMenuItem>,TreeTableNodeBasic,T> buildMenus );
}
