/*
 * The MIT License
 *
 * Copyright 2018 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.gui.swing.tree.ob;


import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.common.CloseableSet;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormat;
import xyz.cofe.gui.swing.tree.TreeTableNodeFormatBasic;

/**
 * Поддержка NamedCollection для ObjectBrowser
 * @author user
 */
public class NamedCollectionObPlugin implements ObjectBrowserPlugin
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(NamedCollectionObPlugin.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method,Object ... params){
        logger.entering(NamedCollectionObPlugin.class.getName(), method, params);
    }
    
    private static void logExiting(String method){
        logger.exiting(NamedCollectionObPlugin.class.getName(), method);
    }
    
    private static void logExiting(String method, Object result){
        logger.exiting(NamedCollectionObPlugin.class.getName(), method, result);
    }
    //</editor-fold>

    @Override
    public void register(final ObjectBrowser bob, CloseableSet cs) {
        if( bob==null )return;
        
        AutoCloseable cl =
        bob.
            context(NamedCollection.class).
            follower(namedCollectionExtract, namedCollectionFollowable).
            format(namedCollectionFormatter).
            menu(true).items(new Func2<Iterable<JMenuItem>, TreeTableNodeBasic, NamedCollection>() {
                @Override
                public Iterable<JMenuItem> apply(TreeTableNodeBasic n, NamedCollection nc) {
                    if( nc!=null )return nc.getContextMenu();
                    return null;
                }
            }).
            apply();
            
        if( cs!=null ){ cs.add(cl); }
    }
    
    //protected 
    
    protected final NodesExtracter<NamedCollection,Object> namedCollectionExtract =
        new NodesExtracter<NamedCollection,Object>(){
            @Override
            public Iterable extract(NamedCollection from) {
                if( from == null )return null;
                return from.extract(from);
            }
        };
        
    protected final Followable<NamedCollection> namedCollectionFollowable = new Followable<NamedCollection>() {
        @Override
        public boolean followable(NamedCollection node) {
            Object extrd = node.getExtracted();
            if( extrd instanceof Collection ){
                Collection coll = (Collection)extrd;
                return !coll.isEmpty();
            }
            
            return node.getNodesExtracter()!=null;
        }
    };
        
    protected final Func1<TreeTableNodeFormat,NamedCollection> namedCollectionFormatter
        = new Func1<TreeTableNodeFormat, NamedCollection>() {
            @Override
            public TreeTableNodeFormat apply(NamedCollection ncoll) {
                if( ncoll==null )return null;
                TreeTableNodeFormatBasic fmt = new TreeTableNodeFormatBasic();
                if( ncoll.getBold()!=null )fmt.setBold(ncoll.getBold());
                if( ncoll.getItalic()!=null )fmt.setItalic(ncoll.getItalic());
                if( ncoll.getIcon()!=null )fmt.getIcons().add(ncoll.getIcon());
                return fmt;
            }
        };
}
