/*
 * The MIT License
 *
 * Copyright 2018 georgiy.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package xyz.cofe.gui.swing.tree.ob;

import java.lang.ref.WeakReference;
import java.util.Objects;
import xyz.cofe.gui.swing.tree.CompareAndSetTreeTable;
import xyz.cofe.gui.swing.tree.SetTreeTable;
import xyz.cofe.gui.swing.tree.TreeTable;
import xyz.cofe.gui.swing.tree.TreeTableNodeBasic;

/**
 *
 * @author georgiy
 */
public class TreeRootNode extends TreeTableNodeBasic implements SetTreeTable, CompareAndSetTreeTable
{

    public TreeRootNode() {
    }

    public TreeRootNode(Object data) {
        super(data);
    }

    public TreeRootNode(TreeTableNodeBasic sample, boolean withChildren, boolean preferred) {
        super(sample, withChildren, preferred);
    }
    
    protected volatile WeakReference<TreeTable> treeTableRef;

    @Override
    public synchronized void setTreeTable(TreeTable tt) {
        treeTableRef = tt!=null ? new WeakReference<>( tt ) : null;
    }
    
    public synchronized TreeTable getTreeTable(){
        return treeTableRef!=null ? treeTableRef.get() : null;
    }

    @Override
    public synchronized boolean compareAndSetTreeTable(TreeTable value, TreeTable newValue) {
        TreeTable tt = getTreeTable();
        if( Objects.equals(value, tt) ){
            setTreeTable(newValue);
            return true;
        }
        return false;
    }
}
