/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.tree.BasicTreeNodeEvent;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodePopupEvent;

public class TreeNodeBulkInserted<Node extends TreeNode>
extends BasicTreeNodeEvent<Node>
implements TreeNodePopupEvent<Node> {
    private static final Logger logger = Logger.getLogger(TreeNodeBulkInserted.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final List<TreeNode<Node>> popupPath = new ArrayList<TreeNode<Node>>();
    protected TreeNode<Node> parent;
    protected List<TreeNode<Node>> items;
    protected Integer insertIndex;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(TreeNodeBulkInserted.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(TreeNodeBulkInserted.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(TreeNodeBulkInserted.class.getName(), method, result);
    }

    public TreeNodeBulkInserted(TreeNode<Node> source) {
        super(source);
    }

    public TreeNodeBulkInserted(TreeNode<Node> source, TreeNode<Node> parent, int insertIndex, List<TreeNode<Node>> insertedItems) {
        super(source);
        this.items = insertedItems;
        this.parent = parent;
        this.insertIndex = insertIndex;
    }

    public List<TreeNode<Node>> getPopupPath() {
        return this.popupPath;
    }

    public TreeNode<Node> getParent() {
        return this.parent;
    }

    public List<TreeNode<Node>> getItems() {
        return this.items;
    }

    public Integer getInsertIndex() {
        return this.insertIndex;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

