/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import xyz.cofe.collection.map.EventMapAdapter;
import xyz.cofe.collection.map.MapEvent;

public class AWTEventMapAdapter<Key, Value>
extends EventMapAdapter<Key, Value> {
    private static void logFine(String message, Object ... args) {
        Logger.getLogger(AWTEventMapAdapter.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(AWTEventMapAdapter.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(AWTEventMapAdapter.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(AWTEventMapAdapter.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(AWTEventMapAdapter.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(AWTEventMapAdapter.class.getName()).log(Level.SEVERE, null, ex);
    }

    public void eventMap(MapEvent<Key, Value> event) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.eventMap(event);
        } else {
            final MapEvent<Key, Value> e = event;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    AWTEventMapAdapter.super.eventMap(e);
                }
            };
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(AWTEventMapAdapter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(AWTEventMapAdapter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

