/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import xyz.cofe.common.Reciver;

public class AWTReciver<T>
implements Reciver<T> {
    protected Reciver<T> reciver = null;
    protected volatile boolean awtSync = true;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(AWTReciver.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(AWTReciver.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(AWTReciver.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(AWTReciver.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(AWTReciver.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(AWTReciver.class.getName()).log(Level.SEVERE, null, ex);
    }

    public AWTReciver() {
    }

    public AWTReciver(Reciver<T> r) {
        this.reciver = r;
    }

    public AWTReciver(Reciver<T> r, boolean awtSync) {
        this.reciver = r;
        this.awtSync = awtSync;
    }

    public synchronized Reciver<T> getReciver() {
        return this.reciver;
    }

    public synchronized void setReciver(Reciver<T> reciver) {
        this.reciver = reciver;
    }

    public synchronized boolean isAwtSync() {
        return this.awtSync;
    }

    public synchronized void setAwtSync(boolean awtSync) {
        this.awtSync = awtSync;
    }

    public synchronized void recive(T obj) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.reciver == null) {
                return;
            }
            this.reciver.recive(obj);
        } else {
            final Reciver<T> rc = this.reciver;
            final T o = obj;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    rc.recive(o);
                }
            };
            if (this.awtSync) {
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AWTReciver.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(AWTReciver.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }
}

