/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.set.BasicEventSet;
import xyz.cofe.collection.set.EventSet;
import xyz.cofe.gui.swing.GetTarget;
import xyz.cofe.gui.swing.Icon;
import xyz.cofe.gui.swing.KeyboardShortcut;

public class BasicAction
extends AbstractAction
implements GetTarget {
    private static final Logger logger = Logger.getLogger(BasicAction.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    public static final int SELECTED_PROPERTY = 1;
    public static final String SELECTED_PROP = "selected";
    public static final int NAME_PROPERTY = 2;
    public static final String NAME_PROP = "name";
    public static final int SMALLICON_PROPERTY = 4;
    public static final String SMALL_ICON_PROP = "smallIcon";
    public static final int LARGEICON_PROPERTY = 8;
    public static final String LARGE_ICON_PROP = "largeIcon";
    public static final int ACCELERATOR_PROPERTY = 16;
    public static final String ACCELERATOR_PROP = "accelerator";
    public static final int SHORTDESCRIPTION_PROPERTY = 32;
    public static final String SHORT_DESCRIPTION_PROP = "shortDescription";
    public static final int LONGDESCRIPTION_PROPERTY = 64;
    public static final String LONG_DESCRIPTION_PROP = "longDescription";
    public static final int DIPLAYMNEMONICINDEX_PROPERTY = 128;
    public static final String DISPLAY_MNEMONIC_INDEX_PROP = "displayedMnemonicIndex";
    public static final int ACTIONCOMMAND_PROPERTY = 256;
    public static final String ACTION_COMMAND_PROP = "actionCommand";
    public static final int MNEMONIC_PROPERTY = 512;
    public static final String MNEMONIC_PROP = "mnemonic";
    public static final int KEYBOARDSHORTCUTS_PROPERTY = 1024;
    private EventSet<KeyboardShortcut> _keyboardShortcuts = null;
    private Class target = null;
    public static final int TARGET_PROPERTY = 2048;
    public static final int ACTIONLISTENER_PROPERTY = 4096;
    public static final String ACTIONLISTENER_PROP = "actionListener";
    protected ActionListener actionListener;
    public static final int ALL = 8191;
    public static final int DEF = 3838;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public BasicAction() {
    }

    public BasicAction(String name) {
        if (name != null) {
            this.setName(name);
        }
    }

    public BasicAction(String name, ActionListener listener) {
        if (name != null) {
            this.setName(name);
        }
        if (listener != null) {
            this.setActionListener(this.actionListener);
        }
    }

    public BasicAction(String name, final Runnable listener) {
        if (name != null) {
            this.setName(name);
        }
        if (listener != null) {
            this.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    listener.run();
                }
            });
        }
    }

    public BasicAction(Action action) {
        this(action, 3838);
    }

    public static void apply(Action act, Desc desc) {
        ImageIcon iicon;
        URL ico;
        KeyStroke ks;
        if (act == null) {
            throw new IllegalArgumentException("act==null");
        }
        if (desc == null) {
            throw new IllegalArgumentException("desc==null");
        }
        if (desc.keyStroke().length() > 0 && (ks = KeyStroke.getKeyStroke(desc.keyStroke())) != null) {
            act.putValue("AcceleratorKey", ks);
        }
        if (desc.name().length() > 0) {
            act.putValue("Name", desc.name());
        }
        if (desc.shortDesc().length() > 0) {
            act.putValue("ShortDescription", desc.shortDesc());
        }
        if (desc.longDesc().length() > 0) {
            act.putValue("LongDescription", desc.longDesc());
        }
        if (desc.smallIconResource().length() > 0 && (ico = act.getClass().getResource(desc.smallIconResource())) != null) {
            iicon = new ImageIcon(ico);
            act.putValue("SmallIcon", iicon);
        }
        if (desc.largeIconResource().length() > 0 && (ico = act.getClass().getResource(desc.largeIconResource())) != null) {
            iicon = new ImageIcon(ico);
            act.putValue("SwingLargeIconKey", iicon);
        }
    }

    public BasicAction(Action action, int copyProperties) {
        if (action != null) {
            Object select;
            Object mnK;
            Object acC;
            Object dmi;
            Object longDesc;
            Object shortDesc;
            Object acc;
            Object largeIco;
            Object smallIco;
            Object _name;
            if ((copyProperties & 2) == 2 && (_name = action.getValue("Name")) != null && _name instanceof String) {
                this.setName((String)_name);
            }
            if ((copyProperties & 4) == 4 && (smallIco = action.getValue("SmallIcon")) != null && smallIco instanceof javax.swing.Icon) {
                this.setSmallIcon((javax.swing.Icon)smallIco);
            }
            if ((copyProperties & 8) == 8 && (largeIco = action.getValue("SwingLargeIconKey")) != null && largeIco instanceof javax.swing.Icon) {
                this.setLargeIcon((javax.swing.Icon)largeIco);
            }
            if ((copyProperties & 0x10) == 16 && (acc = action.getValue("AcceleratorKey")) != null && acc instanceof KeyStroke) {
                this.setAccelerator((KeyStroke)acc);
            }
            if ((copyProperties & 0x20) == 32 && (shortDesc = action.getValue("ShortDescription")) != null && shortDesc instanceof String) {
                this.setShortDescription((String)shortDesc);
            }
            if ((copyProperties & 0x40) == 64 && (longDesc = action.getValue("LongDescription")) != null && longDesc instanceof String) {
                this.setLongDescription((String)longDesc);
            }
            if ((copyProperties & 0x80) == 128 && (dmi = action.getValue("SwingDisplayedMnemonicIndexKey")) != null && dmi instanceof Integer) {
                this.setDisplayedMnemonicIndex((Integer)dmi);
            }
            if ((copyProperties & 0x100) == 256 && (acC = action.getValue("ActionCommandKey")) != null && acC instanceof String) {
                this.setActionCommand((String)acC);
            }
            if ((copyProperties & 0x200) == 512 && (mnK = action.getValue("MnemonicKey")) != null && mnK instanceof Integer) {
                this.setMnemonic((Integer)mnK);
            }
            if ((copyProperties & 1) == 1 && (select = action.getValue("SwingSelectedKey")) != null && select instanceof Boolean) {
                this.setSelected((Boolean)select);
            }
            if ((copyProperties & 0x400) == 1024 && action instanceof BasicAction) {
                this.getKeyboardShortcuts().clear();
                for (KeyboardShortcut ksSrc : ((BasicAction)action).getKeyboardShortcuts()) {
                    KeyboardShortcut ks = new KeyboardShortcut(ksSrc);
                    this.getKeyboardShortcuts().add((Object)ks);
                }
            }
            if ((copyProperties & 0x800) == 2048 && action instanceof BasicAction) {
                this.setTarget(((BasicAction)action).getTarget());
            }
            if ((copyProperties & 0x1000) == 4096 && action instanceof BasicAction) {
                this.setActionListener(((BasicAction)action).getActionListener());
            }
        }
    }

    public boolean isSelected() {
        Boolean selected = (Boolean)super.getValue("SwingSelectedKey");
        if (selected == null) {
            return false;
        }
        return selected;
    }

    public void setSelected(boolean selected) {
        Boolean old = this.isSelected();
        this.putValue("SwingSelectedKey", selected);
        this.firePropertyChange(SELECTED_PROP, old, selected);
    }

    public String getName() {
        String text = (String)super.getValue("Name");
        return text;
    }

    public static String getName(Action act) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        return (String)act.getValue("Name");
    }

    public void setName(String text) {
        String old = this.getName();
        this.putValue("Name", text);
        this.firePropertyChange(NAME_PROP, old, text);
    }

    public static void setName(Action act, String name) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        act.putValue("Name", name);
    }

    public BasicAction name(String text) {
        this.setName(text);
        return this;
    }

    public javax.swing.Icon getSmallIcon() {
        Object o = this.getValue("SmallIcon");
        if (o != null && o instanceof javax.swing.Icon) {
            return (javax.swing.Icon)o;
        }
        return null;
    }

    public static javax.swing.Icon getSmallIcon(Action act) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        return (javax.swing.Icon)act.getValue("SmallIcon");
    }

    public void setSmallIcon(javax.swing.Icon newIcon) {
        javax.swing.Icon old = this.getSmallIcon();
        this.putValue("SmallIcon", newIcon);
        this.firePropertyChange(SMALL_ICON_PROP, old, newIcon);
    }

    public BasicAction smallIcon(javax.swing.Icon newIcon) {
        this.setSmallIcon(newIcon);
        return this;
    }

    public static void setSmallIcon(Action act, javax.swing.Icon newIcon) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        act.putValue("SmallIcon", newIcon);
    }

    public javax.swing.Icon getLargeIcon() {
        Object o = this.getValue("SwingLargeIconKey");
        if (o != null && o instanceof Icon) {
            return (Icon)o;
        }
        return null;
    }

    public static javax.swing.Icon getLargeIcon(Action act) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        return (javax.swing.Icon)act.getValue("SwingLargeIconKey");
    }

    public void setLargeIcon(javax.swing.Icon i) {
        javax.swing.Icon old = this.getLargeIcon();
        this.putValue("SwingLargeIconKey", i);
        this.firePropertyChange(LARGE_ICON_PROP, old, i);
    }

    public BasicAction largeIcon(javax.swing.Icon i) {
        this.setLargeIcon(i);
        return this;
    }

    public static void setLargeIcon(Action act, javax.swing.Icon newIcon) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        act.putValue("SwingLargeIconKey", newIcon);
    }

    public static KeyStroke getAccelerator(Action a) {
        if (a == null) {
            return null;
        }
        return (KeyStroke)a.getValue("AcceleratorKey");
    }

    public KeyStroke getAccelerator() {
        return BasicAction.getAccelerator(this);
    }

    public void setAccelerator(KeyStroke newAcceleratorKeyStroke) {
        KeyStroke old = this.getAccelerator();
        this.putValue("AcceleratorKey", newAcceleratorKeyStroke);
        this.firePropertyChange(ACCELERATOR_PROP, old, newAcceleratorKeyStroke);
    }

    public BasicAction accelerator(KeyStroke newAcceleratorKeyStroke) {
        this.setAccelerator(newAcceleratorKeyStroke);
        return this;
    }

    public static void setAccelerator(Action act, KeyStroke newAcceleratorKeyStroke) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        act.putValue("AcceleratorKey", newAcceleratorKeyStroke);
    }

    public AcceleratorBuilder accelerator() {
        return new AcceleratorBuilder();
    }

    public String getShortDescription() {
        Object o = this.getValue("ShortDescription");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public void setShortDescription(String text) {
        String old = this.getShortDescription();
        this.putValue("ShortDescription", text);
        this.firePropertyChange(SHORT_DESCRIPTION_PROP, old, text);
    }

    public BasicAction shortDescription(String text) {
        this.setShortDescription(text);
        return this;
    }

    public static String getShortDescription(Action act) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        return (String)act.getValue("ShortDescription");
    }

    public static void setShortDescription(Action act, String newValue) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        act.putValue("ShortDescription", newValue);
    }

    public String getLongDescription() {
        Object o = this.getValue("LongDescription");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public void setLongDescription(String text) {
        String old = this.getLongDescription();
        this.putValue("LongDescription", text);
        this.firePropertyChange(LONG_DESCRIPTION_PROP, old, text);
    }

    public BasicAction longDescription(String text) {
        this.setLongDescription(text);
        return this;
    }

    public static String getLongDescription(Action act) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        return (String)act.getValue("LongDescription");
    }

    public static void setLongDescription(Action act, String newValue) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        act.putValue("LongDescription", newValue);
    }

    public Integer getDisplayedMnemonicIndex() {
        Object v = this.getValue("SwingDisplayedMnemonicIndexKey");
        if (v != null && v instanceof Integer) {
            return (Integer)v;
        }
        return null;
    }

    public void setDisplayedMnemonicIndex(Integer index) {
        Integer old = this.getDisplayedMnemonicIndex();
        this.putValue("SwingDisplayedMnemonicIndexKey", index);
        this.firePropertyChange(DISPLAY_MNEMONIC_INDEX_PROP, old, index);
    }

    public BasicAction displayedMnemonicIndex(Integer index) {
        this.setDisplayedMnemonicIndex(index);
        return this;
    }

    public static Integer getDisplayedMnemonicIndex(Action act) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        return (Integer)act.getValue("SwingDisplayedMnemonicIndexKey");
    }

    public static void setDisplayedMnemonicIndex(Action act, Integer newValue) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        act.putValue("SwingDisplayedMnemonicIndexKey", newValue);
    }

    public String getActionCommand() {
        Object v = this.getValue("ActionCommandKey");
        if (v != null && v instanceof String) {
            return (String)v;
        }
        return null;
    }

    public void setActionCommand(String action) {
        String old = this.getActionCommand();
        this.putValue("ActionCommandKey", action);
        this.firePropertyChange(ACTION_COMMAND_PROP, old, action);
    }

    public BasicAction actionCommand(String action) {
        this.setActionCommand(action);
        return this;
    }

    public static String getActionCommand(Action act) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        return (String)act.getValue("ActionCommandKey");
    }

    public static void setActionCommand(Action act, String newValue) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        act.putValue("ActionCommandKey", newValue);
    }

    public Integer getMnemonic() {
        Object v = this.getValue("MnemonicKey");
        if (v != null && v instanceof Integer) {
            return (Integer)v;
        }
        return null;
    }

    public void setMnemonic(Integer mnemonic) {
        Integer old = this.getMnemonic();
        this.putValue("MnemonicKey", mnemonic);
        this.firePropertyChange(MNEMONIC_PROP, old, mnemonic);
    }

    public BasicAction mnemonic(Integer mnemonic) {
        this.setMnemonic(mnemonic);
        return this;
    }

    public static Integer getMnemonic(Action act) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        return (Integer)act.getValue("MnemonicKey");
    }

    public static void setMnemonic(Action act, Integer newValue) {
        if (act == null) {
            throw new IllegalArgumentException("act == null");
        }
        act.putValue("MnemonicKey", newValue);
    }

    public EventSet<KeyboardShortcut> getKeyboardShortcuts() {
        if (this._keyboardShortcuts != null) {
            return this._keyboardShortcuts;
        }
        this._keyboardShortcuts = new BasicEventSet(new HashSet());
        return this._keyboardShortcuts;
    }

    public BasicAction addShortcut(KeyboardShortcut ks) {
        if (ks != null) {
            this.getKeyboardShortcuts().add((Object)ks);
        }
        return this;
    }

    @Override
    public Class getTarget() {
        return this.target;
    }

    public void setTarget(Class target) {
        Class old = this.target;
        this.target = target;
        BasicAction.logFiner("setTarget():\n{0}", target);
        this.firePropertyChange("target", old, target);
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        ActionListener old = this.actionListener;
        this.actionListener = actionListener;
        this.firePropertyChange(ACTIONLISTENER_PROP, old, actionListener);
    }

    public BasicAction actionListener(ActionListener listener) {
        this.setActionListener(listener);
        return this;
    }

    public BasicAction actionListener(final Runnable listener) {
        if (listener != null) {
            this.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    listener.run();
                }
            });
        } else {
            this.setActionListener(null);
        }
        return this;
    }

    public void copyTo(Action action, int copyProperties) {
        if ((copyProperties & 2) == 2) {
            action.putValue("Name", this.getName());
        }
        if ((copyProperties & 4) == 4) {
            action.putValue("SmallIcon", this.getSmallIcon());
        }
        if ((copyProperties & 8) == 8) {
            action.putValue("SwingLargeIconKey", this.getLargeIcon());
        }
        if ((copyProperties & 0x10) == 16) {
            action.putValue("AcceleratorKey", this.getAccelerator());
        }
        if ((copyProperties & 0x20) == 32) {
            action.putValue("ShortDescription", this.getShortDescription());
        }
        if ((copyProperties & 0x40) == 64) {
            action.putValue("LongDescription", this.getLongDescription());
        }
        if ((copyProperties & 0x80) == 128) {
            action.putValue("SwingDisplayedMnemonicIndexKey", this.getDisplayedMnemonicIndex());
        }
        if ((copyProperties & 0x100) == 256) {
            action.putValue("ActionCommandKey", this.getActionCommand());
        }
        if ((copyProperties & 0x200) == 512) {
            action.putValue("MnemonicKey", this.getMnemonic());
        }
        if ((copyProperties & 1) == 1) {
            action.putValue("SwingSelectedKey", this.isSelected());
        }
        if ((copyProperties & 0x400) == 1024) {
            EventSet<KeyboardShortcut> itr = this.getKeyboardShortcuts();
            if (action instanceof BasicAction && itr != null) {
                ((BasicAction)action).getKeyboardShortcuts().clear();
                for (KeyboardShortcut ksSrc : itr) {
                    if (ksSrc == null) continue;
                    KeyboardShortcut ks = new KeyboardShortcut(ksSrc);
                    ((BasicAction)action).getKeyboardShortcuts().add((Object)ks);
                }
            }
        }
        if ((copyProperties & 0x800) == 2048 && action instanceof BasicAction) {
            ((BasicAction)action).setTarget(this.getTarget());
        }
    }

    @Override
    public void putValue(String key, Object newValue) {
        super.putValue(key, newValue);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActionListener al = this.actionListener;
        if (al != null) {
            al.actionPerformed(e);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class Filter {
        public static Predicate<Action> targetAssignableFrom(final Iterable<Class> classes) {
            return new Predicate<Action>(){

                public boolean validate(Action value) {
                    if (!(value instanceof GetTarget)) {
                        return false;
                    }
                    if (classes == null) {
                        return false;
                    }
                    Class target = ((GetTarget)((Object)value)).getTarget();
                    for (Class c : classes) {
                        if (c == null || !target.isAssignableFrom(c)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        public static Predicate<Action> targetAssignableFrom(final Class ... classes) {
            return new Predicate<Action>(){

                public boolean validate(Action value) {
                    if (!(value instanceof GetTarget)) {
                        return false;
                    }
                    if (classes == null) {
                        return false;
                    }
                    Class target = ((GetTarget)((Object)value)).getTarget();
                    if (target == null) {
                        return false;
                    }
                    for (Class c : classes) {
                        if (c == null || !target.isAssignableFrom(c)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    public class BasicAcceleratorBuilder
    extends AcceleratorBuilder {
        public BasicAction reset() {
            BasicAction.this.accelerator(null);
            return BasicAction.this;
        }

        public BasicAction set() {
            this.set(BasicAction.this);
            return BasicAction.this;
        }
    }

    public static class AcceleratorBuilder {
        protected Integer keyCode = null;
        protected Character keyChar = null;
        protected boolean shift = false;
        protected boolean ctrl = false;
        protected boolean meta = false;
        protected boolean alt = false;
        protected boolean altGraph = false;

        public Integer getKeyCode() {
            return this.keyCode;
        }

        public void setKeyCode(Integer keyCode) {
            this.keyCode = keyCode;
        }

        public AcceleratorBuilder code(int keycode) {
            this.keyCode = keycode;
            this.keyChar = null;
            return this;
        }

        public AcceleratorBuilder keyEnter() {
            return this.code(10);
        }

        public AcceleratorBuilder keyTab() {
            return this.code(9);
        }

        public AcceleratorBuilder keySpace() {
            return this.code(32);
        }

        public AcceleratorBuilder key0() {
            return this.code(48);
        }

        public AcceleratorBuilder key1() {
            return this.code(49);
        }

        public AcceleratorBuilder key2() {
            return this.code(50);
        }

        public AcceleratorBuilder key3() {
            return this.code(51);
        }

        public AcceleratorBuilder key4() {
            return this.code(52);
        }

        public AcceleratorBuilder key5() {
            return this.code(53);
        }

        public AcceleratorBuilder key6() {
            return this.code(54);
        }

        public AcceleratorBuilder key7() {
            return this.code(55);
        }

        public AcceleratorBuilder key8() {
            return this.code(56);
        }

        public AcceleratorBuilder key9() {
            return this.code(57);
        }

        public AcceleratorBuilder keyA() {
            return this.code(65);
        }

        public AcceleratorBuilder keyB() {
            return this.code(66);
        }

        public AcceleratorBuilder keyC() {
            return this.code(67);
        }

        public AcceleratorBuilder keyD() {
            return this.code(68);
        }

        public AcceleratorBuilder keyE() {
            return this.code(69);
        }

        public AcceleratorBuilder keyF() {
            return this.code(70);
        }

        public AcceleratorBuilder keyS() {
            return this.code(83);
        }

        public AcceleratorBuilder keyR() {
            return this.code(82);
        }

        public AcceleratorBuilder keyQ() {
            return this.code(81);
        }

        public AcceleratorBuilder keyP() {
            return this.code(80);
        }

        public AcceleratorBuilder keyO() {
            return this.code(79);
        }

        public AcceleratorBuilder keyN() {
            return this.code(78);
        }

        public AcceleratorBuilder keyM() {
            return this.code(77);
        }

        public AcceleratorBuilder keyL() {
            return this.code(76);
        }

        public AcceleratorBuilder keyK() {
            return this.code(75);
        }

        public AcceleratorBuilder keyI() {
            return this.code(73);
        }

        public AcceleratorBuilder keyJ() {
            return this.code(74);
        }

        public AcceleratorBuilder keyH() {
            return this.code(72);
        }

        public AcceleratorBuilder keyG() {
            return this.code(71);
        }

        public AcceleratorBuilder keyT() {
            return this.code(84);
        }

        public AcceleratorBuilder keyU() {
            return this.code(85);
        }

        public AcceleratorBuilder keyX() {
            return this.code(88);
        }

        public AcceleratorBuilder keyY() {
            return this.code(89);
        }

        public AcceleratorBuilder keyZ() {
            return this.code(90);
        }

        public AcceleratorBuilder keyF1() {
            return this.code(112);
        }

        public AcceleratorBuilder keyF2() {
            return this.code(113);
        }

        public AcceleratorBuilder keyF3() {
            return this.code(114);
        }

        public AcceleratorBuilder keyF4() {
            return this.code(115);
        }

        public AcceleratorBuilder keyF5() {
            return this.code(116);
        }

        public AcceleratorBuilder keyF6() {
            return this.code(117);
        }

        public AcceleratorBuilder keyF7() {
            return this.code(118);
        }

        public AcceleratorBuilder keyF8() {
            return this.code(119);
        }

        public AcceleratorBuilder keyF9() {
            return this.code(120);
        }

        public AcceleratorBuilder keyF10() {
            return this.code(121);
        }

        public AcceleratorBuilder keyF11() {
            return this.code(122);
        }

        public AcceleratorBuilder keyF12() {
            return this.code(123);
        }

        public AcceleratorBuilder keyF13() {
            return this.code(61440);
        }

        public AcceleratorBuilder keyF14() {
            return this.code(61441);
        }

        public AcceleratorBuilder keyF15() {
            return this.code(61442);
        }

        public AcceleratorBuilder keyF16() {
            return this.code(61443);
        }

        public AcceleratorBuilder keyF17() {
            return this.code(61444);
        }

        public AcceleratorBuilder keyF18() {
            return this.code(61445);
        }

        public AcceleratorBuilder keyF19() {
            return this.code(61446);
        }

        public AcceleratorBuilder keyF20() {
            return this.code(61447);
        }

        public AcceleratorBuilder keyF21() {
            return this.code(61448);
        }

        public AcceleratorBuilder keyF22() {
            return this.code(61449);
        }

        public AcceleratorBuilder keyF23() {
            return this.code(61450);
        }

        public AcceleratorBuilder keyF24() {
            return this.code(61451);
        }

        public AcceleratorBuilder keyWindows() {
            return this.code(524);
        }

        public AcceleratorBuilder keyUp() {
            return this.code(38);
        }

        public AcceleratorBuilder keyDown() {
            return this.code(40);
        }

        public AcceleratorBuilder keyLeft() {
            return this.code(37);
        }

        public AcceleratorBuilder keyRight() {
            return this.code(39);
        }

        public AcceleratorBuilder keyAdd() {
            return this.code(107);
        }

        public AcceleratorBuilder keyAgain() {
            return this.code(65481);
        }

        public AcceleratorBuilder keyAllCandidates() {
            return this.code(256);
        }

        public AcceleratorBuilder keyAlphanumeric() {
            return this.code(240);
        }

        public AcceleratorBuilder keyAmpersand() {
            return this.code(150);
        }

        public AcceleratorBuilder keyAsterisk() {
            return this.code(151);
        }

        public AcceleratorBuilder keyAt() {
            return this.code(512);
        }

        public AcceleratorBuilder keyBackQuote() {
            return this.code(192);
        }

        public AcceleratorBuilder keyBackSlash() {
            return this.code(92);
        }

        public AcceleratorBuilder keyBackSpace() {
            return this.code(8);
        }

        public AcceleratorBuilder keyBegin() {
            return this.code(65368);
        }

        public AcceleratorBuilder keyBraceleft() {
            return this.code(161);
        }

        public AcceleratorBuilder keyBraceright() {
            return this.code(162);
        }

        public AcceleratorBuilder keyCancel() {
            return this.code(3);
        }

        public AcceleratorBuilder keyCapsLock() {
            return this.code(20);
        }

        public AcceleratorBuilder keyCircumflex() {
            return this.code(514);
        }

        public AcceleratorBuilder keyClear() {
            return this.code(12);
        }

        public AcceleratorBuilder keyCloseBracket() {
            return this.code(93);
        }

        public AcceleratorBuilder keyCodeInput() {
            return this.code(258);
        }

        public AcceleratorBuilder keyColon() {
            return this.code(513);
        }

        public AcceleratorBuilder keyComma() {
            return this.code(44);
        }

        public AcceleratorBuilder keyCompose() {
            return this.code(65312);
        }

        public AcceleratorBuilder keyContextMenu() {
            return this.code(525);
        }

        public AcceleratorBuilder keyConvert() {
            return this.code(28);
        }

        public AcceleratorBuilder keyControl() {
            return this.code(17);
        }

        public AcceleratorBuilder keyCopy() {
            return this.code(65485);
        }

        public AcceleratorBuilder keyCut() {
            return this.code(65489);
        }

        public AcceleratorBuilder keyDelete() {
            return this.code(127);
        }

        public AcceleratorBuilder keyDollar() {
            return this.code(515);
        }

        public AcceleratorBuilder keyEnd() {
            return this.code(35);
        }

        public AcceleratorBuilder keyEscape() {
            return this.code(27);
        }

        public AcceleratorBuilder keyEquals() {
            return this.code(61);
        }

        public AcceleratorBuilder keyEuroSign() {
            return this.code(516);
        }

        public AcceleratorBuilder keyExclamationMark() {
            return this.code(517);
        }

        public AcceleratorBuilder keyFinal() {
            return this.code(24);
        }

        public AcceleratorBuilder keyFind() {
            return this.code(65488);
        }

        public AcceleratorBuilder keyFullWidth() {
            return this.code(243);
        }

        public AcceleratorBuilder keyGreater() {
            return this.code(160);
        }

        public AcceleratorBuilder keyHalfWidth() {
            return this.code(244);
        }

        public AcceleratorBuilder keyHelp() {
            return this.code(156);
        }

        public AcceleratorBuilder keyHiragana() {
            return this.code(242);
        }

        public AcceleratorBuilder keyHome() {
            return this.code(36);
        }

        public AcceleratorBuilder keyInsert() {
            return this.code(155);
        }

        public AcceleratorBuilder keyKpDown() {
            return this.code(225);
        }

        public AcceleratorBuilder keyKpLeft() {
            return this.code(226);
        }

        public AcceleratorBuilder keyKpRight() {
            return this.code(227);
        }

        public AcceleratorBuilder keyKpUp() {
            return this.code(224);
        }

        public AcceleratorBuilder keyLess() {
            return this.code(153);
        }

        public AcceleratorBuilder keyLeftParenthesis() {
            return this.code(519);
        }

        public AcceleratorBuilder keyMinus() {
            return this.code(45);
        }

        public AcceleratorBuilder keyMeta() {
            return this.code(157);
        }

        public AcceleratorBuilder keyModechange() {
            return this.code(31);
        }

        public AcceleratorBuilder keyNonconvert() {
            return this.code(29);
        }

        public AcceleratorBuilder keyPlus() {
            return this.code(521);
        }

        public AcceleratorBuilder keyNumLock() {
            return this.code(144);
        }

        public AcceleratorBuilder keyNumberSign() {
            return this.code(520);
        }

        public AcceleratorBuilder keyNumpad0() {
            return this.code(96);
        }

        public AcceleratorBuilder keyNumpad1() {
            return this.code(97);
        }

        public AcceleratorBuilder keyNumpad2() {
            return this.code(98);
        }

        public AcceleratorBuilder keyNumpad3() {
            return this.code(99);
        }

        public AcceleratorBuilder keyNumpad4() {
            return this.code(100);
        }

        public AcceleratorBuilder keyNumpad5() {
            return this.code(101);
        }

        public AcceleratorBuilder keyNumpad6() {
            return this.code(102);
        }

        public AcceleratorBuilder keyNumpad7() {
            return this.code(103);
        }

        public AcceleratorBuilder keyNumpad8() {
            return this.code(104);
        }

        public AcceleratorBuilder keyNumpad9() {
            return this.code(105);
        }

        public AcceleratorBuilder keyOpenBracket() {
            return this.code(91);
        }

        public AcceleratorBuilder keyPageDown() {
            return this.code(34);
        }

        public AcceleratorBuilder keyPageUp() {
            return this.code(33);
        }

        public AcceleratorBuilder keyPaste() {
            return this.code(65487);
        }

        public AcceleratorBuilder keyPause() {
            return this.code(19);
        }

        public AcceleratorBuilder keyPreviousCandidate() {
            return this.code(257);
        }

        public AcceleratorBuilder keyPrintscreen() {
            return this.code(154);
        }

        public AcceleratorBuilder keyProps() {
            return this.code(65482);
        }

        public AcceleratorBuilder keyQuote() {
            return this.code(222);
        }

        public AcceleratorBuilder keyQuotedbl() {
            return this.code(152);
        }

        public AcceleratorBuilder keyRightParenthesis() {
            return this.code(522);
        }

        public AcceleratorBuilder keyRomanCharacters() {
            return this.code(245);
        }

        public AcceleratorBuilder keyScrollLock() {
            return this.code(145);
        }

        public AcceleratorBuilder keySemicolon() {
            return this.code(59);
        }

        public AcceleratorBuilder keySeparater() {
            return this.code(108);
        }

        public AcceleratorBuilder keySeparator() {
            return this.code(108);
        }

        public AcceleratorBuilder keySlash() {
            return this.code(47);
        }

        public AcceleratorBuilder keyShift() {
            return this.code(16);
        }

        public AcceleratorBuilder keyStop() {
            return this.code(65480);
        }

        public AcceleratorBuilder keySubstract() {
            return this.code(109);
        }

        public AcceleratorBuilder keyUndefined() {
            return this.code(0);
        }

        public AcceleratorBuilder keyUnderscope() {
            return this.code(523);
        }

        public AcceleratorBuilder keyUndo() {
            return this.code(65483);
        }

        public Character getKeyChar() {
            return this.keyChar;
        }

        public void setKeyChar(Character keyChar) {
            this.keyChar = keyChar;
        }

        public AcceleratorBuilder chr(char ch) {
            this.keyCode = null;
            this.keyChar = Character.valueOf(ch);
            return this;
        }

        public boolean isShift() {
            return this.shift;
        }

        public void setShift(boolean shift) {
            this.shift = shift;
        }

        public AcceleratorBuilder shift(boolean shift) {
            this.setShift(shift);
            return this;
        }

        public boolean isCtrl() {
            return this.ctrl;
        }

        public void setCtrl(boolean ctrl) {
            this.ctrl = ctrl;
        }

        public AcceleratorBuilder ctrl(boolean ctrl) {
            this.setCtrl(ctrl);
            return this;
        }

        public boolean isMeta() {
            return this.meta;
        }

        public void setMeta(boolean meta) {
            this.meta = meta;
        }

        public AcceleratorBuilder meta(boolean meta) {
            this.setMeta(meta);
            return this;
        }

        public boolean isAlt() {
            return this.alt;
        }

        public void setAlt(boolean alt) {
            this.alt = alt;
        }

        public AcceleratorBuilder alt(boolean alt) {
            this.setAlt(alt);
            return this;
        }

        public boolean isAltGraph() {
            return this.altGraph;
        }

        public void setAltGraph(boolean altGraph) {
            this.altGraph = altGraph;
        }

        public AcceleratorBuilder altGraph(boolean altg) {
            this.setAltGraph(altg);
            return this;
        }

        public AcceleratorBuilder modifiers(boolean alt, boolean ctrl, boolean shift) {
            this.setAlt(alt);
            this.setCtrl(ctrl);
            this.setShift(shift);
            return this;
        }

        public void reset(Action act) {
            if (act == null) {
                throw new IllegalArgumentException("act==null");
            }
            if (act instanceof BasicAction) {
                ((BasicAction)act).setAccelerator(null);
            } else {
                BasicAction.setAccelerator(act, null);
            }
        }

        public KeyStroke keyStroke() {
            if (this.keyChar == null && this.keyCode == null) {
                return null;
            }
            if (this.keyChar != null && this.keyCode != null) {
                return null;
            }
            int mod = 0;
            if (this.shift) {
                mod |= 0x40;
            }
            if (this.ctrl) {
                mod |= 0x80;
            }
            if (this.meta) {
                mod |= 0x100;
            }
            if (this.alt) {
                mod |= 0x200;
            }
            if (this.altGraph) {
                mod |= 0x2000;
            }
            if (this.keyChar != null) {
                KeyStroke ks = KeyStroke.getKeyStroke(this.keyChar, mod);
                return ks;
            }
            if (this.keyCode != null) {
                KeyStroke ks = KeyStroke.getKeyStroke(this.keyCode, mod);
                return ks;
            }
            return null;
        }

        public void set(Action act) {
            if (act == null) {
                throw new IllegalArgumentException("act==null");
            }
            if (this.keyChar == null && this.keyCode == null) {
                this.reset(act);
                return;
            }
            if (this.keyChar != null && this.keyCode != null) {
                this.reset(act);
                return;
            }
            int mod = 0;
            if (this.shift) {
                mod |= 0x40;
            }
            if (this.ctrl) {
                mod |= 0x80;
            }
            if (this.meta) {
                mod |= 0x100;
            }
            if (this.alt) {
                mod |= 0x200;
            }
            if (this.altGraph) {
                mod |= 0x2000;
            }
            if (this.keyChar != null) {
                KeyStroke ks = KeyStroke.getKeyStroke(this.keyChar, mod);
                if (act instanceof BasicAction) {
                    ((BasicAction)act).setAccelerator(ks);
                } else {
                    BasicAction.setAccelerator(act, ks);
                }
                return;
            }
            if (this.keyCode != null) {
                KeyStroke ks = KeyStroke.getKeyStroke(this.keyCode, mod);
                if (act instanceof BasicAction) {
                    ((BasicAction)act).setAccelerator(ks);
                } else {
                    BasicAction.setAccelerator(act, ks);
                }
                return;
            }
            this.reset(act);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Desc {
        public String id() default "";

        public String name() default "";

        public String shortDesc() default "";

        public String longDesc() default "";

        public String keyStroke() default "";

        public String smallIconResource() default "";

        public String largeIconResource() default "";
    }
}

