/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import xyz.cofe.collection.BasicPair;
import xyz.cofe.collection.Pair;

public class FocusFinder {
    private static void logFine(String message, Object ... args) {
        Logger.getLogger(FocusFinder.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(FocusFinder.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(FocusFinder.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(FocusFinder.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(FocusFinder.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(FocusFinder.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(FocusFinder.class.getName()).log(Level.SEVERE, null, ex);
    }

    public static Object findThroughFocus(Class targetClass) {
        Component[] fOwnCmpts;
        if (targetClass == null) {
            return null;
        }
        KeyboardFocusManager kfm = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (kfm == null) {
            return null;
        }
        Component fown1 = kfm.getFocusOwner();
        Window fown2 = kfm.getFocusedWindow();
        Container fown3 = kfm.getCurrentFocusCycleRoot();
        Component fown4 = kfm.getPermanentFocusOwner();
        for (Component fown : fOwnCmpts = new Component[]{fown1, fown2, fown3, fown4}) {
            Pair<Boolean, Object> byFocus = FocusFinder.matchWindowClass(fown, targetClass);
            if (byFocus == null || byFocus.A() == null || !((Boolean)byFocus.A()).booleanValue()) continue;
            return byFocus.B();
        }
        return null;
    }

    public static Object findThroughMouse(Class targetClass) {
        if (targetClass == null) {
            return null;
        }
        Point location = MouseInfo.getPointerInfo().getLocation();
        Window[] windows = JFrame.getWindows();
        for (int wi = 0; wi < windows.length; ++wi) {
            Pair<Boolean, Object> byMouse;
            Window wnd = windows[wi];
            Point plocal = new Point(location);
            SwingUtilities.convertPointFromScreen(plocal, wnd);
            Component cw = wnd.getComponentAt(plocal);
            if (cw == null || !((Boolean)(byMouse = FocusFinder.matchWindowClass(cw, targetClass)).A()).booleanValue()) continue;
            return byMouse.B();
        }
        return null;
    }

    public static Pair<Boolean, Object> matchWindowClass(Component cmpt, Class targetClass) {
        List l;
        if (cmpt == null) {
            return new BasicPair((Object)false, null);
        }
        Class<?> ccls = cmpt.getClass();
        boolean asgn = targetClass.isAssignableFrom(ccls);
        boolean asgn2 = ccls.isAssignableFrom(targetClass);
        if (asgn) {
            return new BasicPair((Object)true, (Object)cmpt);
        }
        if (cmpt instanceof FindSelected && (l = ((FindSelected)((Object)cmpt)).findSelected(targetClass)) != null && !l.isEmpty()) {
            return new BasicPair((Object)true, l);
        }
        return FocusFinder.matchWindowClass(cmpt.getParent(), targetClass);
    }

    public static interface FindSelected {
        public <T> List<? extends T> findSelected(Class<T> var1);
    }
}

