/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GraphicsState {
    protected boolean clipSaved = false;
    protected Shape clip = null;
    protected AffineTransform transform = null;
    protected boolean transformSaved = false;
    protected Stroke stroke = null;
    protected boolean strokeSaved = false;
    protected Paint paint = null;
    protected boolean paintSaved = false;
    protected Font font = null;
    protected boolean fontSaved = false;
    protected Color color = null;
    protected boolean colorSaved = false;
    protected Color background = null;
    protected boolean backgroundSaved = false;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(GraphicsState.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(GraphicsState.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(GraphicsState.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(GraphicsState.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(GraphicsState.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(GraphicsState.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(GraphicsState.class.getName()).log(Level.SEVERE, null, ex);
    }

    public static GraphicsState backup(Graphics gs) {
        if (gs == null) {
            throw new IllegalArgumentException("gs==null");
        }
        GraphicsState state = new GraphicsState();
        state.clip = gs.getClip();
        state.clipSaved = true;
        state.font = gs.getFont();
        state.fontSaved = true;
        state.color = gs.getColor();
        state.colorSaved = true;
        if (gs instanceof Graphics2D) {
            Graphics2D gs2 = (Graphics2D)gs;
            Object trClone = gs2.getTransform().clone();
            if (trClone instanceof AffineTransform) {
                state.transform = (AffineTransform)trClone;
                state.transformSaved = true;
            }
            state.stroke = gs2.getStroke();
            state.strokeSaved = true;
            state.paint = gs2.getPaint();
            state.paintSaved = true;
            state.background = gs2.getBackground();
            state.backgroundSaved = true;
        }
        return state;
    }

    public void restore(Graphics gs) {
        if (gs == null) {
            throw new IllegalArgumentException("gs==null");
        }
        if (this.fontSaved) {
            gs.setFont(this.font);
        }
        if (this.colorSaved) {
            gs.setColor(this.color);
        }
        if (gs instanceof Graphics2D) {
            Graphics2D gs2 = (Graphics2D)gs;
            if (this.transformSaved) {
                gs2.setTransform(this.transform);
            }
            if (this.strokeSaved) {
                gs2.setStroke(this.stroke);
            }
            if (this.paintSaved) {
                gs2.setPaint(this.paint);
            }
            if (this.backgroundSaved) {
                gs2.setBackground(this.background);
            }
        }
        if (this.clipSaved) {
            gs.setClip(this.clip);
        }
    }
}

