/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.iterators.TreeWalk;
import xyz.cofe.collection.iterators.TreeWalkItreator;
import xyz.cofe.common.Reciver;

public class GuiUtil {
    private static Iterable<Component> emptyComponents = Iterators.empty();
    public static NodesExtracter<Component, Component> childComponentExtracter = new NodesExtracter<Component, Component>(){

        public Iterable<Component> extract(Component from) {
            if (from == null) {
                return emptyComponents;
            }
            if (from instanceof Container) {
                Container cont = (Container)from;
                Object[] childrenArray = cont.getComponents();
                Iterable childrenIters = Iterators.array((Object[])childrenArray);
                return childrenIters;
            }
            return emptyComponents;
        }
    };

    public static JFrame getJFrameOfComponent(Component cmpnt) {
        Container cntr;
        if (cmpnt == null) {
            throw new IllegalArgumentException("cmpnt == null");
        }
        for (cntr = cmpnt.getParent(); cntr != null && !(cntr instanceof JFrame); cntr = cntr.getParent()) {
        }
        if (cntr instanceof JFrame) {
            return (JFrame)cntr;
        }
        return null;
    }

    public static Window getWindowOfComponent(Component cmpnt) {
        Container cntr;
        if (cmpnt == null) {
            throw new IllegalArgumentException("cmpnt == null");
        }
        for (cntr = cmpnt.getParent(); cntr != null && !(cntr instanceof Window); cntr = cntr.getParent()) {
        }
        if (cntr instanceof Window) {
            return (Window)cntr;
        }
        return null;
    }

    public static Frame getFrameOfComponent(Component cmpnt) {
        Container cntr;
        if (cmpnt == null) {
            throw new IllegalArgumentException("cmpnt == null");
        }
        for (cntr = cmpnt.getParent(); cntr != null && !(cntr instanceof Frame); cntr = cntr.getParent()) {
        }
        if (cntr instanceof Frame) {
            return (Frame)cntr;
        }
        return null;
    }

    public static Iterable<Component> walk(Component root) {
        if (root == null) {
            throw new IllegalArgumentException("root == null");
        }
        return Iterators.tree((Object)root, childComponentExtracter);
    }

    public static Iterable<TreeWalk<Component>> tree(Component root) {
        if (root == null) {
            throw new IllegalArgumentException("root==null");
        }
        return TreeWalkItreator.createIterable((Object)root, childComponentExtracter);
    }

    public static boolean isChildOrSelfOf(Component parent, Component child) {
        if (parent == null) {
            throw new IllegalArgumentException("parent == null");
        }
        if (child == null) {
            throw new IllegalArgumentException("child == null");
        }
        Iterable<Component> tree = GuiUtil.walk(parent);
        boolean in = Iterators.in((Object)child, tree);
        return in;
    }

    public static boolean setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            return true;
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(GuiUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GuiUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (InstantiationException ex) {
            Logger.getLogger(GuiUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(GuiUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        return info;
    }

    public static boolean setLookAndFeel(UIManager.LookAndFeelInfo lf) {
        try {
            UIManager.setLookAndFeel(lf.getClassName());
            return true;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GuiUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (InstantiationException ex) {
            Logger.getLogger(GuiUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(GuiUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(GuiUtil.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static void centerWindow(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("window == null");
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point p = ge.getCenterPoint();
        window.setLocation(p.x - window.getWidth() / 2, p.y - window.getHeight() / 2);
    }

    public static void setWindowDesktopSize(Window window, double sizeX, double sizeY) {
        if (window == null) {
            throw new IllegalArgumentException("window == null");
        }
        if (sizeX < 0.0 || sizeX > 1.0) {
            throw new IllegalArgumentException("size<0 | size>1");
        }
        if (sizeY < 0.0 || sizeY > 1.0) {
            throw new IllegalArgumentException("size<0 | size>1");
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int screenX = ge.getCenterPoint().x * 2;
        int screenY = ge.getCenterPoint().y * 2;
        window.setSize((int)((double)screenX * sizeX), (int)((double)screenY * sizeY));
    }

    public static WindowReciverBuilder windowReciver() {
        return new WindowReciverBuilder();
    }

    public static Rectangle getScreenRectangle() {
        DisplayMode dm;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        if (gd != null && (dm = gd.getDisplayMode()) != null) {
            return new Rectangle(dm.getWidth(), dm.getHeight());
        }
        Point p = ge.getCenterPoint();
        return new Rectangle(0, 0, p.x * 2, p.y * 2);
    }

    public static boolean match(KeyEvent ke, KeyStroke ... keyStrokes) {
        if (keyStrokes == null || ke == null) {
            return false;
        }
        for (KeyStroke ks : keyStrokes) {
            if (ks == null || ke.getID() != ks.getKeyEventType() || (ke.getID() != 400 ? ke.getKeyCode() != ks.getKeyCode() : ke.getKeyChar() != ks.getKeyChar())) continue;
            int mod = ks.getModifiers();
            boolean shift = (0x40 & mod) != 0;
            boolean ctrl = (0x80 & mod) != 0;
            boolean meta = (0x100 & mod) != 0;
            boolean alt = (0x200 & mod) != 0;
            boolean altGraph = (0x2000 & mod) != 0;
            boolean altMatched = Objects.equals(ke.isAltDown(), alt);
            boolean altGrMatched = Objects.equals(ke.isAltGraphDown(), altGraph);
            boolean metaMatched = Objects.equals(ke.isMetaDown(), meta);
            boolean ctrlMatched = Objects.equals(ke.isControlDown(), ctrl);
            boolean shftMatched = Objects.equals(ke.isShiftDown(), shift);
            if (!altMatched || !altGrMatched || !metaMatched || !ctrlMatched || !shftMatched) continue;
            return true;
        }
        return false;
    }

    public static class WindowReciverBuilder {
        protected List<Reciver<Window>> actions = new ArrayList<Reciver<Window>>();

        public WindowReciverBuilder center() {
            Reciver<Window> rw = new Reciver<Window>(){

                public void recive(Window wnd) {
                    if (wnd == null) {
                        return;
                    }
                    GuiUtil.centerWindow(wnd);
                }
            };
            this.actions.add(rw);
            return this;
        }

        public WindowReciverBuilder minSize(final int w, final int h) {
            Reciver<Window> rw = new Reciver<Window>(){

                public void recive(Window wnd) {
                    if (wnd == null) {
                        return;
                    }
                    int cw = wnd.getWidth();
                    int ch = wnd.getHeight();
                    if (cw < w || ch < h) {
                        int tw = Math.max(cw, w);
                        int th = Math.max(ch, h);
                        wnd.setSize(tw, th);
                    }
                }
            };
            this.actions.add(rw);
            return this;
        }

        public WindowReciverBuilder relativeSize(final double w, final double h) {
            Reciver<Window> rw = new Reciver<Window>(){

                public Rectangle desktopRect() {
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice gd = ge.getDefaultScreenDevice();
                    return ge.getMaximumWindowBounds();
                }

                public void recive(Window wnd) {
                    if (wnd == null) {
                        return;
                    }
                    if (w > 0.0 && h > 0.0) {
                        Rectangle r = this.desktopRect();
                        wnd.setSize((int)(w * r.getWidth()), (int)(h * r.getHeight()));
                    }
                }
            };
            this.actions.add(rw);
            return this;
        }

        public WindowReciverBuilder size(final int w, final int h) {
            Reciver<Window> rw = new Reciver<Window>(){

                public void recive(Window wnd) {
                    if (wnd == null) {
                        return;
                    }
                    if (w > 0 && h > 0) {
                        wnd.setSize(w, h);
                    }
                }
            };
            this.actions.add(rw);
            return this;
        }

        public Position pos() {
            return new Position();
        }

        public Reciver<WindowEvent> build() {
            return new Reciver<WindowEvent>(){

                public void recive(WindowEvent we) {
                    if (we == null) {
                        return;
                    }
                    Window wnd = we.getWindow();
                    if (wnd == null) {
                        return;
                    }
                    if (WindowReciverBuilder.this.actions != null) {
                        for (Reciver<Window> rw : WindowReciverBuilder.this.actions) {
                            if (rw == null) continue;
                            rw.recive((Object)wnd);
                        }
                    }
                }
            };
        }

        public void apply(Window wnd) {
            if (wnd == null) {
                throw new IllegalArgumentException("wnd == null");
            }
            if (this.actions != null) {
                for (Reciver<Window> rw : this.actions) {
                    if (rw == null) continue;
                    rw.recive((Object)wnd);
                }
            }
        }

        public class Position {
            private Integer left;
            private Integer top;
            private Integer right;
            private Integer bottom;

            public Position left(int left) {
                this.left = left;
                return this;
            }

            public Position right(int right) {
                this.right = right;
                return this;
            }

            public Position top(int top) {
                this.top = top;
                return this;
            }

            public Position bottom(int bottom) {
                this.bottom = bottom;
                return this;
            }

            public WindowReciverBuilder set() {
                Reciver<Window> rw = new Reciver<Window>(){

                    public Rectangle desktopRect() {
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        GraphicsDevice gd = ge.getDefaultScreenDevice();
                        return ge.getMaximumWindowBounds();
                    }

                    public Rectangle screenRect() {
                        DisplayMode dm;
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        GraphicsDevice gd = ge.getDefaultScreenDevice();
                        if (gd != null && (dm = gd.getDisplayMode()) != null) {
                            return new Rectangle(dm.getWidth(), dm.getHeight());
                        }
                        Point p = ge.getCenterPoint();
                        return new Rectangle(0, 0, p.x * 2, p.y * 2);
                    }

                    private void setLeft(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yWnd);
                    }

                    private void setRight(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setBottom(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setTop(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setLeftTop(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                    }

                    private void setLeftRight(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setLeftBottom(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setRightTop(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setRightBottom(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setTopBottom(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setLeftRightTop(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setLeftTopBottom(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setLeftRightBottom(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setRightTopBottom(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    private void setLeftRightTopBottom(Window wnd, Rectangle container) {
                        CalcTargetPos ctp = new CalcTargetPos(wnd, container, Position.this);
                        wnd.setLocation(ctp.xTrgt, ctp.yTrgt);
                        wnd.setSize(ctp.wTrgt, ctp.hTrgt);
                    }

                    public void recive(Window wnd) {
                        if (wnd == null) {
                            return;
                        }
                        int wx = wnd.getX();
                        int wy = wnd.getY();
                        int wh = wnd.getHeight();
                        int ww = wnd.getWidth();
                        Rectangle bound = this.screenRect();
                        if (Position.this.left != null && Position.this.right != null && Position.this.top != null && Position.this.bottom != null) {
                            this.setLeftRightTopBottom(wnd, bound);
                        } else if (Position.this.left != null && Position.this.right != null && Position.this.top != null && Position.this.bottom == null) {
                            this.setLeftRightTop(wnd, bound);
                        } else if (Position.this.left != null && Position.this.right != null && Position.this.top == null && Position.this.bottom != null) {
                            this.setLeftRightBottom(wnd, bound);
                        } else if (Position.this.left != null && Position.this.right != null && Position.this.top == null && Position.this.bottom == null) {
                            this.setLeftRight(wnd, bound);
                        } else if (Position.this.left != null && Position.this.right == null && Position.this.top != null && Position.this.bottom != null) {
                            this.setLeftTopBottom(wnd, bound);
                        } else if (Position.this.left != null && Position.this.right == null && Position.this.top != null && Position.this.bottom == null) {
                            this.setLeftTop(wnd, bound);
                        } else if (Position.this.left != null && Position.this.right == null && Position.this.top == null && Position.this.bottom != null) {
                            this.setLeftBottom(wnd, bound);
                        } else if (Position.this.left != null && Position.this.right == null && Position.this.top == null && Position.this.bottom == null) {
                            this.setLeft(wnd, bound);
                        } else if (Position.this.left == null && Position.this.right != null && Position.this.top != null && Position.this.bottom != null) {
                            this.setRightTopBottom(wnd, bound);
                        } else if (Position.this.left == null && Position.this.right != null && Position.this.top != null && Position.this.bottom == null) {
                            this.setRightTop(wnd, bound);
                        } else if (Position.this.left == null && Position.this.right != null && Position.this.top == null && Position.this.bottom != null) {
                            this.setRightBottom(wnd, bound);
                        } else if (Position.this.left == null && Position.this.right != null && Position.this.top == null && Position.this.bottom == null) {
                            this.setRight(wnd, bound);
                        } else if (Position.this.left == null && Position.this.right == null && Position.this.top != null && Position.this.bottom != null) {
                            this.setTopBottom(wnd, bound);
                        } else if (Position.this.left == null && Position.this.right == null && Position.this.top != null && Position.this.bottom == null) {
                            this.setTop(wnd, bound);
                        } else if (Position.this.left == null && Position.this.right == null && Position.this.top == null && Position.this.bottom != null) {
                            this.setBottom(wnd, bound);
                        } else if (Position.this.left != null || Position.this.right != null || Position.this.top != null || Position.this.bottom == null) {
                            // empty if block
                        }
                    }
                };
                WindowReciverBuilder.this.actions.add(rw);
                return WindowReciverBuilder.this;
            }
        }

        public static class CalcTargetPos {
            public int xCont;
            public int yCont;
            public int xContRB;
            public int yContRB;
            public int xWnd;
            public int yWnd;
            public int xWndRB;
            public int yWndRB;
            public int wWnd;
            public int hWnd;
            public int xTrgt;
            public int yTrgt;
            public int wTrgt;
            public int hTrgt;
            public int xTrgtRB;
            public int yTrgtRB;

            public CalcTargetPos(Window wnd, Rectangle container, Position pos) {
                this.xCont = container.x;
                this.yCont = container.y;
                this.xContRB = container.x + container.width - 1;
                this.yContRB = container.y + container.height - 1;
                this.xWnd = wnd.getX();
                this.yWnd = wnd.getY();
                this.xWndRB = wnd.getX() + wnd.getWidth() - 1;
                this.yWndRB = wnd.getY() + wnd.getHeight() - 1;
                this.wWnd = wnd.getWidth();
                this.hWnd = wnd.getHeight();
                this.xCont += pos.left != null ? pos.left : 0;
                this.yCont += pos.top != null ? pos.top : 0;
                this.xContRB -= pos.right != null ? pos.right : 0;
                this.yContRB -= pos.bottom != null ? pos.bottom : 0;
                if (pos.left != null && pos.right != null) {
                    this.xTrgt = Math.min(this.xCont, this.xContRB);
                    this.wTrgt = Math.abs(this.xCont - this.xContRB);
                    this.xTrgtRB = this.xTrgt + this.wTrgt;
                } else if (pos.left != null) {
                    this.xTrgt = this.xCont;
                    this.wTrgt = this.wWnd;
                    this.xTrgtRB = this.xTrgt + this.wWnd;
                } else if (pos.right != null) {
                    this.xTrgt = this.xContRB - this.wWnd;
                    this.wTrgt = this.wWnd;
                    this.xTrgtRB = this.xTrgt + this.wWnd;
                } else {
                    this.xTrgt = this.xWnd;
                    this.xTrgtRB = this.xWndRB;
                    this.wTrgt = this.wWnd;
                }
                if (pos.top != null && pos.bottom != null) {
                    this.yTrgt = Math.min(this.yCont, this.yContRB);
                    this.hTrgt = Math.abs(this.yCont - this.yContRB);
                    this.yTrgtRB = this.yTrgt + this.hTrgt;
                } else if (pos.top != null) {
                    this.yTrgt = this.yCont;
                    this.hTrgt = this.hWnd;
                    this.yTrgtRB = this.yTrgt + this.hWnd;
                } else if (pos.bottom != null) {
                    this.yTrgt = this.yContRB - this.hWnd;
                    this.hTrgt = this.hWnd;
                    this.yTrgtRB = this.yTrgt + this.hWnd;
                } else {
                    this.yTrgt = this.yWnd;
                    this.yTrgtRB = this.yWndRB;
                    this.hTrgt = this.hWnd;
                }
            }
        }
    }
}

