/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;

public class Icon
implements javax.swing.Icon,
Serializable {
    protected javax.swing.Icon delegateIcon = null;
    protected Object iconSource = null;
    protected static BufferedImage emptyImage = null;

    public Icon(URL urlIcon) {
        if (urlIcon == null) {
            throw new IllegalArgumentException("urlIcon == null");
        }
        this.iconSource = urlIcon;
        this.delegateIcon = new ImageIcon(urlIcon);
    }

    public Icon(File fileIcon) {
        if (fileIcon == null) {
            throw new IllegalArgumentException("fileIcon == null");
        }
        this.iconSource = fileIcon;
        this.delegateIcon = !fileIcon.exists() || !fileIcon.canRead() || !fileIcon.isFile() ? new ImageIcon(this.getEmptyImage()) : new ImageIcon(fileIcon.getAbsolutePath());
    }

    public Object getIconSource() {
        return this.iconSource;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.delegateIcon.paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.delegateIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.delegateIcon.getIconHeight();
    }

    protected BufferedImage createEmtpry(int tw, int th) {
        int w = 100;
        int h = 100;
        int strokeW = 3;
        int indent = 3;
        String txt = "?";
        BufferedImage im = new BufferedImage(w, h, 5);
        Graphics2D gs = (Graphics2D)im.getGraphics();
        BasicStroke stroke = new BasicStroke(strokeW);
        gs.setPaint(Color.white);
        gs.setStroke(stroke);
        gs.fillRect(0, 0, w, h);
        Font fnt = new Font("SansSerif", 1, 10);
        FontMetrics fmtr = gs.getFontMetrics(fnt);
        gs.setColor(Color.black);
        gs.setFont(fnt);
        gs.drawString(txt, indent, fmtr.getHeight() + indent);
        Rectangle2D rect = fmtr.getStringBounds(txt, gs);
        gs.setColor(Color.red);
        gs.drawRect(0, 0, (int)rect.getWidth() + indent * 2, (int)rect.getHeight() + indent * 2);
        BufferedImage res = new BufferedImage(tw, th, 5);
        Graphics2D gs2 = (Graphics2D)res.getGraphics();
        gs2.drawImage(im, 0, 0, tw - 1, th - 1, 0, 0, (int)rect.getWidth() + indent * 2, (int)rect.getHeight() + indent * 2, null);
        return res;
    }

    protected BufferedImage getEmptyImage() {
        if (emptyImage != null) {
            return emptyImage;
        }
        emptyImage = this.createEmtpry(16, 16);
        return emptyImage;
    }
}

