/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;

public class KeyboardShortcut {
    private transient PropertyChangeSupport propertyChangeSupport = null;
    protected KeyStroke keyStroke = null;
    protected Class target = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(KeyboardShortcut.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(KeyboardShortcut.class.getName()).log(Level.FINER, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(KeyboardShortcut.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(KeyboardShortcut.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(KeyboardShortcut.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(KeyboardShortcut.class.getName()).log(Level.SEVERE, null, ex);
    }

    public KeyboardShortcut() {
    }

    public KeyboardShortcut(KeyboardShortcut ks) {
        if (ks == null) {
            return;
        }
        this.keyStroke = ks.keyStroke;
        this.target = ks.target;
    }

    protected PropertyChangeSupport propertySupport() {
        if (this.propertyChangeSupport != null) {
            return this.propertyChangeSupport;
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        return this.propertyChangeSupport;
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertySupport().firePropertyChange(property, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        KeyStroke old = this.keyStroke;
        this.keyStroke = keyStroke;
        this.firePropertyChange("keyStroke", old, keyStroke);
    }

    public Class getTarget() {
        return this.target;
    }

    public void setTarget(Class windowClass) {
        Class old = this.target;
        this.target = this.target;
        this.firePropertyChange("target", old, windowClass);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyboardShortcut other = (KeyboardShortcut)obj;
        if (!(this.keyStroke == other.keyStroke || this.keyStroke != null && this.keyStroke.equals(other.keyStroke))) {
            return false;
        }
        return this.target == other.target || this.target != null && this.target.equals(other.target);
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.keyStroke != null ? this.keyStroke.hashCode() : 0);
        hash = 23 * hash + (this.target != null ? this.target.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "KeyboardShortcut{keyStroke=" + this.keyStroke + ", target=" + this.target + '}';
    }
}

