/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Pair;

public class TextWriter {
    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TextWriter.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TextWriter.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TextWriter.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TextWriter.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TextWriter.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
    }

    public static Writer writer(JTextComponent component, Func0<AttributeSet> lazyStyle) {
        if (component == null) {
            throw new IllegalArgumentException("component==null");
        }
        return new TextWriter().create(component, lazyStyle);
    }

    public static Writer writer(JTextComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("component==null");
        }
        return new TextWriter().create(component, null);
    }

    public Writer create(final JTextComponent component, final Func0<AttributeSet> lazyStyle) {
        if (component == null) {
            throw new IllegalArgumentException("component==null");
        }
        Writer wr = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                String txt = new String(cbuf, off, len);
                TextWriter.write(component, txt, (Func0<AttributeSet>)lazyStyle);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        BufferedWriter bwr = new BufferedWriter(wr, 320){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void newLine() throws IOException {
                Object object = this.lock;
                synchronized (object) {
                    super.newLine();
                    super.flush();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(String s, int off, int len) throws IOException {
                Object object = this.lock;
                synchronized (object) {
                    super.write(s, off, len);
                    if (s != null && (s.contains("\n") || s.contains("\r"))) {
                        super.flush();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                Object object = this.lock;
                synchronized (object) {
                    super.write(cbuf, off, len);
                    if (cbuf != null) {
                        for (char c : cbuf) {
                            if (c != '\n' && c != '\r') continue;
                            super.flush();
                            return;
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int c) throws IOException {
                Object object = this.lock;
                synchronized (object) {
                    super.write(c);
                    if (c == 10 || c == 13) {
                        super.flush();
                        return;
                    }
                }
            }
        };
        return bwr;
    }

    public static void write(final JTextComponent out, final Func0<Iterable<Pair<String, AttributeSet>>> lazyMessage) {
        Runnable rIns = new Runnable(){

            @Override
            public void run() {
                Document doc = out.getDocument();
                int docLen = doc.getLength();
                try {
                    int off = 0;
                    Iterable message = (Iterable)lazyMessage.apply();
                    for (Pair m : message) {
                        String txt = (String)m.A();
                        AttributeSet attr = (AttributeSet)m.B();
                        if (txt == null || txt.length() <= 0) continue;
                        doc.insertString(docLen + off, txt, attr);
                        off += txt.length();
                    }
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            rIns.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(rIns);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void write(final JTextComponent out, final Iterable<Pair<String, AttributeSet>> message) {
        Runnable rIns = new Runnable(){

            @Override
            public void run() {
                Document doc = out.getDocument();
                int docLen = doc.getLength();
                try {
                    int off = 0;
                    for (Pair m : message) {
                        String txt = (String)m.A();
                        AttributeSet attr = (AttributeSet)m.B();
                        if (txt == null || txt.length() <= 0) continue;
                        doc.insertString(docLen + off, txt, attr);
                        off += txt.length();
                    }
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            rIns.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(rIns);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void write(final JTextComponent out, final String message, final AttributeSet textAttributes) {
        Runnable rIns = new Runnable(){

            @Override
            public void run() {
                Document doc = out.getDocument();
                int docLen = doc.getLength();
                try {
                    doc.insertString(docLen, message, textAttributes);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            rIns.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(rIns);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void write(final JTextComponent out, final String message, final Func0<AttributeSet> lazyTextAttributes) {
        Runnable rIns = new Runnable(){

            @Override
            public void run() {
                TextWriter.write(out, message, lazyTextAttributes == null ? null : (AttributeSet)lazyTextAttributes.apply());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            rIns.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(rIns);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void write(final JTextComponent out, final String message) {
        Runnable rIns = new Runnable(){

            @Override
            public void run() {
                TextWriter.write(out, message, (Func0<AttributeSet>)((Func0)null));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            rIns.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(rIns);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(TextWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

