/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.border.Border;

public class LineBorder
implements Border {
    protected double topWidth = 0.0;
    protected double topMargin = 0.0;
    protected double topPadding = 0.0;
    protected Color topColor = Color.black;
    protected double bottomWidth = 0.0;
    protected double bottomMargin = 0.0;
    protected double bottomPadding = 0.0;
    protected Color bottomColor = Color.black;
    protected double leftWidth = 0.0;
    protected double leftMargin = 0.0;
    protected double leftPadding = 0.0;
    protected Color leftColor = Color.black;
    protected double rightWidth = 0.0;
    protected double rightMargin = 0.0;
    protected double rightPadding = 0.0;
    protected Color rightColor = Color.black;

    public double getTopWidth() {
        return this.topWidth;
    }

    public void setTopWidth(double topWidth) {
        this.topWidth = topWidth;
    }

    public double getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(double topMargin) {
        this.topMargin = topMargin;
    }

    public double getTopPadding() {
        return this.topPadding;
    }

    public void setTopPadding(double topPadding) {
        this.topPadding = topPadding;
    }

    public Color getTopColor() {
        return this.topColor;
    }

    public void setTopColor(Color topColor) {
        this.topColor = topColor;
    }

    public LineBorder top(int width, int padding, int margin, Color color) {
        this.setTopWidth(width);
        this.setTopPadding(padding);
        this.setTopMargin(margin);
        this.setTopColor(color);
        return this;
    }

    public double getBottomWidth() {
        return this.bottomWidth;
    }

    public void setBottomWidth(double bottomWidth) {
        this.bottomWidth = bottomWidth;
    }

    public double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public double getBottomPadding() {
        return this.bottomPadding;
    }

    public void setBottomPadding(double bottomPadding) {
        this.bottomPadding = bottomPadding;
    }

    public Color getBottomColor() {
        return this.bottomColor;
    }

    public void setBottomColor(Color bottomColor) {
        this.bottomColor = bottomColor;
    }

    public LineBorder bottom(int width, int padding, int margin, Color color) {
        this.setBottomWidth(width);
        this.setBottomPadding(padding);
        this.setBottomMargin(margin);
        this.setBottomColor(color);
        return this;
    }

    public double getLeftWidth() {
        return this.leftWidth;
    }

    public void setLeftWidth(double leftWidth) {
        this.leftWidth = leftWidth;
    }

    public double getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(double leftMargin) {
        this.leftMargin = leftMargin;
    }

    public double getLeftPadding() {
        return this.leftPadding;
    }

    public void setLeftPadding(double leftPadding) {
        this.leftPadding = leftPadding;
    }

    public Color getLeftColor() {
        return this.leftColor;
    }

    public void setLeftColor(Color leftColor) {
        this.leftColor = leftColor;
    }

    public LineBorder left(int width, int padding, int margin, Color color) {
        this.setLeftWidth(width);
        this.setLeftPadding(padding);
        this.setLeftMargin(margin);
        this.setLeftColor(color);
        return this;
    }

    public double getRightWidth() {
        return this.rightWidth;
    }

    public void setRightWidth(double rightWidth) {
        this.rightWidth = rightWidth;
    }

    public double getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(double rightMargin) {
        this.rightMargin = rightMargin;
    }

    public double getRightPadding() {
        return this.rightPadding;
    }

    public void setRightPadding(double rightPadding) {
        this.rightPadding = rightPadding;
    }

    public Color getRightColor() {
        return this.rightColor;
    }

    public void setRightColor(Color rightColor) {
        this.rightColor = rightColor;
    }

    public LineBorder right(int width, int padding, int margin, Color color) {
        this.setRightWidth(width);
        this.setRightPadding(padding);
        this.setRightMargin(margin);
        this.setRightColor(color);
        return this;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        boolean rightLineSet;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        if (c == null) {
            return;
        }
        Graphics2D gs = (Graphics2D)g;
        double t = (this.topMargin >= 0.0 ? this.topMargin : 0.0) + (this.topPadding >= 0.0 ? this.topPadding : 0.0) + (this.topWidth >= 0.0 ? this.topWidth : 0.0);
        double b = (this.bottomMargin >= 0.0 ? this.bottomMargin : 0.0) + (this.bottomPadding >= 0.0 ? this.bottomPadding : 0.0) + (this.bottomWidth >= 0.0 ? this.bottomWidth : 0.0);
        double l = (this.leftMargin >= 0.0 ? this.leftMargin : 0.0) + (this.leftPadding >= 0.0 ? this.leftPadding : 0.0) + (this.leftWidth >= 0.0 ? this.leftWidth : 0.0);
        double r = (this.rightMargin >= 0.0 ? this.rightMargin : 0.0) + (this.rightPadding >= 0.0 ? this.rightPadding : 0.0) + (this.rightWidth >= 0.0 ? this.rightWidth : 0.0);
        Line2D.Double topLine = null;
        Line2D.Double bottomLine = null;
        Line2D.Double leftLine = null;
        Line2D.Double rightLine = null;
        Point2D.Double leftTopPnt = new Point2D.Double((double)x + l / 2.0, (double)y + t / 2.0);
        Point2D.Double rightTopPnt = new Point2D.Double((double)(x + width) - r / 2.0, (double)y + t / 2.0);
        Point2D.Double leftBottomPnt = new Point2D.Double((double)x + l / 2.0, (double)(y + height) - b / 2.0);
        Point2D.Double rightBottomPnt = new Point2D.Double((double)(x + width) - r / 2.0, (double)(y + height) - b / 2.0);
        boolean topLineSet = this.topWidth > 0.0 && this.topColor != null;
        boolean bottomLineSet = this.bottomWidth > 0.0 && this.bottomColor != null;
        boolean leftLineSet = this.leftWidth > 0.0 && this.leftColor != null;
        boolean bl = rightLineSet = this.rightWidth > 0.0 && this.rightColor != null;
        if (topLineSet) {
            topLine = new Line2D.Double(leftTopPnt, rightTopPnt);
        }
        if (bottomLineSet) {
            bottomLine = new Line2D.Double(leftBottomPnt, rightBottomPnt);
        }
        if (leftLineSet) {
            leftLine = new Line2D.Double(leftTopPnt, leftBottomPnt);
        }
        if (rightLineSet) {
            rightLine = new Line2D.Double(rightTopPnt, rightBottomPnt);
        }
        if (topLineSet) {
            gs.setStroke(new BasicStroke((float)this.topWidth));
            gs.setColor(this.topColor);
            gs.draw(topLine);
        }
        if (bottomLineSet) {
            gs.setStroke(new BasicStroke((float)this.bottomWidth));
            gs.setColor(this.bottomColor);
            gs.draw(bottomLine);
        }
        if (leftLineSet) {
            gs.setStroke(new BasicStroke((float)this.leftWidth));
            gs.setColor(this.leftColor);
            gs.draw(leftLine);
        }
        if (rightLineSet) {
            gs.setStroke(new BasicStroke((float)this.rightWidth));
            gs.setColor(this.rightColor);
            gs.draw(rightLine);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        double t = (this.topMargin >= 0.0 ? this.topMargin : 0.0) + (this.topPadding >= 0.0 ? this.topPadding : 0.0) + (this.topWidth >= 0.0 ? this.topWidth : 0.0);
        double b = (this.bottomMargin >= 0.0 ? this.bottomMargin : 0.0) + (this.bottomPadding >= 0.0 ? this.bottomPadding : 0.0) + (this.bottomWidth >= 0.0 ? this.bottomWidth : 0.0);
        double l = (this.leftMargin >= 0.0 ? this.leftMargin : 0.0) + (this.leftPadding >= 0.0 ? this.leftPadding : 0.0) + (this.leftWidth >= 0.0 ? this.leftWidth : 0.0);
        double r = (this.rightMargin >= 0.0 ? this.rightMargin : 0.0) + (this.rightPadding >= 0.0 ? this.rightPadding : 0.0) + (this.rightWidth >= 0.0 ? this.rightWidth : 0.0);
        return new Insets((int)t, (int)l, (int)b, (int)r);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

