/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.button;

import java.awt.AWTEvent;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import xyz.cofe.gui.swing.Icon;

public class DropDownButton
extends JButton {
    private javax.swing.Icon dropdownIco = null;
    private javax.swing.Icon dropdownIcoOver = null;
    private javax.swing.Icon dropdownIcoDisable = null;
    private int drowDownIconWidth = -1;
    private int drowDownIconHeight = -1;
    private PopupMenuListener popupMenuListener = new PopupMenuListener(){

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            DropDownButton.this.onPopupMenuWillBecomeVisible(e);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            DropDownButton.this.onPopupMenuWillBecomeInvisible(e);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            DropDownButton.this.onPopupMenuCanceled(e);
        }
    };
    protected boolean mouseOver = false;

    public DropDownButton() {
        this.initIcons();
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu popup) {
        JPopupMenu old = this.getComponentPopupMenu();
        if (old != null) {
            old.removePopupMenuListener(this.popupMenuListener);
        }
        super.setComponentPopupMenu(popup);
        if (popup != null) {
            popup.addPopupMenuListener(this.popupMenuListener);
        }
    }

    protected void onPopupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    protected void onPopupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    protected void onPopupMenuCanceled(PopupMenuEvent e) {
    }

    public DropDownButton(Action action) {
        super(action);
        this.initIcons();
    }

    public DropDownButton(Action action, JPopupMenu popupMenu) {
        super(action);
        this.initIcons();
        this.setComponentPopupMenu(popupMenu);
    }

    private void initIcons() {
        this.dropdownIco = new Icon(DropDownButton.class.getResource("dropdown-a.png"));
        this.dropdownIcoOver = new Icon(DropDownButton.class.getResource("dropdown-b.png"));
        this.dropdownIcoDisable = new Icon(DropDownButton.class.getResource("dropdown-c.png"));
        this.drowDownIconWidth = this.dropdownIco.getIconWidth();
        this.drowDownIconHeight = this.dropdownIco.getIconHeight();
    }

    protected void onMouseEnter(MouseEvent e) {
        this.repaint();
    }

    protected void onMouseExit(MouseEvent e) {
        this.repaint();
    }

    protected void onDropDownIcoPressed(MouseEvent e) {
        JPopupMenu pMenu = this.getComponentPopupMenu();
        if (pMenu == null) {
            return;
        }
        int h = this.getHeight();
        pMenu.show(this, 0, h - 1);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gs = (Graphics2D)g;
        javax.swing.Icon ico = this.isEnabled() ? (this.mouseOver ? this.dropdownIcoOver : this.dropdownIco) : this.dropdownIcoDisable;
        int w = this.getWidth();
        int h = this.getHeight();
        ico.paintIcon(this, g, w - this.drowDownIconWidth, h - this.drowDownIconHeight);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof MouseEvent) {
            int id = ((MouseEvent)e).getID();
            if (id == 504 && !this.mouseOver) {
                this.mouseOver = true;
                this.onMouseEnter((MouseEvent)e);
            }
            if (id == 505 && this.mouseOver) {
                this.mouseOver = false;
                this.onMouseExit((MouseEvent)e);
            }
            if (id == 501) {
                MouseEvent me = (MouseEvent)e;
                int eX = me.getX();
                int eY = me.getY();
                int w = this.getWidth();
                int h = this.getHeight();
                if (eX >= w - this.drowDownIconWidth && eY >= h - this.drowDownIconHeight && eX <= w && eY <= h) {
                    this.onDropDownIcoPressed(me);
                    return;
                }
                ActionListener[] aListeners = this.getActionListeners();
                Action a = this.getAction();
                if (a == null && (aListeners == null || aListeners.length < 1)) {
                    this.onDropDownIcoPressed(me);
                }
            }
        }
        super.processEvent(e);
    }
}

