/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.gui.swing.cell;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import xyz.cofe.gui.swing.bean.UiBean;
import xyz.cofe.gui.swing.cell.DashEditor;
import xyz.cofe.gui.swing.cell.GetDateFormat;
import xyz.cofe.gui.swing.cell.GetNumberFormat;
import xyz.cofe.gui.swing.cell.LineBorderRender;
import xyz.cofe.gui.swing.cell.SetDateFormat;
import xyz.cofe.gui.swing.cell.SetNumberFormat;
import xyz.cofe.gui.swing.cell.TextAliasing;

public class CellFormat
implements GetDateFormat,
SetDateFormat,
GetNumberFormat,
SetNumberFormat {
    private static final Logger logger = Logger.getLogger(CellFormat.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected NumberFormat numberFormat;
    protected DateFormat dateFormat;
    protected Integer maxLinesCount = -1;
    protected Integer maxLineLength = -1;
    protected Double textAlign = 0.0;
    protected Double halign = 0.0;
    protected Double valign = 0.0;
    protected Double padLeft = 0.0;
    protected Double padRight = 0.0;
    protected Double padTop = 0.0;
    protected Double padBottom = 0.0;
    protected Double textPadLeft = 0.0;
    protected Double textPadRight = 0.0;
    protected Double textPadTop = 0.0;
    protected Double textPadBottom = 0.0;
    protected TextAliasing textAliasing = TextAliasing.ON;
    protected Color color;
    protected Color backgroundColor;
    protected Font font;
    protected Icon icon;
    protected Double iconPadLeft = 0.0;
    protected Double iconPadRight = 0.0;
    protected Double iconPadTop = 0.0;
    protected Double iconPadBottom = 0.0;
    protected Dimension iconPlaceholder;
    protected boolean autoIconPlaceholder = true;
    protected Color borderLeftColor;
    protected float borderLeftWidth;
    protected float[] borderLeftDash;
    protected Color borderRightColor;
    protected float borderRightWidth;
    protected float[] borderRightDash;
    protected Color borderTopColor;
    protected float borderTopWidth;
    protected float[] borderTopDash;
    protected Color borderBottomColor;
    protected float borderBottomWidth;
    protected float[] borderBottomDash;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(CellFormat.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(CellFormat.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(CellFormat.class.getName(), method, result);
    }

    public CellFormat() {
    }

    public CellFormat(CellFormat sample) {
        if (sample != null) {
            this.textAlign = sample.textAlign;
            this.halign = sample.halign;
            this.valign = sample.valign;
            this.textPadLeft = sample.textPadLeft;
            this.textPadRight = sample.textPadRight;
            this.textPadTop = sample.textPadTop;
            this.textPadBottom = sample.textPadBottom;
            this.textAliasing = sample.textAliasing;
            this.color = sample.color;
            this.backgroundColor = sample.backgroundColor;
            this.font = sample.font;
            this.icon = sample.icon;
            this.iconPlaceholder = sample.iconPlaceholder != null ? new Dimension(sample.iconPlaceholder) : null;
            this.autoIconPlaceholder = sample.autoIconPlaceholder;
            this.padLeft = sample.padLeft;
            this.padTop = sample.padTop;
            this.padRight = sample.padRight;
            this.padBottom = sample.padBottom;
            this.iconPadLeft = sample.iconPadLeft;
            this.iconPadTop = sample.iconPadTop;
            this.iconPadBottom = sample.iconPadBottom;
            this.iconPadRight = sample.iconPadRight;
            this.borderLeftColor = sample.borderLeftColor;
            this.borderLeftWidth = sample.borderLeftWidth;
            this.borderLeftDash = sample.borderLeftDash;
            this.borderRightColor = sample.borderRightColor;
            this.borderRightWidth = sample.borderRightWidth;
            this.borderRightDash = sample.borderRightDash;
            this.borderTopColor = sample.borderTopColor;
            this.borderTopWidth = sample.borderTopWidth;
            this.borderTopDash = sample.borderTopDash;
            this.borderBottomColor = sample.borderBottomColor;
            this.borderBottomWidth = sample.borderBottomWidth;
            this.borderBottomDash = sample.borderBottomDash;
            if (sample.numberFormat != null) {
                this.numberFormat = (NumberFormat)sample.numberFormat.clone();
            }
            if (sample.dateFormat != null) {
                this.dateFormat = (DateFormat)sample.dateFormat.clone();
            }
            this.maxLineLength = sample.maxLineLength;
            this.maxLinesCount = sample.maxLinesCount;
        }
    }

    public CellFormat clone() {
        return new CellFormat(this);
    }

    public CellFormat reset() {
        this.textAlign = 0.0;
        this.halign = 0.0;
        this.valign = 0.0;
        this.textPadLeft = 0.0;
        this.textPadTop = 0.0;
        this.textPadBottom = 0.0;
        this.textPadRight = 0.0;
        this.textAliasing = TextAliasing.ON;
        this.color = null;
        this.backgroundColor = null;
        this.font = null;
        this.icon = null;
        this.iconPlaceholder = null;
        this.autoIconPlaceholder = true;
        this.padTop = this.padBottom = Double.valueOf(0.0);
        this.padRight = this.padBottom;
        this.padLeft = this.padBottom;
        this.iconPadTop = this.iconPadBottom = Double.valueOf(0.0);
        this.iconPadRight = this.iconPadBottom;
        this.iconPadLeft = this.iconPadBottom;
        this.borderBottomColor = null;
        this.borderTopColor = null;
        this.borderRightColor = null;
        this.borderLeftColor = null;
        this.borderBottomDash = null;
        this.borderTopDash = null;
        this.borderRightDash = null;
        this.borderLeftDash = null;
        this.borderBottomWidth = 0.0f;
        this.borderTopWidth = 0.0f;
        this.borderRightWidth = 0.0f;
        this.borderLeftWidth = 0.0f;
        this.numberFormat = null;
        this.dateFormat = null;
        return this;
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public CellFormat numberFormat(String pattern, DecimalFormatSymbols symb) {
        if (pattern == null) {
            this.numberFormat = null;
            return this;
        }
        this.numberFormat = symb != null ? new DecimalFormat(pattern) : new DecimalFormat(pattern, symb);
        return this;
    }

    public CellFormat numberFormat(String pattern) {
        if (pattern == null) {
            this.numberFormat = null;
            return this;
        }
        this.numberFormat = new DecimalFormat(pattern);
        return this;
    }

    @Override
    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public CellFormat dateFormat(String simpleDateFormat) {
        this.dateFormat = simpleDateFormat == null ? null : new SimpleDateFormat(simpleDateFormat);
        return this;
    }

    public CellFormat dateFormat(String simpleDateFormat, Locale loc) {
        this.dateFormat = simpleDateFormat == null ? null : (loc != null ? new SimpleDateFormat(simpleDateFormat, loc) : new SimpleDateFormat(simpleDateFormat));
        return this;
    }

    public CellFormat dateFormat(String simpleDateFormat, DateFormatSymbols symbls) {
        this.dateFormat = simpleDateFormat == null ? null : (symbls != null ? new SimpleDateFormat(simpleDateFormat, symbls) : new SimpleDateFormat(simpleDateFormat));
        return this;
    }

    public Integer getMaxLinesCount() {
        return this.maxLinesCount;
    }

    public void setMaxLinesCount(Integer maxLinesCount) {
        this.maxLinesCount = maxLinesCount;
    }

    public CellFormat maxLinesCount(Integer maxLinesCount) {
        this.maxLinesCount = maxLinesCount;
        return this;
    }

    public Integer getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(Integer maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public CellFormat maxLineLength(Integer maxLineLength) {
        this.maxLineLength = maxLineLength;
        return this;
    }

    public Double getTextAlign() {
        return this.textAlign;
    }

    public double getTextAlign(double defaultValue) {
        return this.textAlign != null ? this.textAlign : defaultValue;
    }

    public void setTextAlign(Double v) {
        this.textAlign = v;
    }

    public CellFormat textAlign(Double v) {
        this.textAlign = v;
        return this;
    }

    public Double getHalign() {
        return this.halign;
    }

    public double getHalign(double defaultValue) {
        return this.halign != null ? this.halign : defaultValue;
    }

    public void setHalign(Double v) {
        this.halign = v;
    }

    public CellFormat halign(Double v) {
        this.halign = v;
        return this;
    }

    public Double getValign() {
        return this.valign;
    }

    public double getValign(double defaultValue) {
        return this.valign != null ? this.valign : defaultValue;
    }

    public void setValign(Double v) {
        this.valign = v;
    }

    public CellFormat valign(Double v) {
        this.valign = v;
        return this;
    }

    public Double getPadLeft() {
        return this.padLeft;
    }

    public double getPadLeft(double defaultValue) {
        return this.padLeft != null ? this.padLeft : defaultValue;
    }

    public void setPadLeft(Double v) {
        this.padLeft = v;
    }

    public CellFormat padLeft(Double v) {
        this.padLeft = v;
        return this;
    }

    public Double getPadRight() {
        return this.padRight;
    }

    public double getPadRight(double defaultValue) {
        return this.padRight != null ? this.padRight : defaultValue;
    }

    public void setPadRight(Double v) {
        this.padRight = v;
    }

    public CellFormat padRight(Double v) {
        this.padRight = v;
        return this;
    }

    public Double getPadTop() {
        return this.padTop;
    }

    public double getPadTop(double defaultValue) {
        return this.padTop != null ? this.padTop : defaultValue;
    }

    public void setPadTop(Double v) {
        this.padTop = v;
    }

    public CellFormat padTop(Double v) {
        this.padTop = v;
        return this;
    }

    public Double getPadBottom() {
        return this.padBottom;
    }

    public double getPadBottom(double defaultValue) {
        return this.padBottom != null ? this.padBottom : defaultValue;
    }

    public void setPadBottom(Double v) {
        this.padBottom = v;
    }

    public CellFormat padBottom(Double v) {
        this.padBottom = v;
        return this;
    }

    public Double getTextPadLeft() {
        return this.textPadLeft;
    }

    public double getTextPadLeft(double defaultValue) {
        return this.textPadLeft != null ? this.textPadLeft : defaultValue;
    }

    public void setTextPadLeft(Double v) {
        this.textPadLeft = v;
    }

    public CellFormat textPadLeft(Double v) {
        this.textPadLeft = v;
        return this;
    }

    public Double getTextPadRight() {
        return this.textPadRight;
    }

    public double getTextPadRight(double defaultValue) {
        return this.textPadRight != null ? this.textPadRight : defaultValue;
    }

    public void setTextPadRight(Double v) {
        this.textPadRight = v;
    }

    public CellFormat textPadRight(Double v) {
        this.textPadRight = v;
        return this;
    }

    public Double getTextPadTop() {
        return this.textPadTop;
    }

    public double getTextPadTop(double defaultValue) {
        return this.textPadTop != null ? this.textPadTop : defaultValue;
    }

    public void setTextPadTop(Double v) {
        this.textPadTop = v;
    }

    public CellFormat textPadTop(Double v) {
        this.textPadTop = v;
        return this;
    }

    public Double getTextPadBottom() {
        return this.textPadBottom;
    }

    public double getTextPadBottom(double defaultValue) {
        return this.textPadBottom != null ? this.textPadBottom : defaultValue;
    }

    public void setTextPadBottom(Double v) {
        this.textPadBottom = v;
    }

    public CellFormat textPadBottom(Double v) {
        this.textPadBottom = v;
        return this;
    }

    public TextAliasing getTextAliasing() {
        return this.textAliasing;
    }

    public void setTextAliasing(TextAliasing textAliasing) {
        this.textAliasing = textAliasing;
    }

    public CellFormat textAliasing(TextAliasing aliasing) {
        this.textAliasing = aliasing;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public CellFormat color(Color color) {
        this.color = color;
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public CellFormat backgroundColor(Color color) {
        this.backgroundColor = color;
        return this;
    }

    public CellFormat bgColor(Color color) {
        this.backgroundColor = color;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public CellFormat font(Font f) {
        this.font = f;
        return this;
    }

    public CellFormat font(String fontName, float size, boolean bold, boolean italic) {
        if (fontName == null) {
            throw new IllegalArgumentException("fontName==null");
        }
        this.font = new Font(fontName, (bold ? 1 : 0) | (italic ? 2 : 0), 10).deriveFont(size);
        return this;
    }

    public CellFormat italic(boolean italic) {
        Font f = this.font;
        if (f != null) {
            int style = (f.isBold() ? 1 : 0) | (italic ? 2 : 0);
            this.font = f.deriveFont(style);
        }
        return this;
    }

    public CellFormat bold(boolean bld) {
        Font f = this.font;
        if (f != null) {
            int style = (bld ? 1 : 0) | (f.isItalic() ? 2 : 0);
            this.font = f.deriveFont(style);
        }
        return this;
    }

    public CellFormat fontSize(float pointSize) {
        Font f = this.font;
        if (f != null) {
            this.font = f.deriveFont(pointSize);
        }
        return this;
    }

    public CellFormat fontFamily(String name) {
        Font f = this.font;
        if (f != null && name != null) {
            this.font = f = new Font(name, f.getStyle(), f.getSize());
        } else if (f == null && name != null) {
            this.font = f = new Font(name, 0, 11);
        }
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public CellFormat icon(Icon ico) {
        this.icon = ico;
        return this;
    }

    public Double getIconPadLeft() {
        return this.iconPadLeft;
    }

    public double getIconPadLeft(double defaultValue) {
        return this.iconPadLeft != null ? this.iconPadLeft : defaultValue;
    }

    public void setIconPadLeft(Double v) {
        this.iconPadLeft = v;
    }

    public CellFormat iconPadLeft(Double v) {
        this.iconPadLeft = v;
        return this;
    }

    public Double getIconPadRight() {
        return this.iconPadRight;
    }

    public double getIconPadRight(double defaultValue) {
        return this.iconPadRight != null ? this.iconPadRight : defaultValue;
    }

    public void setIconPadRight(Double v) {
        this.iconPadRight = v;
    }

    public CellFormat iconPadRight(Double v) {
        this.iconPadRight = v;
        return this;
    }

    public Double getIconPadTop() {
        return this.iconPadTop;
    }

    public double getIconPadTop(double defaultValue) {
        return this.iconPadTop != null ? this.iconPadTop : defaultValue;
    }

    public void setIconPadTop(Double v) {
        this.iconPadTop = v;
    }

    public CellFormat iconPadTop(Double v) {
        this.iconPadTop = v;
        return this;
    }

    public Double getIconPadBottom() {
        return this.iconPadBottom;
    }

    public double getIconPadBottom(double defaultValue) {
        return this.iconPadBottom != null ? this.iconPadBottom : defaultValue;
    }

    public void setIconPadBottom(Double v) {
        this.iconPadBottom = v;
    }

    public CellFormat iconPadBottom(Double v) {
        this.iconPadBottom = v;
        return this;
    }

    public Dimension getIconPlaceholder() {
        return this.iconPlaceholder;
    }

    public void setIconPlaceholder(Dimension iconPlaceholder) {
        this.iconPlaceholder = iconPlaceholder;
    }

    public CellFormat iconPlaceholder(Dimension placeholder) {
        this.setIconPlaceholder(this.iconPlaceholder);
        return this;
    }

    public CellFormat iconPlaceholder(double width, double height) {
        if (width > 0.0 && height > 0.0) {
            this.setIconPlaceholder(new Dimension((int)width, (int)height));
        }
        return this;
    }

    public CellFormat iconPlaceholder(int width, int height) {
        this.setIconPlaceholder(new Dimension(width, height));
        return this;
    }

    public boolean isAutoIconPlaceholder() {
        return this.autoIconPlaceholder;
    }

    public void setAutoIconPlaceholder(boolean autoIconPlaceholder) {
        this.autoIconPlaceholder = autoIconPlaceholder;
    }

    public CellFormat autoIconPlaceholder(boolean autoIconPlaceholder) {
        this.autoIconPlaceholder = autoIconPlaceholder;
        return this;
    }

    public Color getBorderLeftColor() {
        return this.borderLeftColor;
    }

    public void setBorderLeftColor(Color borderLeftColor) {
        this.borderLeftColor = borderLeftColor;
    }

    public float getBorderLeftWidth() {
        return this.borderLeftWidth;
    }

    public void setBorderLeftWidth(float borderLeftWidth) {
        this.borderLeftWidth = borderLeftWidth;
    }

    @UiBean(propertyEditor=DashEditor.class)
    public float[] getBorderLeftDash() {
        if (this.borderLeftDash == null) {
            return new float[0];
        }
        return this.borderLeftDash;
    }

    public void setBorderLeftDash(float[] dash) {
        this.borderLeftDash = dash;
    }

    public CellFormat borderLeft(Color color, float width, float ... dash) {
        this.borderLeftColor = color;
        this.borderLeftWidth = width;
        this.borderLeftDash = dash;
        return this;
    }

    public Color getBorderRightColor() {
        return this.borderRightColor;
    }

    public void setBorderRightColor(Color color) {
        this.borderRightColor = color;
    }

    public float getBorderRightWidth() {
        return this.borderRightWidth;
    }

    public void setBorderRightWidth(float width) {
        this.borderRightWidth = width;
    }

    @UiBean(propertyEditor=DashEditor.class)
    public float[] getBorderRightDash() {
        if (this.borderRightDash == null) {
            return new float[0];
        }
        return this.borderRightDash;
    }

    public void setBorderRightDash(float[] dash) {
        this.borderRightDash = dash;
    }

    public CellFormat borderRight(Color color, float width, float ... dash) {
        this.borderRightColor = color;
        this.borderRightWidth = width;
        this.borderRightDash = dash;
        return this;
    }

    public Color getBorderTopColor() {
        return this.borderTopColor;
    }

    public void setBorderTopColor(Color color) {
        this.borderTopColor = color;
    }

    public float getBorderTopWidth() {
        return this.borderTopWidth;
    }

    public void setBorderTopWidth(float width) {
        this.borderTopWidth = width;
    }

    @UiBean(propertyEditor=DashEditor.class)
    public float[] getBorderTopDash() {
        if (this.borderTopDash == null) {
            return new float[0];
        }
        return this.borderTopDash;
    }

    public void setBorderTopDash(float[] dash) {
        this.borderTopDash = dash;
    }

    public CellFormat borderTop(Color color, float width, float ... dash) {
        this.borderTopColor = color;
        this.borderTopWidth = width;
        this.borderTopDash = dash;
        return this;
    }

    public Color getBorderBottomColor() {
        return this.borderBottomColor;
    }

    public void setBorderBottomColor(Color color) {
        this.borderBottomColor = color;
    }

    public float getBorderBottomWidth() {
        return this.borderBottomWidth;
    }

    public void setBorderBottomWidth(float width) {
        this.borderBottomWidth = width;
    }

    @UiBean(propertyEditor=DashEditor.class)
    public float[] getBorderBottomDash() {
        if (this.borderBottomDash == null) {
            return new float[0];
        }
        return this.borderBottomDash;
    }

    public void setBorderBottomDash(float[] dash) {
        this.borderBottomDash = dash;
    }

    public CellFormat borderBottom(Color color, float width, float ... dash) {
        this.borderBottomColor = color;
        this.borderBottomWidth = width;
        this.borderBottomDash = dash;
        return this;
    }

    public void applyBorder(LineBorderRender lbr) {
        if (lbr == null) {
            return;
        }
        CellFormat cf = this;
        LineBorderRender lineBorderRender = lbr;
        lineBorderRender.left(cf.getBorderLeftColor(), cf.getBorderLeftWidth(), cf.getBorderLeftDash());
        lineBorderRender.right(cf.getBorderRightColor(), cf.getBorderRightWidth(), cf.getBorderRightDash());
        lineBorderRender.top(cf.getBorderTopColor(), cf.getBorderTopWidth(), cf.getBorderTopDash());
        lineBorderRender.bottom(cf.getBorderBottomColor(), cf.getBorderBottomWidth(), cf.getBorderBottomDash());
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

